package gov.va.med.mhv.sm.web.actions;

import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.foundation.service.response.messages.MessageUtils;
import gov.va.med.mhv.sm.dao.FolderDao;
import gov.va.med.mhv.sm.enumeration.MessagesOrderByEnum;
import gov.va.med.mhv.sm.enumeration.MessagesPageEnum;
import gov.va.med.mhv.sm.enumeration.SortOrderEnum;
import gov.va.med.mhv.sm.enumeration.SystemFolderEnum;
import gov.va.med.mhv.sm.model.Addressee;
import gov.va.med.mhv.sm.model.Administrator;
import gov.va.med.mhv.sm.model.Annotation;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.Facility;
import gov.va.med.mhv.sm.model.Folder;
import gov.va.med.mhv.sm.model.Message;
import gov.va.med.mhv.sm.model.MessagesPage;
import gov.va.med.mhv.sm.model.Thread;
import gov.va.med.mhv.sm.service.MailboxService;
import gov.va.med.mhv.sm.service.MessageService;
import gov.va.med.mhv.sm.service.TriageGroupService;
import gov.va.med.mhv.sm.service.UserManagementService;
import gov.va.med.mhv.sm.web.session.ManageUserSurrogatesSession;
import gov.va.med.mhv.sm.web.util.ClinicianVO;
import gov.va.med.mhv.sm.web.util.FolderVO;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.opensymphony.xwork2.Preparable;

public class ViewStaffMessages extends BaseSMAdminAction 
	implements Preparable 
{
	private static final long serialVersionUID = 1l;
	
	private static final Log LOG = LogFactory.getLog(ViewStaffMessages.class);

	private static final String SESSION_ATTRIBUTE = ViewStaffMessages.class.toString() + ".session";
	
	private static final String CANCEL = "cancel";
	private static final String SELECTED_VISN = "selectedVISN";
	private static final String SELECTED_FACILITY = "selectedFacility";
	private static final String WARNING_SUCCESS = "warningSuccess";
	private static final String ERROR = "error";

	private static final gov.va.med.mhv.foundation.service.response.messages.Message NO_CLINICIAN_SELECTED = MessageUtils.
		createErrorMessage("manage.info.no.clinician.selected", null, null);
	private static final gov.va.med.mhv.foundation.service.response.messages.Message NO_FACILITY_SELECTED = MessageUtils.
		createErrorMessage("manage.info.no.facility.selected", null, null);
	private static final gov.va.med.mhv.foundation.service.response.messages.Message NO_VISN_SELECTED = MessageUtils.
		createErrorMessage("manage.info.no.visn.selected", null, null);

	private UserManagementService userManagementService = null;
	private TriageGroupService triageGroupService = null;
	
	private Administrator admin = null;
	private ManageUserSurrogatesSession sessionData = null;
	private Long visnId = null;
	private Long facilityId = null;
	private Long clinicianId = null;
	private String doSelect = null;
	private String doCancel = null;
	private String doApply = null;
	private String okSubmit=null;

	
	private Long currentFolderId;

	public static String CURRENT_ADDRESSEE = "CurrentAddressee";
	public static String CURRENT_MESSAGE = "CurrentMessage";
	public static String CURRENT_FOLDER = "CurrentFolder";
	public static String PREVIOUS_MESSAGES = "PreviousMessages";
	
	public static String FOLDERS = "FOLDERS";
	private Long messageId;
	
	public void prepare() throws Exception {
		super.prepare();
		
		userManagementService = getUserManagementService();
		triageGroupService = getTriageGroupService();
		
		if (getSessionAttribute(SESSION_ATTRIBUTE) == null) {
			sessionData = new ManageUserSurrogatesSession();
			setSessionAttribute(SESSION_ATTRIBUTE, sessionData);
		} else {
			sessionData = (ManageUserSurrogatesSession) getSessionAttribute(SESSION_ATTRIBUTE);
		}
		
		admin = getCurrentUser();
		assert admin != null : "No administrator logged in";
	}

	public Long getVisnId() {
		return visnId;
	}

	public void setVisnId(Long visnId) {
		this.visnId = visnId;
	}

	public Long getFacilityId() {
		return facilityId;
	}

	public void setFacilityId(Long facilityId) {
		this.facilityId = facilityId;
	}

	public Long getClinicianId() {
		return clinicianId;
	}

	public void setClinicianId(Long clinicianId) {
		this.clinicianId = clinicianId;
	}

	public String getDoCancel() {
		return doCancel;
	}
	public void setDoCancel(String doCancel) {
		this.doCancel = doCancel;
	}

	public String getDoSelect() {
		return doSelect;
	}
	public void setDoSelect(String doSelect) {
		this.doSelect = doSelect;
	}

	public String getDoApply() {
		return doApply;
	}
	public void setDoApply(
		String doSelectClinicianSurrogate) 
	{
		this.doApply = doSelectClinicianSurrogate;
	}

	public ManageUserSurrogatesSession getSessionData() {
		return sessionData;
	}
	public void setSessionData(ManageUserSurrogatesSession sessionData) {
		this.sessionData = sessionData;
	}

	/**
	 * Handles the showSelectVisnView action.
	 * @return The action result: Error or Success
	 */
	public String showSelectVisnView() {
		assert sessionData != null : "No session data";
		sessionData.setVisns(getAdministeredVisns());
		String result = autoSelectVisn();
		if (result != null) {
			return result;
		}
		// Could not preselect a VISN
		clearSelectedVisn();
		return SUCCESS;
	}
	
	/**
	 * Handles the selectVisn action.
	 * @return The action result: Cancel, Error or Success 
	 */
	public String selectVisn(){
		assert sessionData != null : "No session data";
		if (doCancel()) {
			return cancel();
		}
		if (!doSelect()) {
			if (sessionData.getSelectedVisnId() != null) {
				// Changing the selected facility
				return SUCCESS;
			}
			return handleUnexpectedError();
		}
		if (!hasSelected(getVisnId())) {
			return handleError(NO_VISN_SELECTED);
		}

		sessionData.setSelectedVisnId(getVisnId());
		loadFacilities();
		String result = autoSelectFacility();
		if (result != null) {
			sessionData.setPopWin("warningMessage");
			return result;
		}
		// Could not preselect a facility
		clearSelectedFacility();
		
		return SUCCESS;
	}
	
	/**
	 * Handles the selectFacility action.
	 * @return The action result: Cancel, Error or Success 
	 */
	public String selectFacility(){
		assert sessionData != null : "No session data";
		if (doCancel()) {
			return cancel();
		}
		if (!doSelect()) {
			
			if (sessionData.getSelectedFacilityId() != null) {
				// Assume selecting another user
				return SUCCESS;
			}
			return handleUnexpectedError();
		}
		if (!hasSelected(getFacilityId())) {
			sessionData.setPopWin("");
			return handleError(NO_FACILITY_SELECTED);
		}
		sessionData.setPopWin("warningMessage");
		sessionData.setSelectedFacilityId(getFacilityId());
		return loadClinicians();
	}
	
	/**
	 * Handles the selectClinician action.
	 * @return The action result: Cancel, Error or Success 
	 */
	public String selectClinician() {
		
		if(okSubmit!=null){
			sessionData.setPopWin("");
			return WARNING_SUCCESS;
		}
		assert sessionData != null : "No session data";

		if (doCancel()) 
		{
			return cancel();
		}

		if(doSelect != null)
		{
			if (!hasSelected(getClinicianId())) {
				addActionError("Please select a provider or staff member");
				return ERROR;
			}
		sessionData.setSelectedClinicianId(getClinicianId());
		
		//Load the clinician and the list of folders then pick their inbox by default
		
		UserManagementService userManagementService = (UserManagementService) getBean("userManagementService");
		ServiceResponse<Clinician> userResponse = userManagementService.fetchClinician(getClinicianId());
		
		Clinician clinician = userResponse.getPayload();
		MailboxService mailboxService = (MailboxService) getBean("mailboxService");
		mailboxService.getMailbox(clinician);
		
		List<Clinician> list = new ArrayList<Clinician>();
		list.add(clinician);
		sessionData.setClinicians(list);
		
		Map<Long, Folder> folders = clinician.getMailbox().getFolders();
		Folder folder = folders.get(SystemFolderEnum.INBOX.getId());
		setSessionAttribute(CURRENT_FOLDER, folder);
		
		List<FolderVO> sorted = FolderVO.createFolderVOList(folders.values());
		getRequest().setAttribute(FOLDERS, sorted);
		getRequest().setAttribute(CURRENT_FOLDER, folder);
		
		}
		
		return SUCCESS;
	}
	
	@SuppressWarnings("unchecked")
	public Map<Long,Folder> getFolders() {
		List<Clinician> clinicians = (List)sessionData.getClinicians();
		return clinicians.get(0).getMailbox().getFolders();
	}
	
	public void setCurrentFolderId(Long folderId) {
		this.currentFolderId = folderId;
	}
	
	public Long getCurrentFolderId() {
		return this.currentFolderId;
	}
	
	public String chooseFolder() {
		//TODO
		//Grab the folder selected from getCurrentFolder()
		//Change the folder
		
		Clinician c = (Clinician)sessionData.getClinicians().toArray()[0];
		
		Map<Long, Folder> folders = c.getMailbox().getFolders();
		Folder folder = folders.get(getCurrentFolderId());
		setSessionAttribute(CURRENT_FOLDER, folder);
		currentFolderId = folder.getId();
		
		//Populate the corresponding messages for the folder.
		MailboxService mailboxService = (MailboxService) getBean("mailboxService");
		mailboxService.getMessages(folder);
		
		List<FolderVO> sorted = FolderVO.createFolderVOList(folders.values());
		getRequest().setAttribute(FOLDERS, sorted);
		getRequest().setAttribute(CURRENT_FOLDER, folder);
		
		return SUCCESS;
	}
	
	public Log getLOG() { 
		return LOG;
	}

	protected String cancel() {
		sessionData.clear();
		return CANCEL;
	}

	/**
	 * Indicates the Cancel button was pushed.
	 * @return True if the Cancel button was pushed; false otherwise.
	 */
	private boolean doCancel() {
		return !StringUtils.isBlank(getDoCancel());
	}

	/**
	 * Indicates the Select button was pushed.
	 * @return True if the Select button was pushed; false otherwise.
	 */
	private boolean doSelect() {
		return !StringUtils.isBlank(getDoSelect());
	}

	private String autoSelectVisn() {
		if (sessionData.getCanChangeVisn()) {
			return null;
		}
		if (!forceSelectVisn()) {
			log().error("Unable to force facility. Administrator '" +
					admin.getId() + "' may not have access to any VISNs " +
				"or facilities");
			return handleUnexpectedError();
		}
		loadFacilities();
		String result = autoSelectFacility();
		return (result != null) ? result : SELECTED_VISN;
	}

	private boolean forceSelectVisn() {
		if (sessionData.getVisns() == null) {
			return false;
		}
		Iterator<Facility> i = sessionData.getVisns().iterator();
		if ((i == null) || !i.hasNext()) {
			return false;
		}
		visnId = i.next().getId();
		sessionData.setSelectedVisnId(visnId);
		return visnId != null; 
	}
	
	private String autoSelectFacility() {
		if (sessionData.getCanChangeFacility()) {
			return null;
		}
		if (!forceSelectFacility()) {
			log().error("Unable to force facility. Administrator '" +
					admin.getId() + "' may not have access to any VISNs " +
				"or facilities");
			return handleUnexpectedError();
		}
		return (ERROR.equals(loadClinicians())) ? ERROR : SELECTED_FACILITY;
	}

	private boolean forceSelectFacility() {
		if (sessionData.getFacilities() == null) {
			return false;
		}
		Iterator<Facility> i = sessionData.getFacilities().iterator();
		if ((i == null) || !i.hasNext()) {
			return false;
		}
		facilityId = i.next().getId();
		sessionData.setSelectedFacilityId(facilityId);
		return facilityId != null; 
	}

	private String loadFacilities() {
		Facility visn = sessionData.getSelectedVisn();
		Collection<Facility> facilities = getAdministeredFacilitiesInVisn(visn);
		sessionData.setFacilities(facilities);
		return SUCCESS;
	}
	
	private String loadClinicians() {
		return loadClinicians(null);
	}
	
	private String loadClinicians(Clinician selectedClinician) {
		CollectionServiceResponse<Clinician> response = userManagementService.
			getCliniciansForStation(sessionData.getSelectedStationNumber());
		if (handleMessages(response)) {
			return ERROR;
		}
		// The assumption is made that the clinicians in the 
		// response are ordered by name (that is: last name, first name)
		
		
		sessionData.setClinicians(response.getCollection());
		ArrayList cliniciansWithProviderList = new ArrayList();
			for(Clinician clinician:sessionData.getClinicians()){
			ClinicianVO clinicianVO = new ClinicianVO();
			clinicianVO.setClinicianId(clinician.getId());
			//The user clinical type id should always be there, but due to incorrect data (bug: 5464)
			//some clinicians have missing clinical user type id.
			//to avoid the 500 internal error check for null pointer before getting the type.
			String userType = "";
			if(clinician.getClinicalUserType() != null){ 
				userType = clinician.getClinicalUserType().getName();
			}
			
			clinicianVO.setClincianFullName(clinician.getLastName()+", "+clinician.getFirstName()+" ("+userType+")");
			cliniciansWithProviderList.add(clinicianVO);
		}
	    setSessionAttribute("cliniciansWithProviderList",cliniciansWithProviderList);
		clearSelectedClinician();
		if (selectedClinician != null) {
			sessionData.setSelectedClinicianId(selectedClinician.getId());
		}
		
		return SUCCESS;
	}
	
	private boolean hasSelected(Long id) {
		return (id != null) && (id != 0L) && (id != -1L);
	}
	private void clearSelectedVisn() {
		sessionData.setSelectedVisnId(null);
		clearSelectedFacility();
	}
	private void clearSelectedFacility() {
		sessionData.setSelectedFacilityId(null);
		clearSelectedClinician();
	}
	private void clearSelectedClinician() {
		sessionData.setSelectedClinicianId(null);
	}
	
	// VIEW MESSAGE
	public String viewMessage() {
		MessageService messageService = (MessageService) getBean("messageService");
		Message mesg = messageService.fetchMessage(messageId).getPayload();
		getRequest().setAttribute(CURRENT_MESSAGE,mesg);
		
		Folder f = getActiveFolder();
		
		Clinician c = (Clinician)sessionData.getClinicians().toArray()[0];
		Map<Long, Folder> folders = c.getMailbox().getFolders();
		
		List<FolderVO> sorted = FolderVO.createFolderVOList(folders.values());
		getRequest().setAttribute(FOLDERS, sorted);
		getRequest().setAttribute(CURRENT_FOLDER, f);
		
		MessagesPage mp = f.getMessages();
		int index = getMessageIndex(mp, messageId);
		Addressee a = mp.getElements().get(index);
		//Not sure if this is needed but we need to fetch the owner
		//before we loose the hibernate session.
//		a.getOwner().getFirstName();
//		a.getMessage();
//		a.getReadDate();
		
		List<Message> prevThreadMessages = getThreadMessages(mesg);
		getRequest().setAttribute(CURRENT_ADDRESSEE, a);
		getRequest().setAttribute(CURRENT_MESSAGE, mesg);
		getRequest().setAttribute(PREVIOUS_MESSAGES, prevThreadMessages);
		
		return SUCCESS;
	}
	
	public Long getMessageId() {
		return messageId;
	}

	public void setMessageId(Long messageId) {
		this.messageId = messageId;
	}

	// PAGINATION
	private void fetchPage(MessagesPageEnum direction){
		MailboxService mailboxService = (MailboxService) getBean("mailboxService");
		ServiceResponse<Folder> response = mailboxService.getMessages(getActiveFolder(), direction);
		Folder f = response.getPayload();
		setSessionAttribute(CURRENT_FOLDER, f);
		
		Clinician c = (Clinician)sessionData.getClinicians().toArray()[0];
		Map<Long, Folder> folders = c.getMailbox().getFolders();
		currentFolderId = f.getId();
		
		List<FolderVO> sorted = FolderVO.createFolderVOList(folders.values());
		getRequest().setAttribute(FOLDERS, sorted);
		getRequest().setAttribute(CURRENT_FOLDER, f);
	}
	
	private Folder getActiveFolder() {
		return (Folder)getSessionAttribute(CURRENT_FOLDER);
	}
	
	public String first(){
		Folder activeFolder = getActiveFolder();
		if(activeFolder.getMessages().getPageNumber() == 0){
			// don't do anything; we are already on the first page
			return SUCCESS;
		}
		fetchPage(MessagesPageEnum.FIRST);
		return SUCCESS;
	}
	
	public String last(){
		Folder activeFolder = getActiveFolder();
		if(activeFolder.getMessages().isLastPage()){
			// don't do anything; we are already on the last page
			return SUCCESS;
		}
		fetchPage(MessagesPageEnum.LAST);
		return SUCCESS;
	}
	
	public String loadCurrentPage(){
		Folder activeFolder = getActiveFolder();
		fetchPage(MessagesPageEnum.CURRENT);
		return SUCCESS;
	}
	
	public String next(){
		Folder activeFolder = getActiveFolder();
		if(!activeFolder.getMessages().hasNextPage()){
			// don't do anything; there is not a next page
			return SUCCESS;
		}
		fetchPage(MessagesPageEnum.NEXT);
		return SUCCESS;
	}
	
	public String prev(){
		Folder activeFolder = getActiveFolder();
		if(!activeFolder.getMessages().hasPreviousPage()){
			// don't do anything; there is not a previous
			return SUCCESS;
		}
		fetchPage(MessagesPageEnum.PREV);
		return SUCCESS;
	}
	
	
	private List<Message> getThreadMessages(Message message) {
		List<Message> result = new ArrayList<Message>();
		Thread thread = message.getThread();
		Folder folder = (Folder)getActiveFolder();
		if (thread != null) {
		    // if block(folder.getName().equals("Completed") implemented for Bug#5342. 
			//    Completed folder required to display the message thread.
			if(folder.getName().equals("Completed")){
				for (Message msg : thread.getMessages()) {
					if(msg.getId()!= message.getId()){
						result.add(msg);
					}
				}
			}
			else
			{
				for (Message msg : thread.getMessages()) {
					if (msg.getCreatedDate().before(message.getCreatedDate()) && msg.getSentDate() != null){
						result.add(msg);
					}
				}
				result.add(message);
			}
			Collections.sort(result, new Comparator<Message>() {
				public int compare(Message msg1, Message msg2) {
					if (msg1 == null || msg1.getSentDate() == null)
						return 1;
					else if (msg2 == null || msg2.getSentDate() == null)
						return -1;
					else {
						Date date1 = msg1.getSentDate();
						Date date2 = msg2.getSentDate();
						if (date2.after(date1))
							return 1;
						else if (date2.before(date1))
							return -1;
						else
							return 0;
					}
				}
			});
		}
		
		return result;
	}
	
	private int getMessageIndex(MessagesPage mp, Long messageId) {
		int notFoundResult = -1;
		for (int i = 0; i < mp.getPageSize(); i++) {
			Addressee a = mp.getElements().get(i);
			if (a.getMessage().getId().compareTo(messageId) == 0) {
				// found correct message
				return i;
			}
		}
		return notFoundResult;
	}
	
	public static final Comparator<Annotation> ANNOTATION_SORTER = new Comparator<Annotation>() {
		public int compare(Annotation a, Annotation b) {
			if (a == null || a.getCreatedDate() == null)
				return 1;
			else if (b == null || b.getCreatedDate() == null)
				return -1;
			else {
				Date date1 = a.getCreatedDate();
				Date date2 = b.getCreatedDate();
				if (date2.after(date1))
					return 1;
				else if (date2.before(date1))
					return -1;
				else
					return 0;
			}
		}
	};
	
	// SORTING SUPPORT
	public String sort() {
		MessagesOrderByEnum defaultColumn;
		MessagesOrderByEnum column;
		SortOrderEnum sort = SortOrderEnum.ASC;
		Folder currentFolder = getActiveFolder();
		boolean columnChange = false;

		if (currentFolder.getId() == SystemFolderEnum.DRAFTS.getId()) {
			defaultColumn = MessagesOrderByEnum.CREATED_DATE;
		} else {
			defaultColumn = MessagesOrderByEnum.DATE;
		}

		try {
			String y;
			y = getRequest().getParameter("column");
			column = MessagesOrderByEnum.valueOf(Integer.parseInt(y));
		} catch (Exception e) {
			// there was an error default to something normal
			column = defaultColumn;
		}

		// If the field clicked is "Date" and is a draft folder then use CREATED_DATE
		if (column == MessagesOrderByEnum.DATE
				&& currentFolder.getId() == SystemFolderEnum.DRAFTS.getId()) {
			column = MessagesOrderByEnum.CREATED_DATE;
		}

		// if nothing has changed then assume that they want to
		// reverse the sort       
		if (currentFolder.getOrderBy() == column) {
			if (currentFolder.getSortOrder() == SortOrderEnum.ASC) {
				sort = SortOrderEnum.DESC;
			} else {
				sort = SortOrderEnum.ASC;
			}
		} else {
			columnChange = true;
			// they have changed folders so we need to set the sort order
			// to the default for that column.  ASC for everything but
			// DATE which is DESC.
			if (column == MessagesOrderByEnum.DATE
					|| column == MessagesOrderByEnum.CREATED_DATE) {
				sort = SortOrderEnum.DESC;
			} else {
				sort = SortOrderEnum.ASC;
			}
		}

		currentFolder.setSortOrder(sort);
		currentFolder.setOrderBy(column);

		MailboxService mailboxService = (MailboxService) getBean("mailboxService");

		// if the column changes then we need to go to the first page of the
		// pagination
		if (columnChange) {
			mailboxService.getMessages(currentFolder, MessagesPageEnum.FIRST);
		} else {
			mailboxService.getMessages(currentFolder);
		}

		setSessionAttribute(CURRENT_FOLDER, currentFolder);
		
		Clinician c = (Clinician) sessionData.getClinicians().toArray()[0];
		Map<Long, Folder> folders = c.getMailbox().getFolders();
		currentFolderId = currentFolder.getId();

		List<FolderVO> sorted = FolderVO.createFolderVOList(folders.values());
		getRequest().setAttribute(FOLDERS, sorted);
		getRequest().setAttribute(CURRENT_FOLDER, currentFolder);

		return SUCCESS;
	}

	public String getOkSubmit() {
		return okSubmit;
	}

	public void setOkSubmit(String okSubmit) {
		this.okSubmit = okSubmit;
	}

	
}
