package gov.va.med.mhv.sm.web.actions;

import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.foundation.service.response.messages.Message;
import gov.va.med.mhv.foundation.service.response.messages.MessageUtils;
import gov.va.med.mhv.sm.enumeration.ParticipantTypeEnum;
import gov.va.med.mhv.sm.model.Administrator;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.Facility;
import gov.va.med.mhv.sm.model.MailParticipant;
import gov.va.med.mhv.sm.model.Surrogate;
import gov.va.med.mhv.sm.model.TriageGroup;
import gov.va.med.mhv.sm.service.TriageGroupService;
import gov.va.med.mhv.sm.service.UserManagementService;
import gov.va.med.mhv.sm.util.DateUtils;
import gov.va.med.mhv.sm.web.form.AssignSurrogates;
import gov.va.med.mhv.sm.web.form.StaffOrTriageVO;
import gov.va.med.mhv.sm.web.session.ManageUserSurrogatesSession;

import gov.va.med.mhv.sm.web.util.ClinicianVO;
import gov.va.med.mhv.sm.web.session.ManageUserSurrogatesSession.SurrogateType;

import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.opensymphony.xwork2.Preparable;

public class ManageUserSurrogates extends BaseSMAdminAction
	implements Preparable
{
	private static final long serialVersionUID = 291273525477722793L;

	private static final Log LOG = LogFactory.getLog(ManageUserSurrogates.class);

	private static final String SESSION_ATTRIBUTE = ManageUserSurrogates.class.toString() + ".session";

//	private static final String SURROGATE_TYPE_PARAMETER = "surrogateType";
//	private final String SURROGATE_SETUP_MESSAGE="Your surrogate has been successfully set up";
//	private static final Message NO_SURROGATE_SELECTED = MessageUtils.createErrorMessage("manage.surrogate.no.surrogate.selected", null, null);

	private static final String CANCEL = "cancel";
	private static final String SELECTED_VISN = "selectedVISN";
	private static final String SELECTED_FACILITY = "selectedFacility";

	private static final Message NO_CLINICIAN_SELECTED = MessageUtils.createErrorMessage("manage.surrogate.no.clinician.selected", null, null);
	private static final Message NO_FACILITY_SELECTED = MessageUtils.createErrorMessage("manage.surrogate.no.facility.selected", null, null);
	private static final Message NO_VISN_SELECTED = MessageUtils.createErrorMessage("manage.surrogate.no.visn.selected", null, null);

	private UserManagementService userManagementService = null;
	private TriageGroupService triageGroupService = null;
	private Administrator admin = null;
	private ManageUserSurrogatesSession sessionData = null;
	private Long visnId = null;
	private Long facilityId = null;
	private Long clinicianId = null;
	private Long surrogateId = null;
	private String doSelect = null;
	private String doCancel = null;
	private String doApply = null;

	public static final String SURROGATES = "SURROGATES";
	public static final String STAFFANDTRIAGE = "STAFFANDTRIAGE";
	public static String SURROGATE_DEFAULT_VALUE = "-- Select a Staff/Triage Group --";
	private AssignSurrogates[] assignSurrogates = new AssignSurrogates[5];
	public static final String CLINICIAN_USER = "CLINICIAN_USER";
	private final String SURROGATE_SETUP_MESSAGE="Your surrogate(s) have been successfully saved";


	public void prepare() throws Exception {
		super.prepare();

		userManagementService = getUserManagementService();
		triageGroupService = getTriageGroupService();

		if (getSessionAttribute(SESSION_ATTRIBUTE) == null) {
			sessionData = new ManageUserSurrogatesSession();
			setSessionAttribute(SESSION_ATTRIBUTE, sessionData);
		} else {
			sessionData = (ManageUserSurrogatesSession)getSessionAttribute(SESSION_ATTRIBUTE);
		}

		admin = getCurrentUser();
		assert admin != null : "No administrator logged in";

//		Initialize assignsurrogates to have empty objects.
		for( int i = 0; i < assignSurrogates.length; i++ ) {
			assignSurrogates[i] = new AssignSurrogates();
		}
	}

	public Long getVisnId() {
		return visnId;
	}
	public void setVisnId(Long visnId) {
		this.visnId = visnId;
	}

	public Long getFacilityId() {
		return facilityId;
	}
	public void setFacilityId(Long facilityId) {
		this.facilityId = facilityId;
	}

	public Long getClinicianId() {
		return clinicianId;
	}
	public void setClinicianId(Long clinicianId) {
		this.clinicianId = clinicianId;
	}

	public Long getSurrogateId() {
		return surrogateId;
	}
	public void setSurrogateId(Long surrogateId) {
		this.surrogateId = surrogateId;
	}

	public String getDoCancel() {
		return doCancel;
	}
	public void setDoCancel(String doCancel) {
		this.doCancel = doCancel;
	}

	public String getDoSelect() {
		return doSelect;
	}
	public void setDoSelect(String doSelect) {
		this.doSelect = doSelect;
	}

	public String getDoApply() {
		return doApply;
	}
	public void setDoApply(String doSelectClinicianSurrogate)
	{
		this.doApply = doSelectClinicianSurrogate;
	}

	public ManageUserSurrogatesSession getSessionData() {
		return sessionData;
	}
	public void setSessionData(ManageUserSurrogatesSession sessionData) {
		this.sessionData = sessionData;
	}

	/**
	 * Handles the showSelectVisnView action.
	 * @return The action result: Error or Success
	 */
	public String showSelectVisnView() {
		assert sessionData != null : "No session data";
		sessionData.setVisns(getAdministeredVisns());
		String result = autoSelectVisn();
		if (result != null) {
			return result;
		}
		// Could not preselect a VISN
		clearSelectedVisn();
		return SUCCESS;
	}

	/**
	 * Handles the selectVisn action.
	 * @return The action result: Cancel, Error or Success
	 */
	public String selectVisn(){
		assert sessionData != null : "No session data";
		if (doCancel()) {
			return cancel();
		}
		if (!doSelect()) {
			if (sessionData.getSelectedVisnId() != null) {
				// Changing the selected facility
				return SUCCESS;
			}
			return handleUnexpectedError();
		}
		if (!hasSelected(getVisnId())) {
			return handleError(NO_VISN_SELECTED);
		}

		sessionData.setSelectedVisnId(getVisnId());
		loadFacilities();
		String result = autoSelectFacility();
		if (result != null) {
			return result;
		}
		// Could not preselect a facility
		clearSelectedFacility();

		return SUCCESS;
	}


	/**
	 * Handles the selectFacility action.
	 * @return The action result: Cancel, Error or Success
	 */
	public String selectFacility(){
		assert sessionData != null : "No session data";
		if (doCancel()) {
			return cancel();
		}
		if (!doSelect()) {
			if (sessionData.getSelectedFacilityId() != null) {
				// Assume selecting another user
				return SUCCESS;
			}
			return handleUnexpectedError();
		}
		if (!hasSelected(getFacilityId())) {
			return handleError(NO_FACILITY_SELECTED);
		}
		sessionData.setSelectedFacilityId(getFacilityId());
		return loadClinicians();
	}

	/**
	 * Handles the selectClinician action.
	 * @return The action result: Cancel, Error or Success
	 */
	public String selectClinician() {
		assert sessionData != null : "No session data";
		if (doCancel()) {
			return cancel();
		}
		if (!doSelect()) {
			return handleUnexpectedError();
		}

		if (!hasSelected(getClinicianId())) {
			return handleError(NO_CLINICIAN_SELECTED);
		}
		sessionData.setSelectedClinicianId(getClinicianId());
		CollectionServiceResponse<TriageGroup> response = triageGroupService.
			getTriageGroupsForStation(sessionData.getSelectedStationNumber());
		if (handleMessages(response)) {
			return ERROR;
		}
		// The assumption is made that the triage groups in the
		// response are ordered by name
		sessionData.setTriageGroups(response.getCollection());
		Clinician c = sessionData.getSelectedClinician();

		loadStaffAndTriageList(c);

		loadSurrogates();

		return SUCCESS;
	}

	public Log getLOG() {
		return LOG;
	}

	protected String cancel() {
		sessionData.clear();
		return CANCEL;
	}

	/**
	 * Indicates the Cancel button was pushed.
	 * @return True if the Cancel button was pushed; false otherwise.
	 */
	private boolean doCancel() {
		return !StringUtils.isBlank(getDoCancel());
	}

	/**
	 * Indicates the Select button was pushed.
	 * @return True if the Select button was pushed; false otherwise.
	 */
	private boolean doSelect() {
		return !StringUtils.isBlank(getDoSelect());
	}

	/**
	 * Indicates the Apply button was pushed.
	 * @return True if the Apply button was pushed; false otherwise.
	 */
	private boolean doApply() {
		return !StringUtils.isBlank(getDoApply());
	}

	private String autoSelectVisn() {
		if (sessionData.getCanChangeVisn()) {
			return null;
		}
		if (!forceSelectVisn()) {
			log().error("Unable to force facility. Administrator '" +
					admin.getId() + "' may not have access to any VISNs " +
				"or facilities");
			return handleUnexpectedError();
		}
		loadFacilities();
		String result = autoSelectFacility();
		return (result != null) ? result : SELECTED_VISN;
	}

	private boolean forceSelectVisn() {
		if (sessionData.getVisns() == null) {
			return false;
		}
		Iterator<Facility> i = sessionData.getVisns().iterator();
		if ((i == null) || !i.hasNext()) {
			return false;
		}
		visnId = i.next().getId();
		sessionData.setSelectedVisnId(visnId);
		return visnId != null;
	}

	private String autoSelectFacility() {
		if (sessionData.getCanChangeFacility()) {
			return null;
		}
		if (!forceSelectFacility()) {
			log().error("Unable to force facility. Administrator '" +
					admin.getId() + "' may not have access to any VISNs " +
				"or facilities");
			return handleUnexpectedError();
		}
		return (ERROR.equals(loadClinicians())) ? ERROR : SELECTED_FACILITY;
	}

	private boolean forceSelectFacility() {
		if (sessionData.getFacilities() == null) {
			return false;
		}
		Iterator<Facility> i = sessionData.getFacilities().iterator();
		if ((i == null) || !i.hasNext()) {
			return false;
		}
		facilityId = i.next().getId();
		sessionData.setSelectedFacilityId(facilityId);
		return facilityId != null;
	}

	private String loadFacilities() {
		Facility visn = sessionData.getSelectedVisn();
		Collection<Facility> facilities = getAdministeredFacilitiesInVisn(visn);
		sessionData.setFacilities(facilities);
		return SUCCESS;
	}

	private String loadClinicians() {
		return loadClinicians(null);
	}
	private String loadClinicians(Clinician selectedClinician) {

		Clinician c = sessionData.getSelectedClinician();
		getRequest().setAttribute(CLINICIAN_USER,c);

		CollectionServiceResponse<Clinician> response = userManagementService.
			getCliniciansForStation(sessionData.getSelectedStationNumber());
		if (handleMessages(response)) {
			return ERROR;
		}
//		SurrogateType surrogateType = sessionData.getSurrogateType();
		// The assumption is made that the clinicians in the
		// response are ordered by name (that is: last name, first name)

		sessionData.setClinicians(response.getCollection());
		ArrayList cliniciansWithProviderList = new ArrayList();
			for(Clinician clinician:sessionData.getClinicians()){
			ClinicianVO clinicianVO = new ClinicianVO();
			clinicianVO.setClinicianId(clinician.getId());
			//The user clinical type id should always be there, but due to incorrect data (bug: 5464)
			//some clinicians have missing clinical user type id.
			//to avoid the 500 internal error check for null pointer before getting the type.
			String userType = "";
			if(clinician.getClinicalUserType() != null){
				userType = clinician.getClinicalUserType().getName();
			}

			clinicianVO.setClincianFullName(clinician.getLastName()+", "+clinician.getFirstName()+" ("+userType+")");
			cliniciansWithProviderList.add(clinicianVO);
		}
	    setSessionAttribute("cliniciansWithProviderList",cliniciansWithProviderList);
		clearSelectedClinician();
		if (selectedClinician != null) {
			sessionData.setSelectedClinicianId(selectedClinician.getId());
		}
		return SUCCESS;
	}

	private boolean hasSelected(Long id) {
		return (id != null) && (id != 0L) && (id != -1L);
	}

	private void clearSelectedVisn() {
		sessionData.setSelectedVisnId(null);
		clearSelectedFacility();
	}
	private void clearSelectedFacility() {
		sessionData.setSelectedFacilityId(null);
		clearSelectedClinician();
	}
	private void clearSelectedClinician() {
		sessionData.setSelectedClinicianId(null);
	}

	private List<Surrogate> defaultSurrogates(int size) {
		List<Surrogate> list = new ArrayList<Surrogate>();
		for(int i = 0; i < size; i++) {
			Surrogate s = new Surrogate();
			s.setActive(false);
			Date today = new Date();
			s.setSurrogateStartDate(today);
			s.setSurrogateEndDate(today);
			s.setSurrogateAllDay(true);
			list.add(s);
		}
		return list;
	}

	private void loadSurrogates() {
		Clinician c = (Clinician)sessionData.getSelectedClinician();
//		Retrieve the current surrogates
		CollectionServiceResponse<Surrogate> surrResp = userManagementService.getSurrogatesFor(c);
		List<Surrogate> surrogates = (List)surrResp.getCollection();

		if( surrogates.size() < 5 ) {
			//Setup EMPTY Surrogate objects  (Don't associate them with the user yet)
			List<Surrogate> emptySurrogates = defaultSurrogates(5-surrogates.size());
			//Merge the two sets
			surrogates.addAll(emptySurrogates);
		}

		List<AssignSurrogates> assignSurrogates = new ArrayList<AssignSurrogates>();
		for( Surrogate s1: surrogates ) {
			AssignSurrogates s = AssignSurrogates.createAssignSurrogate(s1);

			//Convert the Id into a named element for the select
			if(s.getSurrogateType() != null && s.getSurrogateType().equals(ParticipantTypeEnum.CLINICIAN)) {
				ServiceResponse<Clinician> clinResp = userManagementService.fetchClinician(s.getSurrogateId());
				Clinician clin = clinResp.getPayload();
				s.setStaffOrTriageValue(StaffOrTriageVO.getClinicianValueForId(clin.getId()));
			}
			else if(s.getSurrogateType() != null && s.getSurrogateType().equals(ParticipantTypeEnum.TRIAGE_GROUP)) {
				ServiceResponse<TriageGroup> triageResp = triageGroupService.findTriageGroupById(s.getSurrogateId());
				TriageGroup tg = triageResp.getPayload();
				s.setStaffOrTriageValue(StaffOrTriageVO.getTriageGroupValueForId(tg.getId()));
			} else {
				//Use a default value
				s.setStaffOrTriageValue(SURROGATE_DEFAULT_VALUE);
			}
			assignSurrogates.add(s);
		}
		getRequest().setAttribute(SURROGATES, assignSurrogates);
		getRequest().setAttribute(CLINICIAN_USER, c);
	}

	public String assignSurrogates() {
		//make sure they didn't select a default value for a surrogate use SURROGATE_DEFAULT_VALUE
		Clinician c = (Clinician)sessionData.getSelectedClinician();
		getRequest().setAttribute(CLINICIAN_USER, c);

		loadStaffAndTriageList(c);

		//Verify that form array is not null
		List<AssignSurrogates> list = new ArrayList<AssignSurrogates>();
		for(int i = 0; i < assignSurrogates.length; i++) {
			AssignSurrogates s = assignSurrogates[i];
			//Convert the Id into a named element for the select
			if(s.getSurrogateType() != null && s.getSurrogateType().equals(ParticipantTypeEnum.CLINICIAN)) {
				ServiceResponse<Clinician> clinResp = userManagementService.fetchClinician(s.getSurrogateId());
				Clinician clin = clinResp.getPayload();
				s.setStaffOrTriageValue(StaffOrTriageVO.getClinicianValueForId(clin.getId()));
			}
			else if(s.getSurrogateType() != null && s.getSurrogateType().equals(ParticipantTypeEnum.TRIAGE_GROUP)) {
				ServiceResponse<TriageGroup> triageResp = triageGroupService.findTriageGroupById(s.getSurrogateId());
				TriageGroup tg = triageResp.getPayload();
				s.setStaffOrTriageValue(StaffOrTriageVO.getTriageGroupValueForId(tg.getId()));
			} else {
				//Use a default value
				s.setStaffOrTriageValue(SURROGATE_DEFAULT_VALUE);
			}
			list.add(s);
		}
		getRequest().setAttribute(SURROGATES, list);

		int count = 0;
		for(AssignSurrogates cs:list) {
			if( cs.getId() != null && !cs.getId().equals(SURROGATE_DEFAULT_VALUE) ) {
				String errorParam = "assignSurrogatesForm";
				String errorRow = " for row " + (count+1);

//				Validate required fields
				if(!cs.getId().contains("|")) {
					this.addFieldError(errorParam, "Please select a valid staff or triage name" + errorRow);
					return "success";
				}

				if(cs.getStartDate() == null || cs.getStartDate().length() == 0) {
					this.addFieldError(errorParam, "Please select a valid start date" + errorRow);
					return "success";
				}

				if(cs.getEndDate() == null || cs.getEndDate().length() == 0) {
					this.addFieldError(errorParam, "Please select a valid end date" + errorRow);
					return "success";
				}

				try {
					if( cs.getStartDate() != null && cs.getStartDate().length()!=0) {
						Date tempSurrogateStartDate = new Date();
						tempSurrogateStartDate =(DateUtils.parseDateNoLeniency(cs.getStartDate(), DateUtils.ENGLISH_DATE_FORMAT));
					}
				} catch (ParseException e) {
					this.addFieldError(errorParam, "Please enter a valid start date"+errorRow);
					return "success";
				}

				try {
					if( cs.getEndDate() != null && cs.getEndDate().length()!=0) {
						Date tempSurrogateStartDate = new Date();
						tempSurrogateStartDate =(DateUtils.parseDateNoLeniency(cs.getEndDate(), DateUtils.ENGLISH_DATE_FORMAT));
					}
				} catch (ParseException e) {
					this.addFieldError(errorParam, "Please enter a valid end date"+ errorRow);
					return "success";
				}


//				Validate date ranges
				try {
					cs.getStartDateTime();
				} catch (ParseException e) {
					this.addFieldError(errorParam, "Please enter a valid start date and time" + errorRow);
					return "success";
				}

				try {
					cs.getEndDateTime();
				} catch (ParseException e) {
					this.addFieldError(errorParam, "Please enter a valid end date and time" + errorRow);
					return "success";
				}

				try {
					if( cs.getStartDateTime().after(cs.getEndDateTime()) ) {
						this.addFieldError(errorParam, "Please verify that the From date is before To date" + errorRow);
						return "success";
					}
				} catch (ParseException e) {
					//Caught and handled prior to this call
				}

				try{
					if(cs.getStartDate().equals(cs.getEndDate())){
						if(cs.getStartDateTime().equals(cs.getEndDateTime())){
							this.addFieldError(errorParam, "The From Date and Time cannot be the same as the To Date and Time" + errorRow);
							return "success";
						}

				}
				}catch(Exception e){}

			}
			count++;
		}

//		Check for overlapping dates

		//sort collection by start date  and only check for overlaps on rows that have data.
		List<AssignSurrogates> list2 = new ArrayList<AssignSurrogates>();
		for(AssignSurrogates a: list) {
			if( a.getSurrogateType() != null ) {
				list2.add(a);
			}
		}
		Collections.sort(list2, AssignSurrogates.ASSIGN_SURROGATES_SORTER);
		AssignSurrogates curr = null;
		for(AssignSurrogates a: list2) {
			try {
				//!curr.getEndDateTime().equals(a.getStartDateTime())
				if( curr != null && curr.getEndDateTime().after(a.getStartDateTime())) {
					this.addFieldError("assignSurrogatesForm", "Please verify that there are no overlapping start dates and end dates");
					return "success";
				} else {
					curr = a;
				}
			} catch (ParseException e) {
				//Ignore already caught and handled prior to this validation
			}
		}

		//Now that all validation passed go ahead and save the data.

		List<Surrogate>saveSurrogates = new ArrayList<Surrogate>();
		for(AssignSurrogates a: list2) {
			if( a.getSurrogateType() != null ) {
				Surrogate s = new Surrogate();
				s.setSurrogateId(a.getSurrogateId());
				s.setSurrogateAllDay(a.getAllDayBool());
				try {
					s.setSurrogateEndDate(a.getEndDateTime());
					s.setSurrogateStartDate(a.getStartDateTime());
				} catch (ParseException e) {
					//Ignore validation already done
				}
				s.setSurrogateType(a.getSurrogateType());
				saveSurrogates.add(s);
			}
		}
		ServiceResponse<Boolean> clearResp = userManagementService.clearSurrogatesFor(c);
		handleMessages(clearResp);
		if( !clearResp.getPayload() ) {
			addFieldError("assignSurrogatesForm", "Error clearing existing surrogates");
			return "success";
		}

		ServiceResponse<Boolean> clinResp = userManagementService.setSurrogatesFor(c,saveSurrogates);
		handleMessages(clinResp);
		if( !clinResp.getPayload() ) {
			addFieldError("assignSurrogatesForm", "Error saving surrogates");
			return "success";
		}

		addFieldError("assignSurrogatesForm", SURROGATE_SETUP_MESSAGE);

		loadSurrogates();

		return "success";
	}

	private void loadStaffAndTriageList(Clinician c) {
		CollectionServiceResponse<Clinician> response1 = userManagementService.getCliniciansForStation(c.getStationNo());
		Collection<Clinician> clinicians = response1.getCollection();
		CollectionServiceResponse<TriageGroup> response2 = triageGroupService.getTriageGroupsForStation(c.getStationNo());
		Collection<TriageGroup> tGroups = response2.getCollection();

		Clinician remove = null;
		for(Clinician c1: clinicians) {
			if( c1.getId().equals(c.getId()) ) {
				remove = c1;
				break;
			}
		}
		if( remove != null )
			clinicians.remove(remove);

		List<StaffOrTriageVO> allPickList = StaffOrTriageVO.createFolderVOList( clinicians, tGroups );
		getRequest().setAttribute(STAFFANDTRIAGE, allPickList);
	}

	public AssignSurrogates[] getAssignSurrogates() {
		return assignSurrogates;
	}

}
