package gov.va.med.mhv.sm.web.actions;

import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.foundation.service.response.messages.Message;
import gov.va.med.mhv.foundation.service.response.messages.MessageUtils;
import gov.va.med.mhv.sm.ad.ADQueryResult;
import gov.va.med.mhv.sm.dao.UserDao;
import gov.va.med.mhv.sm.enumeration.PerformerTypeEnum;
import gov.va.med.mhv.sm.model.Administrator;
import gov.va.med.mhv.sm.model.ClinicalUserType;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.Facility;
import gov.va.med.mhv.sm.model.TriageGroup;
import gov.va.med.mhv.sm.model.User;
import gov.va.med.mhv.sm.service.LoggingService;
import gov.va.med.mhv.sm.service.TriageGroupService;
import gov.va.med.mhv.sm.service.UserManagementService;
import gov.va.med.mhv.sm.web.session.ManageUserSurrogatesSession;
import gov.va.med.mhv.sm.web.util.ClinicianVO;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.EmailValidator;
import org.apache.struts2.ServletActionContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import com.opensymphony.xwork2.Preparable;

public class ManageUserInfo extends BaseSMAdminAction 
	implements Preparable 
{
	private static final long serialVersionUID = 1l;
	
	private static final Log LOG = LogFactory.getLog(ManageUserInfo.class);

	private static final String SESSION_ATTRIBUTE = ManageUserInfo.class.toString() + ".session";
	private final String USERINFO_SETUP_MESSAGE="The user data has been successfully changed";
	
	private static final String CANCEL = "cancel";
	private static final String SELECTED_VISN = "selectedVISN";
	private static final String SELECTED_FACILITY = "selectedFacility";

	private static final Message NO_CLINICIAN_SELECTED = MessageUtils.
		createErrorMessage("manage.info.no.clinician.selected", null, null);
	private static final Message NO_FACILITY_SELECTED = MessageUtils.
		createErrorMessage("manage.info.no.facility.selected", null, null);
	private static final Message NO_VISN_SELECTED = MessageUtils.
		createErrorMessage("manage.info.no.visn.selected", null, null);

	private UserManagementService userManagementService = null;
	private TriageGroupService triageGroupService = null;
	private LoggingService loggingService;
	
	private Administrator admin = null;
	private ManageUserSurrogatesSession sessionData = null;
	private Long visnId = null;
	private Long facilityId = null;
	private Long clinicianId = null;
	private String doSelect = null;
	private String doCancel = null;
	private String doApply = null;
	
	private String networkId = null;
	private String userType = null;
	private String duz = null;
	private String email = null;
	private String firstName=null;
	private String lastName=null;
	
	public void prepare() throws Exception {
		super.prepare();
		
		userManagementService = getUserManagementService();
		triageGroupService = getTriageGroupService();
		
		if (getSessionAttribute(SESSION_ATTRIBUTE) == null) {
			sessionData = new ManageUserSurrogatesSession();
			setSessionAttribute(SESSION_ATTRIBUTE, sessionData);
		} else {
			sessionData = (ManageUserSurrogatesSession) getSessionAttribute(SESSION_ATTRIBUTE);
		}
		
		admin = getCurrentUser();
		assert admin != null : "No administrator logged in";
	}

	public Long getVisnId() {
		return visnId;
	}

	public void setVisnId(Long visnId) {
		this.visnId = visnId;
	}

	public Long getFacilityId() {
		return facilityId;
	}

	public void setFacilityId(Long facilityId) {
		this.facilityId = facilityId;
	}

	public Long getClinicianId() {
		return clinicianId;
	}

	public void setClinicianId(Long clinicianId) {
		this.clinicianId = clinicianId;
	}

	public String getDoCancel() {
		return doCancel;
	}
	public void setDoCancel(String doCancel) {
		this.doCancel = doCancel;
	}

	public String getDoSelect() {
		return doSelect;
	}
	public void setDoSelect(String doSelect) {
		this.doSelect = doSelect;
	}

	public String getDoApply() {
		return doApply;
	}
	public void setDoApply(
		String doSelectClinicianSurrogate) 
	{
		this.doApply = doSelectClinicianSurrogate;
	}

	public ManageUserSurrogatesSession getSessionData() {
		return sessionData;
	}
	public void setSessionData(ManageUserSurrogatesSession sessionData) {
		this.sessionData = sessionData;
	}

	/**
	 * Handles the showSelectVisnView action.
	 * @return The action result: Error or Success
	 */
	public String showSelectVisnView() {
		assert sessionData != null : "No session data";
		sessionData.setVisns(getAdministeredVisns());
		String result = autoSelectVisn();
		if (result != null) {
			return result;
		}
		// Could not preselect a VISN
		clearSelectedVisn();
		return SUCCESS;
	}
	
	/**
	 * Handles the selectVisn action.
	 * @return The action result: Cancel, Error or Success 
	 */
	public String selectVisn(){
		assert sessionData != null : "No session data";
		if (doCancel()) {
			return cancel();
		}
		if (!doSelect()) {
			if (sessionData.getSelectedVisnId() != null) {
				// Changing the selected facility
				return SUCCESS;
			}
			return handleUnexpectedError();
		}
		if (!hasSelected(getVisnId())) {
			return handleError(NO_VISN_SELECTED);
		}

		sessionData.setSelectedVisnId(getVisnId());
		loadFacilities();
		String result = autoSelectFacility();
		if (result != null) {
			return result;
		}
		// Could not preselect a facility
		clearSelectedFacility();
		
		return SUCCESS;
	}

	
	/**
	 * Handles the selectFacility action.
	 * @return The action result: Cancel, Error or Success 
	 */
	public String selectFacility(){
		assert sessionData != null : "No session data";
		if (doCancel()) {
			return cancel();
		}
		if (!doSelect()) {
			if (sessionData.getSelectedFacilityId() != null) {
				// Assume selecting another user
				return SUCCESS;
			}
			return handleUnexpectedError();
		}
		if (!hasSelected(getFacilityId())) {
			return handleError(NO_FACILITY_SELECTED);
		}
		sessionData.setSelectedFacilityId(getFacilityId());
		return loadClinicians();
	}
	
	/**
	 * Handles the selectClinician action.
	 * @return The action result: Cancel, Error or Success 
	 */
	public String selectClinician() {
		assert sessionData != null : "No session data";
		if (doCancel()) {
			return cancel();
		}
		if (!doSelect()) {
			return handleUnexpectedError();
		}

		if (!hasSelected(getClinicianId())) {
			return handleError(NO_CLINICIAN_SELECTED);
		}
		sessionData.setSelectedClinicianId(getClinicianId());
		CollectionServiceResponse<TriageGroup> response = triageGroupService.
			getTriageGroupsForStation(sessionData.getSelectedStationNumber());
		if (handleMessages(response)) {
			return ERROR;
		}
		
		return SUCCESS;
	}
	
	public Log getLOG() { 
		return LOG;
	}
	public boolean isValidEmailAddress(String emailAddress){
		return EmailValidator.getInstance().isValid(emailAddress);
	}
	
	public String saveUserInfo() {
		Clinician currentClinician = sessionData.getSelectedClinician();
		String oldUserType;
		String oldNetworkId;
		
		// Required fields validation starts here..
		if(getFirstName()==null || getFirstName().length()==0){
			addActionError("First Name is required.");
			return ERROR;
		}
		
		if(getLastName()==null || getLastName().length()==0){
			addActionError("Last Name is required.");
			return ERROR;
		}
		
		if(getNetworkId()==null || getNetworkId().length()==0){
			addActionError("Network ID is required.");
			return ERROR;
		}
		
		if(getDuz()==null || getDuz().length()==0){
			addActionError("DUZ is required.");
			return ERROR;
		}
		
		if(getEmail()==null || getEmail().length()==0){
			addActionError("Email is required.");
			return ERROR;
		}else{
			if(!isValidEmailAddress(getEmail())){
				addActionError("Invalid email address.");
				return ERROR;
			}
		}
		
		//Check that the network Id is valid
		ServiceResponse<ADQueryResult> response = getAdminService().findADAccount(networkId);
		ADQueryResult staffADResults = response.getPayload();
		
		if(staffADResults == null)
		{
			addActionError("The network ID was not found in Outlook.");
			return ERROR;
		}else
		{
			//Validate fields
			/*String firstNameAD = (staffADResults.getFirstName() == null)?"":staffADResults.getFirstName();
			  String lastNameAD = (staffADResults.getLastName() == null)?"":staffADResults.getLastName();
			  String emailAD = (staffADResults.getEmail() == null)?"":staffADResults.getEmail();
			*/
			
			//CHECK IF NAME MATCHES??
			/*if( !(currentClinician.getLastName().equalsIgnoreCase(lastNameAD) && currentClinician.getFirstName().equalsIgnoreCase(firstNameAD)) ) {
				addActionError("The data in Outlook didn't match the clinician selected.");
				return ERROR;
			}*/
			oldNetworkId = currentClinician.getUsername();
			oldUserType = currentClinician.getUserType().name();
			
			//SAVE ACTUAL CHANGES
			//Only process the network id change the name if it is different
			if( !networkId.equalsIgnoreCase(currentClinician.getUsername())) {
//				CHECK IF NETWORKID IS ALREADY USED 
				WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext(ServletActionContext.getServletContext());
				UserDao userDao = (UserDao) ctx.getBean("userDao");
				Clinician existingClinician = userDao.findClinicianByStationAndUsername(currentClinician.getStationNo(), networkId);
				if (existingClinician != null) {
					addActionError("Account for network ID " +networkId +
								   " is in use by " +
								   (existingClinician.isActive() ? "active" : "inactive") +
								   " staff member " +
								   existingClinician.getName());
					return ERROR;
				}
				currentClinician.setUsername(networkId.toLowerCase());
				
			}
			if( !duz.equalsIgnoreCase(currentClinician.getDuz())) {
//				CHECK IF NETWORKID IS ALREADY USED 
				WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext(ServletActionContext.getServletContext());
				UserDao userDao = (UserDao) ctx.getBean("userDao");
				List clinicianList  = userDao.findClinicianByStationAndDuz(currentClinician.getStationNo(), duz);
				if(clinicianList!=null)
				{
					if(clinicianList.size()>1)
					{
						addActionError("There are more than one Clinician account exists for Station: "+currentClinician.getStationNo()+" Duz: "+duz);
						return ERROR;
					}
					Clinician clin = (Clinician)clinicianList.get(0);
					if(clin !=null)
					{
						addActionError("Account for Station " +currentClinician.getStationNo() + " Duz "+duz+
								   " is already in use by " +
								   (clin.isActive() ? "active" : "inactive") +
								   " staff member " +
								   clin.getName());
						
						return ERROR;
					}
				}	
				else
				{
					currentClinician.setDuz(duz);
				}
			}
			CollectionServiceResponse adminResponse = getAdminService().getClinicalUserTypes();
			Collection<ClinicalUserType> types = adminResponse.getCollection();
			for( ClinicalUserType cut:types) {
				if(cut.getName().equalsIgnoreCase(userType)) {
					currentClinician.setClinicalUserType(cut);
					currentClinician.setEmail(email);
					break;
				}
			}
			currentClinician.setFirstName(firstName);
			currentClinician.setLastName(lastName);
			ServiceResponse<Clinician> userUpdateResponse = userManagementService.updateClinician((User)getCurrentUser(), sessionData.getSelectedClinician());
			currentClinician = (Clinician)userUpdateResponse.getPayload();
			
			if( currentClinician == null ) {
				addActionError("Error updating the selected clinician. Please try again.");
				return ERROR;
			} else {
				//Success
				loggingService.userInfoChanged(admin,PerformerTypeEnum.ADMINISTRATOR,"Changed "+oldUserType+"->"+userType+";"+oldNetworkId+"->"+networkId, true);
			}
		}
		
		// Need to reload clinicians into the session, as the selected 
		// clinician will otherwise still refer to the old surrogate
		addActionError(USERINFO_SETUP_MESSAGE);
		return loadClinicians(currentClinician);
	}

	protected String cancel() {
		sessionData.clear();
		return CANCEL;
	}

	/**
	 * Indicates the Cancel button was pushed.
	 * @return True if the Cancel button was pushed; false otherwise.
	 */
	private boolean doCancel() {
		return !StringUtils.isBlank(getDoCancel());
	}

	/**
	 * Indicates the Select button was pushed.
	 * @return True if the Select button was pushed; false otherwise.
	 */
	private boolean doSelect() {
		return !StringUtils.isBlank(getDoSelect());
	}

	private String autoSelectVisn() {
		if (sessionData.getCanChangeVisn()) {
			return null;
		}
		if (!forceSelectVisn()) {
			log().error("Unable to force facility. Administrator '" +
					admin.getId() + "' may not have access to any VISNs " +
				"or facilities");
			return handleUnexpectedError();
		}
		loadFacilities();
		String result = autoSelectFacility();
		return (result != null) ? result : SELECTED_VISN;
	}

	private boolean forceSelectVisn() {
		if (sessionData.getVisns() == null) {
			return false;
		}
		Iterator<Facility> i = sessionData.getVisns().iterator();
		if ((i == null) || !i.hasNext()) {
			return false;
		}
		visnId = i.next().getId();
		sessionData.setSelectedVisnId(visnId);
		return visnId != null; 
	}
	
	private String autoSelectFacility() {
		if (sessionData.getCanChangeFacility()) {
			return null;
		}
		if (!forceSelectFacility()) {
			log().error("Unable to force facility. Administrator '" +
					admin.getId() + "' may not have access to any VISNs " +
				"or facilities");
			return handleUnexpectedError();
		}
		return (ERROR.equals(loadClinicians())) ? ERROR : SELECTED_FACILITY;
	}

	private boolean forceSelectFacility() {
		if (sessionData.getFacilities() == null) {
			return false;
		}
		Iterator<Facility> i = sessionData.getFacilities().iterator();
		if ((i == null) || !i.hasNext()) {
			return false;
		}
		facilityId = i.next().getId();
		sessionData.setSelectedFacilityId(facilityId);
		return facilityId != null; 
	}

	private String loadFacilities() {
		Facility visn = sessionData.getSelectedVisn();
		Collection<Facility> facilities = getAdministeredFacilitiesInVisn(visn);
		sessionData.setFacilities(facilities);
		return SUCCESS;
	}
	
	private String loadClinicians() {
		return loadClinicians(null);
	}
	
	private String loadClinicians(Clinician selectedClinician) {
		CollectionServiceResponse<Clinician> response = userManagementService.
			getCliniciansForStation(sessionData.getSelectedStationNumber());
		if (handleMessages(response)) {
			return ERROR;
		}
		// The assumption is made that the clinicians in the 
		// response are ordered by name (that is: last name, first name)
		
		
		sessionData.setClinicians(response.getCollection());
		ArrayList cliniciansWithProviderList = new ArrayList();
			for(Clinician clinician:sessionData.getClinicians()){
			ClinicianVO clinicianVO = new ClinicianVO();
			clinicianVO.setClinicianId(clinician.getId());
			//The user clinical type id should always be there, but due to incorrect data (bug: 5464)
			//some clinicians have missing clinical user type id.
			//to avoid the 500 internal error check for null pointer before getting the type.
			String userType = "";
			if(clinician.getClinicalUserType() != null){ 
				userType = clinician.getClinicalUserType().getName();
			}
			
			clinicianVO.setClincianFullName(clinician.getLastName()+", "+clinician.getFirstName()+" ("+userType+")");
			cliniciansWithProviderList.add(clinicianVO);
		}
	    setSessionAttribute("cliniciansWithProviderList",cliniciansWithProviderList);
		clearSelectedClinician();
		if (selectedClinician != null) {
			sessionData.setSelectedClinicianId(selectedClinician.getId());
		}
		
		return SUCCESS;
	}
	
	private boolean hasSelected(Long id) {
		return (id != null) && (id != 0L) && (id != -1L);
	}
	private void clearSelectedVisn() {
		sessionData.setSelectedVisnId(null);
		clearSelectedFacility();
	}
	private void clearSelectedFacility() {
		sessionData.setSelectedFacilityId(null);
		clearSelectedClinician();
	}
	private void clearSelectedClinician() {
		sessionData.setSelectedClinicianId(null);
	}
	
	@SuppressWarnings("unchecked")
	public Collection<ClinicalUserType> getClinicalUserTypes() {
		CollectionServiceResponse response = getAdminService().getClinicalUserTypes();
		return response.getCollection();
	}
	
	public String getUserType() {
		return this.userType!=null?this.userType:sessionData.getSelectedClinician().getClinicalUserType().getName();
	}
	
	public String getNetworkId() {
		return this.networkId!=null?this.networkId.trim():sessionData.getSelectedClinician().getUsername().trim();
	}
	
	public String getDuz() {
		return this.duz!=null?this.duz.trim():sessionData.getSelectedClinician().getDuz().trim();
	}
	
	public String getEmail() {
		return this.email!=null?this.email.trim():sessionData.getSelectedClinician().getEmail().trim();
	}
	
	public void setDuz(String duz) {
		this.duz = duz;
	}
	
	public void setEmail(String email) {
		this.email = email;
	}
	
	public void setUserType(String userType) {
		this.userType = userType;
	}
	
	public void setNetworkId(String networkId) {
		this.networkId = networkId;
	}
	
	public LoggingService getLoggingService() {
		return loggingService;
	}
	
	public void setLoggingService(LoggingService loggingService) {
		this.loggingService = loggingService;
	}

	public String getFirstName() {
		return this.firstName!=null?this.firstName.trim():sessionData.getSelectedClinician().getFirstName().trim();
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return this.lastName!=null?this.lastName.trim():sessionData.getSelectedClinician().getLastName().trim();
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}
}
