package gov.va.med.mhv.sm.web.actions;

import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.ad.ADQueryResult;
import gov.va.med.mhv.sm.dao.UserDao;
import gov.va.med.mhv.sm.model.Administrator;
import gov.va.med.mhv.sm.model.ClinicalUserType;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.Facility;
import gov.va.med.mhv.sm.service.UserManagementService;
import gov.va.med.mhv.sm.wsclient.adminqueriessvc.User;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.EmailValidator;
import org.apache.struts2.ServletActionContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import com.opensymphony.xwork2.Preparable;

public class ManageStaff extends BaseSMAdminAction implements Preparable {

	@SuppressWarnings("unused")
	private static final Log log = LogFactory.getLog(ManageStaff.class);

	private static final String CANCEL = "cancel";
	private static final String FAILED = "failed";
	private static final String SELECT_STAFF = "selectStaff";
	private static final String QUERY_RESULTS_IR = "queryResults_IR";
	private static final String BULK_ACTIVATION = "bulkActivation";
	private UserManagementService userManagementService;
	private UserDao userDao;
	private Collection<Facility> visns;
	private Collection<Facility> facilities;
	private Long visnId;
	private Long facilityId;
	private String selectedVisnName;
	private String selectedFacilityName;
	private List<Clinician> clinicians;
	private List<Clinician> selectedUsers;
	private List<ClinicalUserType> staffMemberTypes;
	//private HttpServletRequest request;
	private String searchCrit;
	private String emailAD;
	private String firstName;
	private String lastName;
	private String duz;
	private String phone;
	private String title;
	private String email;
	private String networkId;
	private Long memberTypeId;
	private String memberType;
	private String firstNameAD;
	private String lastNameAD;
	private String phoneAD;
	private String titleAD;
	private String networkIdAD;
	private String selectAction;
	// File upload info for bulk activation
	private File upload;
    private String uploadContentType;
    private String uploadFileName;
    private int added; // number of bulk load staff members activated.
    private static String FILE_SIZE_LIMIT_ERROR = "The file you are trying to upload exceeds the 2MB limit. " +
    										 "Please reduce the file size and try again.";
    private static int FILE_SIZE_LIMIT_2MB = 2 * 1024 * 1024;
	public ManageStaff() {
		super();
	}


	public void prepare() throws Exception {
		super.prepare();
		WebApplicationContext ctx = WebApplicationContextUtils
				.getWebApplicationContext(ServletActionContext
						.getServletContext());
		userManagementService = (UserManagementService) ctx.getBean("userManagementService");


		userDao = (UserDao) ctx.getBean("userDao");
	}


	public String manageStaffMembers() {

		clearSessionAttr();

		return SUCCESS;
	}

	public String selectEntryMethod() {

		if(appliedCancel()){ return CANCEL;	}
		clearSessionAttr();
		facilities = new TreeSet<Facility>();

		if((selectAction != null) && (selectAction.equalsIgnoreCase("Inactivate a Staff Member"))){
			setSessionAttribute("activationType","inactivate");
			return SELECT_STAFF;
		}
		if((selectAction != null) && (selectAction.equalsIgnoreCase("Reactivate a Staff Member"))){
			setSessionAttribute("activationType","reactivate");
			return SELECT_STAFF;
		}
		return SUCCESS;
	}


	public String selectSearchCrit() {

		if(appliedCancel()){ return CANCEL;	}
		clearSessionAttr();
		facilities = new TreeSet<Facility>();
		if((selectAction != null) && ((selectAction.trim()).equalsIgnoreCase("Bulk Activation from CSV File"))){
			return BULK_ACTIVATION;
		}

		return SUCCESS;
	}


	public String selectVisn(){

		getStaffSessionAttr();

		if(visnId == -1L){
			addActionError("Please select a VISN.");
			return SELECT_STAFF;
		}

		for(Facility v: getAdministeredVisns()){
			if(v.getId().equals(visnId)){
				selectedVisnName = v.getName();
				facilities = getAdministeredFacilitiesInVisn(v);
			}
		}

		if(StringUtils.isBlank(selectedVisnName)){
			addActionError("Please select a VISN.");
			return SELECT_STAFF;
		}

		setSessionAttribute("facilities",facilities);
		setSessionAttribute("selectedVisnName",selectedVisnName);

		return SELECT_STAFF;

	}

	public String selectFacility(){

		getStaffSessionAttr();

		// if the visn hasn't been selected first
		if(StringUtils.isBlank(selectedVisnName)){
			addActionError("Please select a VISN.");
			return SELECT_STAFF;
		}

		// make sure a facility has been chosen
		if(facilityId == -1){
			addActionError("Please select a Facility.");
			return SELECT_STAFF;
		}

		String stationNumber = null;

		if(facilities != null){
			for(Facility f: facilities){
				if(f.getId().equals(facilityId)){
					selectedFacilityName = f.getName();
					stationNumber = f.getStationNumber();
				}
			}
		}

		setSessionAttribute("selectedFacilityName",selectedFacilityName);
		setSessionAttribute("stationNumber",stationNumber);

		return SELECT_STAFF;
	}

	public String searchStaffMembers() {
		if(appliedCancel()){ return CANCEL;	}

		getStaffSessionAttr();
		if(StringUtils.isBlank(selectedVisnName)){
			addActionError("Please select a VISN.");
			return SELECT_STAFF;
		}

		if(StringUtils.isBlank(selectedFacilityName)){
			addActionError("Please select a Facility.");
			return SELECT_STAFF;
		}


		List<User> staffMembers= new ArrayList<User>();
		clinicians = new ArrayList<Clinician>();
		Clinician clin = null;
		String stationNumber = null;
		facilities = new TreeSet<Facility>();

		getStaffSessionAttr();
		String activationType = null;

		if(((String)getSessionAttribute("activationType")) != null){
			activationType = (String)getSessionAttribute("activationType");
		}
		if(((String)getSessionAttribute("stationNumber")) != null){
			stationNumber = (String)getSessionAttribute("stationNumber");
		}

		if((selectAction != null) && (selectAction.equalsIgnoreCase("Search"))){

			if(searchCrit == null){
				addActionError("Please select a radio button.");
				return SELECT_STAFF;
			}
			if(stationNumber == null){
				log.info("selectedVisnName:  " + selectedVisnName);
				if(StringUtils.isBlank(selectedVisnName)){
					addActionError("Please select a VISN.");
					return SELECT_STAFF;
				}else{
					addActionError("Please select a facility.");
					return SELECT_STAFF;
				}
			}
			log.info("stationNumber: " + stationNumber);
			try{
				if(searchCrit.equalsIgnoreCase("0")){
					if((lastName == null) || ((lastName.trim()).equals(""))){
						addActionError("Please enter the last Name and select the 'Search by Name' radio button.");
						return SELECT_STAFF;
					}
					log.info("last name:" + lastName.toString());
					if((firstName == null) || ((firstName.trim()).equals(""))){firstName = null;}

					if(firstName !=null) firstName = firstName.trim();
					if(lastName !=null) lastName = lastName.trim();

					if((activationType != null) && (activationType.equalsIgnoreCase("inactivate"))){
						clinicians = (List<Clinician>) userManagementService.searchForClinicians(firstName, lastName, stationNumber, true).getCollection();
					}else if((activationType != null) && (activationType.equalsIgnoreCase("reactivate"))){
						clinicians = (List<Clinician>) userManagementService.searchForClinicians(firstName, lastName, stationNumber, false).getCollection();
					}else{
						CollectionServiceResponse<User> response = getAdminService().findVistaClinician(lastName, firstName, stationNumber);
						handleErrorMessages(response.getMessages());
						staffMembers = (List<User>)response.getCollection();

						List userManagementStaffMembers = (List<Clinician>) userManagementService.searchForClinicians(firstName, lastName, stationNumber).getCollection();

						if(staffMembers == null){
							addActionError("A search of the VistA database did not produce a match for the information given.");
							return SELECT_STAFF;
						}
						staffMembers = filterStaffMembers(staffMembers,userManagementStaffMembers);
					}
				}else{
					if((duz == null) || ((duz.trim()).equals(""))){
					addActionError("Please enter DUZ and select 'Search by DUZ' radio button");
					return SELECT_STAFF;
					}
					log.info("duz:" + duz.toString());

					if(duz !=null) duz=duz.trim();
					if((activationType != null) && (activationType.equalsIgnoreCase("inactivate"))){
						ServiceResponse<Clinician> response = userManagementService.getClinicianForStationAndDuz(stationNumber, duz, true);
						clin = response.getPayload();
					}else if((activationType != null) && (activationType.equalsIgnoreCase("reactivate"))){
						ServiceResponse<Clinician> response = userManagementService.getClinicianForStationAndDuz(stationNumber, duz, false);
						clin = response.getPayload();

					}else{
						CollectionServiceResponse<User> response = getAdminService().findVistaClinician(duz, stationNumber);
						handleErrorMessages(response.getMessages());
						staffMembers = (List<User>)response.getCollection();
						Clinician clinician =  userDao.findAuthClinicianByStationAndDuz(stationNumber,duz);
						ArrayList<Clinician> userManagementStaffMembers = new ArrayList<Clinician>();
						if(clinician !=null)
							userManagementStaffMembers.add(clinician);

						if(staffMembers == null){
							addActionError("A search of the VistA database did not produce a match for the information given.");
						}
						if(userManagementStaffMembers.size()!=0)
							staffMembers = filterStaffMembers(staffMembers,userManagementStaffMembers);
					}

					if(clin!=null){
						clinicians.add(clin);
						}
					}

			}catch(Exception e){
				log.error( e.getMessage() );
				addActionError("An error occurred while finding the users.");
			}

			setSessionAttribute("staffMembers",staffMembers);
			setSessionAttribute("clinicians",clinicians);


			if((activationType != null) && ((activationType.equalsIgnoreCase("inactivate")) || (activationType.equalsIgnoreCase("reactivate")))){
				return QUERY_RESULTS_IR;
			}

			return SUCCESS;

		}

		try{
			String cf = getParameter("changeFacility");
			if(!StringUtils.isBlank(cf) && cf.equalsIgnoreCase("yes")){
				selectedFacilityName = null;
			}
		}catch(Exception e){
			log.info("Exception occurred in changeFacility");
		}

		return SELECT_STAFF;
	}

	/**
	 * filteredStffMembers
	 * @param vistaStaffMembers
	 * @param userManagementStaffMembers
	 * @return List<User>
	 */
	private List<User> filterStaffMembers(List<User> vistaStaffMembers,List<Clinician> userManagementStaffMembers){

		ArrayList<User> filteredStaffMembers = new ArrayList<User>();
		ArrayList<String> activeClinicians = new ArrayList<String>();
		for(Clinician clinician:userManagementStaffMembers){
			if(clinician.getDuz()!=null){
				activeClinicians.add(clinician.getDuz());
			}
		}
		for(User user:vistaStaffMembers){
			if(!activeClinicians.contains(user.getIEN())){
				filteredStaffMembers.add(user);
			}
		}
		return filteredStaffMembers;
	}

	public String associateNetworkId(){

		if(appliedCancel()){ return CANCEL;	}
		User selectedVistaUser = null;
		try{
			duz = (getParameter("ien") == null)?"":getParameter("ien");
			if(duz == null){
				addActionError("Could not find IEN for the selected user.");
			}
			List<User> searchedUsers = (List<User>)getSessionAttribute("staffMembers");
			if(searchedUsers != null){
				for(User u:searchedUsers){
					if(duz.equalsIgnoreCase(u.getIEN())){
						selectedVistaUser = u;
					}
				}
			}
			if(selectedVistaUser != null){
	 			firstName = (selectedVistaUser.getFirstName() == null)?"":selectedVistaUser.getFirstName();
	 			lastName = (selectedVistaUser.getLastName() == null)?"":selectedVistaUser.getLastName();
				phone = (selectedVistaUser.getPhone() == null)?"":selectedVistaUser.getPhone();
	 			title = (selectedVistaUser.getTitle() == null)?"":selectedVistaUser.getTitle();

			}
			setSessionAttribute("selectedVistaUser",selectedVistaUser);
			setSessionAttribute("duz",duz);
		}catch(Exception e){
			log.info("Exception occurred while getting selected user details.");
		}

		return SUCCESS;
	}


	public String verifyWithADResults(){

		if(appliedCancel()){ return CANCEL;	}

		getStaffSessionAttr();

		if(isNewSearch()){ return SELECT_STAFF;	}

		if((networkId == null) || ((networkId.trim()).equals(""))){
			addActionError("Please enter the Network ID.");
			return FAILED;
		}

		String stationNumber = null;
		if(((String)getSessionAttribute("stationNumber")) != null){
			stationNumber = (String)getSessionAttribute("stationNumber");
		}

		if (stationNumber == null) {
			addActionError("Please select a facility.");
			return SELECT_STAFF;
		}

		Clinician existingClinician = userDao.findClinicianByStationAndUsername(stationNumber, networkId);
		if (existingClinician != null) {
			addActionError("Network ID " +
						   networkId +
						   " is already in use at this station by " +
						   (existingClinician.isActive() ? "active" : "inactive") +
						   " staff member " +
						   existingClinician.getName());
			return FAILED;
		}

		ADQueryResult staffADResults = null;
		firstNameAD = "";
		lastNameAD = "";
		phoneAD = "";
		titleAD = "";
		networkIdAD = "";
		emailAD = "";
		try{
			log.info("findADAccount - networkId:" + networkId.toString());
			ServiceResponse<ADQueryResult> response = getAdminService().findADAccount(networkId);
			staffADResults = response.getPayload();
			if(staffADResults == null){
				log.info("AD Results: Null");
				addActionError("An Email Address could not be found in Outlook using the VistA search results.");
				return FAILED;
			}else{

				firstNameAD = (staffADResults.getFirstName() == null)?"":staffADResults.getFirstName();
				lastNameAD = (staffADResults.getLastName() == null)?"":staffADResults.getLastName();
				phoneAD = (staffADResults.getTelephoneNumber() == null)?"":staffADResults.getTelephoneNumber();
				titleAD = (staffADResults.getTitle() == null)?"":staffADResults.getTitle();
				emailAD = (staffADResults.getEmail() == null)?"":staffADResults.getEmail();
				setSessionAttribute("email",emailAD);
				networkIdAD = networkId;
				this.setEmail(emailAD);
				staffADResults.setUserName(networkId);
			}
		}catch(Exception e){
			log.error( e.getMessage() );
			addActionError("Error occurred while accessing the active directory.");
		}

		setSessionAttribute("staffADResults",staffADResults);

		return SUCCESS;
	}

	public String assignStaffMemberType(){


		if(appliedCancel()){ return CANCEL;	}

		getStaffSessionAttr();

		if(isNewSearch()){ return SELECT_STAFF;	}
		duz = (String)getSessionAttribute("duz");
		staffMemberTypes = (List<ClinicalUserType>)getAdminService().getClinicalUserTypes().getCollection();
		return SUCCESS;
	}

	public String activateStaffMember(){

		if(appliedCancel()){ return CANCEL;	}

		getStaffSessionAttr();

		if(isNewSearch()){ return SELECT_STAFF;	}

		ClinicalUserType clinicalUserType = null;
		boolean userTypeSelected = false;
		duz = (String)getSessionAttribute("duz");
		String stationNumber = (String)getSessionAttribute("stationNumber");
		User selectedVistaUser = (User)getSessionAttribute("selectedVistaUser");
		ADQueryResult adr = (ADQueryResult)getSessionAttribute("staffADResults");

		staffMemberTypes = (List<ClinicalUserType>)getAdminService().getClinicalUserTypes().getCollection();
		if(staffMemberTypes != null){
			for(ClinicalUserType cu: staffMemberTypes){
				if((cu.getId()).equals(memberTypeId)){
					clinicalUserType = cu;
					memberType = cu.getName();
					userTypeSelected = true;
				}
			}
		}
		if(!userTypeSelected){
			addActionError("Please select a user type.");
			setSessionAttribute("email",getEmail());
			return FAILED;
		}

		// The following condition has been implemented for the part of CR#4652(Clinician must have valid email address).
		if(getEmail()==null || getEmail().equals("")){
			addActionError("Email Address cannot be blank.");
			return FAILED;
		}
		else
		{
			EmailValidator emailValidator = EmailValidator.getInstance();
			if(!emailValidator.isValid(email)){
				addActionError(email + " is not a Valid Email Address.");
				setEmail(getEmail());
				setSessionAttribute("email",getEmail());
				return FAILED;
			}
			else
			{
				adr.setEmail(getEmail());
				setSessionAttribute("email",getEmail());
			}
		}

		Administrator admin = (Administrator)getSessionAttribute(CURRENT_USER);
		Clinician clin = null;

		try{
			if (log.isInfoEnabled())
				log.info(selectedVistaUser.getFirstName()+" "+selectedVistaUser.getLastName()+" "+selectedVistaUser.getProviderIndicator());
			ServiceResponse<Clinician> response = getAdminService().createClinicianAccount(stationNumber, selectedVistaUser, adr,clinicalUserType, admin);
			clin = response.getPayload();

		}catch(Exception e){
			log.error( e.getMessage() );

		}

		if (clin == null){
			addActionError("Error occurred while activating the account.");
			return FAILED;
		}

		return SUCCESS;
	}

	public String activateAnotherStaffMember(){

		if((selectAction!=null) && ((selectAction.trim()).equalsIgnoreCase("Done"))){
			clearSessionAttr();
			return CANCEL;
		}

		getStaffSessionAttr();

		return SELECT_STAFF;
	}


	public String showMemberDetails(){

		if(appliedCancel()){ return CANCEL;	}
		Clinician clin = null;
		try{
			duz = (getParameter("duz") == null)?"":getParameter("duz");
			if(duz == null){
				addActionError("Could not find DUZ for the selected user.");
			}
			List<Clinician> searchedUsers = (List<Clinician>)getSessionAttribute("clinicians");
			if(searchedUsers != null){
				for(Clinician u:searchedUsers){
					if(duz.equalsIgnoreCase(u.getDuz())){
						clin = u;
					}
				}
			}
			if(clin != null){
	 			firstName = (clin.getFirstName() == null)?"":clin.getFirstName();
	 			lastName = (clin.getLastName() == null)?"":clin.getLastName();
	 			networkId = (clin.getUsername() == null)?"":clin.getUsername();

				ClinicalUserType cu = (ClinicalUserType)clin.getClinicalUserType();
				if(cu != null){
					memberType = (cu.getName() == null)?"":cu.getName();
				}
			}
			setSessionAttribute("selectedUser",clin);
			setSessionAttribute("duz",duz);
		}catch(Exception e){
			log.info("Exception occurred while getting selected user details.");
		}

		return SUCCESS;

	}


	public String inactivateReactivateMember(){

		if(appliedCancel()){ return CANCEL;	}

		getStaffSessionAttr();

		if(isNewSearch()){ return SELECT_STAFF;	}
		String activationType = (String)getSessionAttribute("activationType");
		try {
			Clinician c = (Clinician)getSessionAttribute("selectedUser");
			if(c != null){
				if((activationType != null) && (activationType.equalsIgnoreCase("inactivate"))){
					c = (Clinician) userManagementService.inactivateReactivateClinician(c, false).getPayload();
				}else if((activationType != null) && (activationType.equalsIgnoreCase("reactivate"))){
					c = (Clinician) userManagementService.inactivateReactivateClinician(c, true).getPayload();
				}
			}
		} catch (Exception e) {
			log.info("Exception occurred while inactivating the selected user.");
			addActionError("Error occurred while inactivating the selected user.");
		}

		return SUCCESS;

	}

	public String inactivationReactivationComplete(){

		clearSessionAttr();
		return CANCEL;

	}

	public String bulkActivation() {
		if(appliedCancel()){ return CANCEL;	}
		clearSessionAttr();
		List<User> staffMembers= new ArrayList<User>();
		boolean activationSuccess = true;
		try{

			log.info("file name: " + uploadFileName);
			uploadFileName = (uploadFileName == null)?"":uploadFileName;
			if(uploadFileName.equals("")){
				if(!checkFileSizeMessage()){
					addActionError("Please select a file");
				}
				return FAILED;
			}
			log.info("Content type: " + getUploadContentType());
			Object rawContent = getUpload().toURL().getContent();

			InputStream is = (InputStream)rawContent;
			Reader reader = new InputStreamReader(is);
			StringBuilder content = new StringBuilder();
			int read = 0;
			while ( read > -1 ) {
				char[] buffer = new char[1024];
				read = reader.read(buffer);
				content.append(buffer);
				if(FILE_SIZE_LIMIT_2MB<content.length()) {
					addActionError(FILE_SIZE_LIMIT_ERROR);
					return FAILED;
				}
			}
			if(log.isInfoEnabled()){
				log.info("Contents:\n" + content.toString().trim());
			}
			String fileContent = content.toString().trim();
			if(fileContent.length() == 0){
				addActionError("The bulk addition of user records failed" +
						" because of the following records. " +
						"Correct these records and repeat bulk addition:");

				addActionError("Line 1-incorrectly formatted.");
				addActionError("No Secure Messaging Staff Members have been activated.");
				return FAILED;
			}
			String[] rows = fileContent.split("\r\n");
			//Validate the Bulk Record File
			if(validateBulkRecordFile(rows)){
				addActionError("No Secure Messaging Staff Members have been activated.");
				return FAILED;
			}else{
				String recordType;
				String firstName;
				String lastName;
				String stationNumber;
				added=0;
				int lineNumber = 0;
				for (int i=0; i<rows.length; i++){
					log.info("Line" + i + ":" + rows[i]);
					String rowData = rows[i];
					String[] fields = rowData.split(",");
					recordType  = fields[0].trim();
					firstName  = fields[1].trim();
					lastName  = fields[2].trim();
					duz  = fields[3].trim();
					stationNumber  = fields[4].trim();
					networkId  = fields[5].trim();
					Long clinicalUserTypeId  = Long.valueOf(fields[6].trim());
					lineNumber = i + 1;
					log.info("firstName= "+firstName);
					log.info("lastName= "+lastName);
					log.info("duz:" + duz.toString());
					log.info("stationNumber:" + stationNumber.toString());
					log.info("clinicalUserTypeId:" + clinicalUserTypeId.toString());
					log.info("networkId:" + networkId.toString());
					boolean isAdded = activateBulkStaffMember(lineNumber, duz,stationNumber, clinicalUserTypeId, networkId, firstName, lastName);
					if(isAdded){
						added++;
					}
					activationSuccess = activationSuccess && isAdded;
				}
			}
		}catch (java.io.FileNotFoundException e) 	{
			addActionError("The bulk addition of user records failed" +
					" because of the following records. " +
					"Correct these records and repeat bulk addition:");

			addActionError("Line 1-incorrectly formatted.");
			addActionError("No Secure Messaging Staff Members have been activated.");
			log.error(e);
			return FAILED;

		} catch(Exception e) {
			log.error(e);
			return FAILED;
		}

		if(activationSuccess){
			return SUCCESS;
	    }else{
	    	return FAILED;
	    }
	}

	/**
	 * There are two limits for file upload size struts.multipart.maxSize and maximumSize in the action
	 * interceptor. The problem is for bug :5391 providing custom message is not easy as the
	 * error message is hardcoded in MultiPartRequest. In the following code the exception is
	 * trapped and replaced with the message as stated in specification.
	 */

	private boolean checkFileSizeMessage() {
		boolean hasSizeError = false;
		Collection<?> tmp = getActionErrors();
		if(tmp!= null){
			Collection<String> errors = new ArrayList<String>();
			for (Object o : tmp) {
				if(o != null){
				     if (o.toString().contains("the request was rejected because its size")) {
				       hasSizeError = true;
				       errors.add(FILE_SIZE_LIMIT_ERROR);
				     } else {
				       errors.add(o.toString());
				     }
				}
			}

			setActionErrors(errors);
		}
		return hasSizeError;
	}

	/*
	 * Validate the Bulk Record File, it is a Comma Separated Values (CSV) file where each row is expected to
	 * have a certain number and type of fields. Text fields are enclosed in quotes.
	 * BR3902 The Bulk Record Schema
	 * Retruns true if file is not formating is wrong.
	 * C,FNAME,LNAME,DUZ,STATION_NO,EXTERNAL_USERNAME,CLINICAL_USER_TYPE_ID
       C,JOHN,DOE,12345,994,DNS   JDOE,1
	 */
	private boolean validateBulkRecordFile(String[] rows){
		//keep track of duplicates in current file users
		Map currentFileUsers = new HashMap();

		boolean fileFailed = false;
		for (int i=0; i<rows.length; i++){

			log.info("Line" + i + ":" + rows[i]);
			boolean failed = false;
			int lineNumber = i + 1;
			String rowData = rows[i];
			String[] fields = rowData.split(",");
			//check if this row has all fields
			if(fields.length == 7){
				String lrecordType  = fields[0].trim();
				//check if Record Type is not null and maximum length is 1
				if(lrecordType== null || lrecordType.length() >1){
					failed = true;
				}
				//check first name
				String lfirstName  = fields[1].trim();
				if(lfirstName == null || lfirstName.length() >50){
					failed = true;
				}
				//check last name
				String llastName  = fields[2].trim();
				if(llastName == null || llastName.length() >50){
					failed = true;
				}
				//check DUZ
				String lduz  = fields[3].trim();
				if(lduz == null || lduz.length() >20){
					failed = true;
				}
				//check STATION_NO
				String lstationNumber  = fields[4].trim();
				if(lstationNumber == null || lstationNumber.length() >10){
					failed = true;
				}
				//check EXTERNAL_USER_NAME
				String lnetworkId  = fields[5].trim();
				if(lnetworkId == null || lnetworkId.length() >50){
					failed = true;
				}
				//check CLINICAL_USER_TYPE_ID
				try{
					Long lclinicalUserTypeId  = Long.valueOf(fields[6].trim());
					if(lclinicalUserTypeId == null){
						failed = true;
					}
				}catch(java.lang.NumberFormatException ex){
					//the clinical user type if is not a number.
					failed = true;
				}

				//if failed because of format
				if(failed){
					if(!fileFailed){
						fileFailed = true;
						addActionError("The bulk addition of user records failed" +
								" because of the following records. " +
								"Correct these records and repeat bulk addition:");
					}
					addActionError("Line " + lineNumber + "-incorrectly formatted.");
				}else{
					String tmpStationNumber = (String)currentFileUsers.get(lnetworkId);

					if(tmpStationNumber!=null){
						if(tmpStationNumber.equals(lstationNumber)){
							if(!fileFailed){
								fileFailed = true;
								addActionError("The bulk addition of user records failed" +
										" because of the following records. " +
										"Correct these records and repeat bulk addition:");
							}
							addActionError("Line " + lineNumber + "- Duplicate Network ID " +lnetworkId +
										   " is already listed in this file at this station by" +
										   " staff member " +
										   lfirstName+","+llastName);

						}


					}else{
						currentFileUsers.put(lnetworkId,lstationNumber);
					}


					//ensure that you can never activate new staff members that have the same external_user_name and station_no
					Clinician existingClinician = userDao.findClinicianByStationAndUsername(lstationNumber, lnetworkId);
					if (existingClinician != null) {
						if(!fileFailed){
							fileFailed = true;
							addActionError("The bulk addition of user records failed" +
									" because of the following records. " +
									"Correct these records and repeat bulk addition:");
						}
						addActionError("Line "  + lineNumber + "- Network ID " +lnetworkId +
									   " is already in use at this station by " +
									   (existingClinician.isActive() ? "active" : "inactive") +
									   " staff member " +
									   existingClinician.getName());

					}
				}
			}else{
				if(!fileFailed){
					fileFailed = true;
					addActionError("The bulk addition of user records failed" +
							" because of the following records. " +
							"Correct these records and repeat bulk addition:");
				}
				addActionError("Line " + lineNumber + "-incorrectly formatted.");
			}
		}
		return fileFailed;

	}

	public boolean activateBulkStaffMember(int lineNumber, String duz,String stationNumber, Long clinicalUserTypeId, String networkId, String firstName, String lastName){
		boolean successfullyActivated = true;

		Clinician clin = null;
		Administrator admin = (Administrator)getSessionAttribute(CURRENT_USER);
		log.info("Admin isNational???........."+admin.isNational());

		boolean permission = false;

		//If logged-in user is National Admin, they have rights to manage the any facility user.
		if(admin.isNational()){
			permission = true;
		}

		// If logged-in user is VISN Admin, they have rights to manage any facilities under the visn.
		if(admin.getVisns() !=null) {
			log.info("admin.getVisins()......"+admin.getVisns());
			for (Facility visn: admin.getVisns())
			{
				Collection<Facility> facilities = getFacilityService().getFacilitiesForVisn(visn).getCollection();
				for(Facility f1 : facilities){
					log.info("f1.getId()...."+f1.getId());
					log.info("f1.getName...."+f1.getName());
					log.info("f1.getStationNumber()......."+f1.getStationNumber());
					if(f1.getStationNumber().equalsIgnoreCase(stationNumber)){
						permission = true;
						break;
					}
				}
			}
		}

		// If logged-in user is Facility Admin, they have rights to manage only the associated user facilities.
		for(Facility f:admin.getFacilities()) {
			if( f.getStationNumber().equalsIgnoreCase(stationNumber) ) {
				permission = true;
				break;
			}
		}

		log.info("permission........."+permission);


		if( !permission ) {
			addActionError("Line " + lineNumber + ": The staff member's facility doesn't match a facility you can manage.");
			successfullyActivated = false;
		}

		User selectedVistaUser = null;
		List<User> staffMembers= new ArrayList<User>();
		CollectionServiceResponse<User> response = getAdminService().findVistaClinician(duz, stationNumber);
		handleErrorMessages(response.getMessages());
		staffMembers = (List<User>)response.getCollection();
		if(staffMembers == null){
			addActionError("Line " + lineNumber + ": A search of the VistA database did not produce a match for the information given.");
			successfullyActivated = false;
		}else{
			for(User u:staffMembers){
					if(duz.equalsIgnoreCase(u.getIEN())){
					selectedVistaUser = u;
				}
			}
		}
		if(selectedVistaUser == null){
			addActionError("Line " + lineNumber + ": A search of the VistA database did not produce a match for the information given.");
			successfullyActivated = false;
		}

		ClinicalUserType clinicalUserType = null;
		staffMemberTypes = (List<ClinicalUserType>)getAdminService().getClinicalUserTypes().getCollection();
		if(staffMemberTypes != null){
			for(ClinicalUserType cu: staffMemberTypes){
				if((cu.getId()).equals(clinicalUserTypeId)){
					clinicalUserType = cu;
				}
			}
		}
		if(clinicalUserType == null){
			log.info("clinicalUserType: Null");
			addActionError("Line " + lineNumber + ": A search for clinical user type could not produce a match");
			successfullyActivated = false;
		}

		ADQueryResult staffADResults = null;
		ServiceResponse<ADQueryResult> findADAccountResponse = getAdminService().findADAccount(networkId);
		staffADResults = findADAccountResponse.getPayload();
		if(staffADResults == null){
			log.info("AD Results: Null");
			addActionError("Line " + lineNumber + ": An Email Address could not be found in Outlook using the VistA search results.");
			successfullyActivated = false;
		}else{
			staffADResults.setUserName(networkId);
		}

		if(null!=staffADResults && null!=staffADResults.getFirstName() && !staffADResults.getFirstName().equalsIgnoreCase(firstName) ) {

			log.info("AD firstname didn't match bulk record: " + staffADResults.getFirstName() + ", " + firstName);
			addActionError("Line " + lineNumber + ": " + (lastName==null?"null":lastName) + ", " + firstName + " is not recognized as an Outlook email account.");
			successfullyActivated = false;
		}

		if(null!=staffADResults && !staffADResults.getLastName().equalsIgnoreCase(lastName) ) {
			log.info("AD lastname didn't match bulk record: " + staffADResults.getLastName() + ", " + lastName);
			addActionError("Line " + lineNumber + ": " + lastName + ", " + (firstName==null?"null":firstName) + " is not recognized as an Outlook email account.");
			successfullyActivated = false;
		}

		if(staffADResults.getEmail()!=null && !staffADResults.getEmail().equals("")){
			EmailValidator emailValidator = EmailValidator.getInstance();
			if(!emailValidator.isValid(staffADResults.getEmail())){
				addActionError("Line " + lineNumber +  ": Outlook Email Address is invalid.");
				successfullyActivated = false;
			}
		}
		else
		{
			addActionError("Line "+ lineNumber + ": Outlook Email Address can't be blank.");
			successfullyActivated = false;
		}

		try {
			if( true == successfullyActivated ) {
				ServiceResponse<Clinician> response1 = getAdminService().createClinicianAccount(stationNumber, selectedVistaUser, staffADResults, clinicalUserType, admin);
				clin = response1.getPayload();
			}
		} catch(Exception e){
			successfullyActivated = false;
			log.error( e.getMessage() );
		}

		if (clin == null){
			addActionError("Line " + lineNumber + ": Error occurred while activating the account.");
			successfullyActivated = false;
		}

		return successfullyActivated;
	}

	public String bulkActivationComplete() {

		clearSessionAttr();
		if((selectAction!=null) && ((selectAction.trim()).equalsIgnoreCase("Done"))){
			return CANCEL;
		}

		return SUCCESS;
	}


	public void getStaffSessionAttr(){

		if(((Collection<Facility>)getSessionAttribute("facilities")) != null){
			facilities = (Collection<Facility>)getSessionAttribute("facilities");
		}else{
			facilities = new ArrayList<Facility>();
		}
		if(((String)getSessionAttribute("selectedVisnName")) != null){
			selectedVisnName = (String)getSessionAttribute("selectedVisnName");
		}
		if(((String)getSessionAttribute("selectedFacilityName")) != null){
			selectedFacilityName = (String)getSessionAttribute("selectedFacilityName");
		}

	}

	public void clearSessionAttr(){
		removeSessionAttribute("facilities");
		removeSessionAttribute("selectedVisnName");
		removeSessionAttribute("selectedFacilityName");
		removeSessionAttribute("stationNumber");
		removeSessionAttribute("staffMembers");
		removeSessionAttribute("activationType");
	}

	public boolean appliedCancel() {

		if((selectAction!=null) && ((selectAction.trim()).equalsIgnoreCase("Cancel"))){
			clearSessionAttr();
			return true;
		}
		return false;

	}

	public boolean isNewSearch() {

		if((selectAction!=null) && ((selectAction.trim()).equalsIgnoreCase("New Search"))){
			return true;
		}
		return false;

	}


	public void setVisns(Collection<Facility> visns) {
			this.visns = visns;
	}

	public Collection<Facility> getVisns() {
			return visns;
	}

	public void setFacilities(Collection<Facility> facilities) {
			this.facilities = facilities;
	}

	public Collection<Facility> getFacilities() {
			return this.facilities;
	}

	public void setSelectedVisnName(String selectedVisnName) {
			this.selectedVisnName = selectedVisnName;
	}

	public String getSelectedVisnName() {
			return selectedVisnName;
	}

	public void setSelectedFacilityName(String selectedFacilityName) {
			this.selectedFacilityName = selectedFacilityName;
	}

	public String getSelectedFacilityName() {
			return selectedFacilityName;
	}

	public void setVisnId(Long visnId) {
			this.visnId = visnId;
	}

	public Long getVisnId() {
			return this.visnId;
	}

	public void setFacilityId(Long facilityId) {
			this.facilityId = facilityId;
	}

	public Long getFacilityId() {
			return this.facilityId;
	}

	public void setClinicians(List<Clinician> clinicians) {
			this.clinicians = clinicians;
	}

	public List<Clinician> getClinicians() {
			return clinicians;
	}

	public void setSelectAction(String selectAction) {
		this.selectAction = selectAction;
	}

	public String getSelectAction() {
		return selectAction;
	}

	public void setSelectedUsers(List<Clinician> selectedUsers) {
			this.selectedUsers = selectedUsers;
	}

	public List<Clinician> getSelectedUsers() {
			return selectedUsers;
	}

	public void setSearchCrit(String searchCrit) {
			this.searchCrit = searchCrit;
	}

	public String getSearchCrit() {
			return searchCrit;
	}

	public void setDuz(String duz) {
			this.duz = duz;
	}

	public String getDuz() {
			return duz;
	}

	public void setFirstName(String firstName) {
			this.firstName = firstName;
	}

	public String getFirstName() {
			return firstName;
	}

	public void setLastName(String lastName) {
			this.lastName = lastName;
	}

	public String getLastName() {
			return lastName;
	}

	public void setPhone(String phone) {
			this.phone = phone;
	}

	public String getPhone() {
			return phone;
	}

	public void setTitle(String title) {
			this.title = title;
	}

	public String getTitle() {
			return title;
	}

	public void setNetworkId(String networkId) {
			this.networkId = networkId;
	}

	public String getNetworkId() {
			return networkId;
	}

	public void setStaffMemberTypes(List<ClinicalUserType> staffMemberTypes) {
			this.staffMemberTypes = staffMemberTypes;
	}

	public List<ClinicalUserType> getStaffMemberTypes() {
			return staffMemberTypes;
	}

	public void setMemberTypeId(Long memberTypeId) {
			this.memberTypeId = memberTypeId;
	}

	public Long getMemberTypeId() {
			return memberTypeId;
	}

	public void setMemberType(String memberType) {
			this.memberType = memberType;
	}

	public String getMemberType() {
			return memberType;
	}

	public void setFirstNameAD(String firstNameAD) {
			this.firstNameAD = firstNameAD;
	}

	public String getFirstNameAD() {
			return firstNameAD;
	}

	public void setLastNameAD(String lastNameAD) {
			this.lastNameAD = lastNameAD;
	}

	public String getLastNameAD() {
			return lastNameAD;
	}

	public void setPhoneAD(String phoneAD) {
			this.phoneAD = phoneAD;
	}

	public String getPhoneAD() {
			return phoneAD;
	}


	public void setTitleAD(String titleAD) {
			this.titleAD = titleAD;
	}

	public String getTitleAD() {
			return titleAD;
	}

	public void setNetworkIdAD(String networkIdAD) {
			this.networkIdAD = networkIdAD;
	}

	public String getNetworkIdAD() {
			return networkIdAD;
	}

	public String getUploadContentType() {
		return uploadContentType;
	}

	public void setUploadContentType(String contentType) {
		this.uploadContentType = contentType;
	}

	public File getUpload() {
		return upload;
	}

	public void setUpload(File file) {
		this.upload = file;
	}

	public String getUploadFileName() {
		return uploadFileName;
	}

	public void setUploadFileName(String filename) {
		this.uploadFileName = filename;
	}

	public String getEmailAD() {
		return emailAD;
	}

	public void setEmailAD(String emailAD) {
		this.emailAD = emailAD;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public UserDao getUserDao() {
		return userDao;
	}

	public void setUserDao(UserDao userDao) {
		this.userDao = userDao;
	}


	public int getAdded() {
		return added;
	}


	public void setAdded(int added) {
		this.added = added;
	}


}
