package gov.va.med.mhv.sm.web.actions;

import gov.va.med.mhv.sm.model.Facility;
import gov.va.med.mhv.sm.model.Patient;
import gov.va.med.mhv.sm.service.ReAssignMessageService;
import gov.va.med.mhv.sm.service.UserManagementService;
import gov.va.med.mhv.sm.util.DateUtils;
import gov.va.med.mhv.sm.web.form.PatientReassignFacilityVO;
import gov.va.med.mhv.sm.web.util.PatientVO;
import gov.va.med.mhv.sm.wsclient.IntegrationServiceDelegate;
import gov.va.med.mhv.sm.wsclient.queriessvc.Address;
import gov.va.med.mhv.sm.wsclient.queriessvc.PatientDemographics;

import java.util.ArrayList;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ManagePatientFacilityRequest extends BaseSMAdminAction  {

	@SuppressWarnings("unused")
	private static final Log log = LogFactory.getLog(ManagePatientFacilityRequest.class);
	
	private ReAssignMessageService reAssignMessageService;
	private UserManagementService userManagementService;
	private IntegrationServiceDelegate delegate;
	protected static final String ADD_FACILITY_VISN_ATTR_NAME = "ADD_FACILITY_VISN_ATTR_NAME";
	protected static final String ADD_FACILITY_FACILITY_ATTR_NAME = "ADD_FACILITY_FACILITY_ATTR_NAME";
	protected static final String SELECTED_FACILITY_ID = "SELECTED_FACILITY_ID";
	public static final String PATIENT_LOOKUP_POPUP = "PatientLookupPoupUp";
	public static final String DELETE_CONFIRMATION_POPUP="DeletePopup";
	public static final String DELETE_ID="deleteId";
	public static final String PATIENT_VO="patientVo";
	
	private List managePatientFacilityList;
	private String patientTreatmentFacilities;
	
	public void prepare() throws Exception {
		WebApplicationContext ctx = WebApplicationContextUtils
		.getWebApplicationContext(ServletActionContext.getServletContext());
		reAssignMessageService = (ReAssignMessageService)ctx.getBean("reAssignMessageService");
		userManagementService = (UserManagementService) ctx.getBean("userManagementService");
		
	}
	
	public String showVisn() {
		if ( cancelButtonPressed() ) {
			return "CANCEL";
		}
		removeSessionAttribute();
		return SUCCESS;
	}
	
	public String chooseVisn() 
	{
		removeSessionAttribute(SELECTED_FACILITY_ID);
		removeSessionAttribute(ADD_FACILITY_FACILITY_ATTR_NAME);
		if ( cancelButtonPressed() ) {
			
			return "CANCEL";
		}
		Long newVisnId = getParameterAsLong("visnId");
		Facility oldVisn = (Facility)getSessionAttribute(ADD_FACILITY_VISN_ATTR_NAME);
		return SUCCESS;
	}
	
	protected boolean cancelButtonPressed() {
		return ! StringUtils.isBlank(getParameter("[CANCEL BUTTON]"));
	}

	public Facility getVisn() {
		Facility visn = (Facility)getSessionAttribute(ADD_FACILITY_VISN_ATTR_NAME);
		if ( visn == null && ! getShowAdministeredVisnList() ) {
			visn = getAdministeredVisns().iterator().next();
			this.setSessionAttribute(ADD_FACILITY_VISN_ATTR_NAME, visn);
		}
		return visn;
	}

	public boolean getShowAdministeredVisnList() {
		boolean result = getAdministeredVisns().size() > 1;
		return result;
	}

	public Collection<Facility> getAdministeredFacilitiesInVisn() {
		if ( this.getVisnId() == null ) {
			return new TreeSet<Facility>();
		} else {
			return getAdministeredFacilitiesInVisn(getVisn());
		}
	}
	
	public Long getVisnId() {
		Facility visn = getVisn();
		if ( visn != null ) {
			return visn.getId();
		} else {
			return null;
		}
	}
	
	public Long getFacilityId() {
		Facility f = getFacility();
		if ( f != null ) {
			return f.getId();
		} else {
			return null;
		}
	}
	
	public Facility getFacility() {
		Facility f = (Facility)getSessionAttribute(ADD_FACILITY_FACILITY_ATTR_NAME);
		if ( f == null && ! this.getShowAdministeredFacilityList() ) {
			f = this.getAdministeredFacilitiesInVisn().iterator().next();
			this.setSessionAttribute(ADD_FACILITY_FACILITY_ATTR_NAME, f);
		}
		return f;
	}
	
	public boolean getShowAdministeredFacilityList() {
		boolean result = this.getAdministeredFacilitiesInVisn().size() > 1
			|| (getCurrentUser().isNational());
		return result;
	}

	public String chooseFacility() {
		
		if ( cancelButtonPressed() ) {
			return "CANCEL";
		}
		Long newId = getParameterAsLong("newFacilityId");
		Long oldId = getFacilityId();
		setFacilityId(newId);
		setSessionAttribute(SELECTED_FACILITY_ID,newId);
		managePatientFacilityList = getReassignFacilitiesRequestList(new Long(getFacility().getStationNumber()));
		Collections.sort(managePatientFacilityList,Collections.reverseOrder());
		return SUCCESS;
	}
	
	public String viewPatientFacilityDetails(){
		Long selectedFacilityId = (Long)getSession().getAttribute(SELECTED_FACILITY_ID);
		setFacilityId(selectedFacilityId);
		managePatientFacilityList = getReassignFacilitiesRequestList(new Long(getFacility().getStationNumber()));
		Collections.sort(managePatientFacilityList,Collections.reverseOrder());
		return SUCCESS;
	}
	
	public String deleteConfirmation(){
		String reassignFacilityId=getRequest().getParameter("id");
		setSessionAttribute(DELETE_ID,reassignFacilityId);
		setSessionAttribute(DELETE_CONFIRMATION_POPUP,"TRUE");
		return viewPatientFacilityDetails();
	}
	
	public String deleteReassignFacility(){
		String reassignFacilityId = getRequest().getParameter("id");
			log.info("<<<<<<<<<<444Add to Facility-Delete Patient Reassign Facility Id......"+reassignFacilityId);
			if(reassignFacilityId!=null){
				Boolean updateStatus = reAssignMessageService.updatePatientReassignFacility(new Long(reassignFacilityId)).getPayload();
				if(updateStatus) log.info("<<<<<<<<444Patient Reassign Facility entry deleted successfully");
				else log.info("<<<<<<<<444Add to Facility-Patient Reassign Facility entry is not deleted");
		}
		removeSessionAttribute(DELETE_ID);
		removeSessionAttribute(DELETE_CONFIRMATION_POPUP);
		return SUCCESS;
	}
	
	public String patientLookup(){
		Long selectedFacilityId = (Long)getSession().getAttribute(SELECTED_FACILITY_ID);
		setFacilityId(selectedFacilityId);
		String patientId = getRequest().getParameter("id");
		String reassignByStation=getRequest().getParameter("station");
		
		Patient patient = userManagementService.getPatientById(new Long(patientId)).getPayload();
		log.info("<<<<<<<<<<555Add to Facility-Patient Lookup facilityId"+selectedFacilityId);
		log.info("<<<<<<<<<<555Add to Facility-Patient Lookup PatientId"+patient.getId());
		log.info("<<<<<<<<<<555Add to Facility-Patient Lookup StationNo"+reassignByStation);
		PatientDemographics patientDemographics = userManagementService.getPatientDemographics(patient.getSsn(), reassignByStation).getPayload();
		PatientVO patientVo = new PatientVO();
		patientVo.setName(patient.getName());
		patientVo.setNssn(patient.getNssn());
		patientVo.setDob(DateUtils.getEnglishDate(patient.getDob()));
		if(patientDemographics!=null){
			if(patientDemographics.getHomeAddress()!=null){
				Address patientAddress = patientDemographics.getHomeAddress().getAddress();
				patientVo.setAddress1(patientAddress.getAddressLine1());
				patientVo.setAddress2(patientAddress.getAddressLine2());
				patientVo.setCity(patientAddress.getCity());
				patientVo.setZipcode(patientAddress.getZipCode());
				patientVo.setState(patientAddress.getState());
				patientVo.setPhone(patientDemographics.getHomePhone());
			}
			if(patientVo.getAddress1()==null || patientVo.getAddress1()=="") patientVo.setAddress1("N/A");
			if(patientVo.getAddress2()==null || patientVo.getAddress2()=="") patientVo.setAddress2("N/A");
			if(patientVo.getCity()==null || patientVo.getCity()=="") patientVo.setCity("N/A");
			if(patientVo.getZipcode()==null || patientVo.getZipcode()=="") patientVo.setZipcode("N/A");
			if(patientVo.getState()==null || patientVo.getState()=="") patientVo.setState("N/A");
			if(patientVo.getPhone()==null || patientVo.getPhone()=="") patientVo.setPhone("N/A");
		}else 
		{
			log.info("<<<<<<<<<<555Add to Facility-Patient Demographics is null");
		}
		List<Object[]> patientFacilities=userManagementService.getPatientFacilitiesByUserId(new Long(patientId));
		String treatmentFacilities="";
			if(patientFacilities!=null){
				int count=1;
				for(Object[] facility:patientFacilities){
					 treatmentFacilities+=facility[0].toString();
					 if(count!=patientFacilities.size()) treatmentFacilities+=", ";
					 count++;
			}
		}
		patientVo.setFacilities(treatmentFacilities);
		setSessionAttribute(PATIENT_LOOKUP_POPUP, "TRUE");
		setSessionAttribute(PATIENT_VO,patientVo);
		viewPatientFacilityDetails();
		return SUCCESS;
	}
	
	public String closePopup(){
		removeSessionAttribute(PATIENT_LOOKUP_POPUP);
		removeSessionAttribute(PATIENT_VO);
		viewPatientFacilityDetails();
		return SUCCESS;
	}
	
	
	public void setFacilityId(Long facilityId) {
		setFacility(getFacilityService().getFacility(facilityId).getPayload());
	}
	
	public void setFacility(Facility facility) {
		this.setSessionAttribute(ADD_FACILITY_FACILITY_ATTR_NAME, facility);
	}
	
	
	public List<PatientReassignFacilityVO> getReassignFacilitiesRequestList(Long station){
		List<Object[]> reAssignFacilitiesObj = reAssignMessageService.getPatientReassignFacilityByStation(station).getPayload();
		List reassignFacilitiesRequestList = new ArrayList();
		if(reAssignFacilitiesObj!=null)
		{
			for(Object[] object : reAssignFacilitiesObj)
			{
				PatientReassignFacilityVO patientReassignFacilityVo = new PatientReassignFacilityVO();

				if(object[0]!=null){
					patientReassignFacilityVo.setReassignFacilityId(new Long(object[0].toString()));
				}
				
				if(object[1]!=null){
					patientReassignFacilityVo.setPatientId(new Long(object[1].toString()));
				}
				
				if(object[2]!=null){
					patientReassignFacilityVo.setTriageGroupName(object[2].toString());
				}
				
				if(object[3]!=null){
					patientReassignFacilityVo.setRequestedDate(object[3].toString());
				}
				
				if(object[4]!=null){
					patientReassignFacilityVo.setReassignedBy(object[4].toString());
				}
				
				if(object[5]!=null){
					patientReassignFacilityVo.setPatientName(object[5].toString());
				}
				
				if(object[6]!=null){
					patientReassignFacilityVo.setReassignByStation(object[6].toString());
				}
				
				
				reassignFacilitiesRequestList.add(patientReassignFacilityVo);
			}
		}			
		return reassignFacilitiesRequestList;
	}
	
	public String goBack() {
		String step = getParameter("step");
		setSessionAttribute("POPUPMESSAGE",null);
		if ( ! StringUtils.isBlank(step) ) {
			return "STEP" + step;
		} else {
			return "STEP1";
		}
	}
	
	private void removeSessionAttribute(){
		getSession().removeAttribute(SELECTED_FACILITY_ID);
		getSession().removeAttribute(PATIENT_LOOKUP_POPUP);
		getSession().removeAttribute(DELETE_CONFIRMATION_POPUP);
		getSession().removeAttribute(DELETE_ID);
	}
	
	
	
	public void setVisnId(Long visnId) {
		setSessionAttribute(ADD_FACILITY_VISN_ATTR_NAME, getFacilityService().getFacility(visnId).getPayload());
	}
	
	public List getManagePatientFacilityList() {
		return managePatientFacilityList;
	}

	public void setManagePatientFacilityList(List managePatientFacilityList) {
		this.managePatientFacilityList = managePatientFacilityList;
	}


	public String getPatientTreatmentFacilities() {
		return patientTreatmentFacilities;
	}

	public void setPatientTreatmentFacilities(String patientTreatmentFacilities) {
		this.patientTreatmentFacilities = patientTreatmentFacilities;
	}

	
}
