package gov.va.med.mhv.sm.web.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.Locale;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.foundation.service.response.messages.Message;
import gov.va.med.mhv.foundation.service.response.messages.MessageUtils;
import gov.va.med.mhv.sm.dao.properties.SMWorkloadProperties;
import gov.va.med.mhv.sm.model.Facility;
import gov.va.med.mhv.sm.model.SMClinicsTriageMap;
import gov.va.med.mhv.sm.model.SMClinicsCPRSTitle;
import gov.va.med.mhv.sm.model.TriageGroup;

import gov.va.med.mhv.sm.util.UserUtils;
import gov.va.med.mhv.sm.wsclient.adminqueriessvc.Clinic;
import gov.va.med.mhv.sm.wsclient.adminqueriessvc.SMClinic;
import gov.va.med.mhv.sm.wsclient.adminqueriessvc.SMNoteTitle;

public class ManageGroupsForSMClinics extends BaseSMAdminAction {

	protected static final String SMCLINICS_VISN_ATTR_NAME = "SMCLINICS_VISN_ATTR_NAME";
	protected static final String SMCLINICS_FACILITY_ATTR_NAME = "SMCLINICS_FACILITY_ATTR_NAME";
	protected static final String SMCLINIC_TRIAGE_GROUP_SESSION_KEY = "smClinicTriageGroup";
	private static final Message NO_SMCLINIC_NAME_ENTERED = MessageUtils.createErrorMessage("triagegroup.no.smclinic.name.entered", null, null);
	private static final Message ERROR_SAVING_GROUP = MessageUtils.createErrorMessage("triagegroup.smclinic.save.error", null, null);
	private static final String SM_CPRS_DEFAULT_HEADER="Select a CPRS Title";
	private static Collection<SMClinicsCPRSTitle> allSMClinicsCPRSTitle;
	private static String defaultSMClinicCPRSTitle;
	private static String defaultSMClinic;
	private static String selectedCPRSTitle;
	public TriageGroup triageGroup;
	private static String popupMessage;
	private static final String CPRS_TITLES="cprsTitles";
	private static final Log log = LogFactory.getLog(ManageGroupsForSMClinics.class);
	private SMWorkloadProperties workloadProperties;
	private static Long selectedTriageGroupId;
	
	


	public void prepare() throws Exception {
		WebApplicationContext ctx = WebApplicationContextUtils
		.getWebApplicationContext(ServletActionContext.getServletContext());
		workloadProperties = ((SMWorkloadProperties)ctx.getBean("smWorkloadProperties"));
	}

	public String start() {
		this.setSessionAttribute(SMCLINICS_VISN_ATTR_NAME, null);
		this.setSessionAttribute(SMCLINICS_FACILITY_ATTR_NAME, null);
		this.setSessionAttribute(SMCLINIC_TRIAGE_GROUP_SESSION_KEY, null);
		return SUCCESS;
	}

	public String chooseVisn()
	{
		if ( cancelButtonPressed() ) {
			return "CANCEL";
		}
		Long newVisnId = getParameterAsLong("visnId");
		Facility oldVisn = (Facility)getSessionAttribute(SMCLINICS_VISN_ATTR_NAME);
		return SUCCESS;
	}

	protected boolean cancelButtonPressed() {
		return ! StringUtils.isBlank(getParameter("[CANCEL BUTTON]"));
	}

	public Facility getVisn() {
		Facility visn = (Facility)getSessionAttribute(SMCLINICS_VISN_ATTR_NAME);
		if ( visn == null && ! getShowAdministeredVisnList() ) {
			visn = getAdministeredVisns().iterator().next();
			this.setSessionAttribute(SMCLINICS_VISN_ATTR_NAME, visn);
		}
		return visn;
	}

	public boolean getShowAdministeredVisnList() {
		boolean result = getAdministeredVisns().size() > 1;
		return result;
	}

	public Collection<Facility> getAdministeredFacilitiesInVisn() {
		if ( this.getVisnId() == null ) {
			return new TreeSet<Facility>();
		} else {
			return getAdministeredFacilitiesInVisn(getVisn());
		}
	}

	public Long getVisnId() {
		Facility visn = getVisn();
		if ( visn != null ) {
			return visn.getId();
		} else {
			return null;
		}
	}

	public Long getFacilityId() {
		Facility f = getFacility();
		if ( f != null ) {
			return f.getId();
		} else {
			return null;
		}
	}

	public Facility getFacility() {
		Facility f = (Facility)getSessionAttribute(SMCLINICS_FACILITY_ATTR_NAME);
		if ( f == null && ! this.getShowAdministeredFacilityList() ) {
			f = this.getAdministeredFacilitiesInVisn().iterator().next();
			this.setSessionAttribute(SMCLINICS_FACILITY_ATTR_NAME, f);
		}
		return f;
	}

	public boolean getShowAdministeredFacilityList() {
		boolean result = this.getAdministeredFacilitiesInVisn().size() > 1
			|| (getCurrentUser().isNational());
		return result;
	}

	public String chooseTriageFacility() {

		if ( cancelButtonPressed() ) {
			return "CANCEL";
		}
		Long newId = getParameterAsLong("newFacilityId");
		Long oldId = getFacilityId();
		if ( oldId != null && ! oldId.equals(newId) ) {
			//clearMembersAndRelations();
		}
		setFacilityId(newId);
		setSelectedTriageGroupId(null);
		return SUCCESS;
	}

	public void setFacilityId(Long facilityId) {
		setFacility(getFacilityService().getFacility(facilityId).getPayload());
	}

	public void setFacility(Facility facility) {
		this.setSessionAttribute(SMCLINICS_FACILITY_ATTR_NAME, facility);
	}


	public Collection<TriageGroup> getManagedTriageGroups() {
		setSessionAttribute(CPRS_TITLES,null);
		Locale.setDefault(Locale.ENGLISH);
		Facility f = getFacility();
		if ( f != null ) {
			Collection<TriageGroup> result = new TreeSet<TriageGroup>(TRIAGE_NAME_SORTER);
			result.addAll(getTriageGroupService().getTriageGroupsForStation(f.getStationNumber()).getCollection());
			return result;
		} else {
			addActionError("You must choose a facility");
			return new ArrayList<TriageGroup>();
		}
	}

	public static final Comparator<TriageGroup> TRIAGE_NAME_SORTER = new Comparator<TriageGroup>() {
		public int compare(TriageGroup a, TriageGroup b) {
			if(a == null || b == null) return 0;
			int result = (a.getName().toUpperCase()).compareTo(b.getName().toUpperCase());
			if ( result == 0 ) {
				result = a.getName().toUpperCase().compareTo(b.getName().toUpperCase());
			}
			return result;
		}
	};

	// Check the Existing relationsship to display in the popup
	public String checkRelations(){

		if(!StringUtils.isBlank(getParameter("triageGroupCancel"))){
			return "CANCEL";
		}

		Long triageGroupId = new Long(getParameter("groupId"));
		setSessionAttribute("triageGroupId",triageGroupId);

		setSelectedTriageGroupId(triageGroupId);
		if(StringUtils.isBlank(getParameter("update")) && StringUtils.isBlank(getParameter("cancel"))){
			SMClinicsTriageMap triageMap = getTriageGroupService().getActiveSMClinicByTriageGroup(triageGroupId);  // Find only the Active triage group with that name
			if(triageMap!=null){
				setSessionAttribute("POPUPMESSAGE","CLINICSFOUND");
				setDefaultSMClinic(triageMap.getSmClinicName());
				setDefaultSMClinicCPRSTitle(triageMap.getSmClinicNameCPRSTitle());
				return "DISPLAY_RELATIONS";
			}
		}
		else if(!StringUtils.isBlank(getParameter("update"))){
			return SUCCESS;
		}else if(!StringUtils.isBlank(getParameter("cancel"))){
			setSessionAttribute("POPUPMESSAGE",null);
			return "CHOOSE_TRIAGEGROUP";
		}
		return SUCCESS;
	}

	//User will choose the TriageGroup in the down to associate the SM Clinic Relationship
	public String chooseTriageGroup() {

		setSessionAttribute("smClinicsSearchResult",null);

		if ( cancelButtonPressed()) {
			return "CANCEL";
		}

		Long triageGroupId = (Long)getSessionAttribute("triageGroupId");
		ServiceResponse<TriageGroup> tgResp = getTriageGroupService().getSMClinicsForTriageGroup(triageGroupId);  // Find only the Active triage group with that name
		if ( tgResp.getMessages().hasErrorMessages() ) {
			for(Object o : tgResp.getMessages().getErrorMessages() ) {
				Message m = (Message)o;
				for(Object insert : m.getInserts() ) {
					this.addActionError(insert.toString());
				}
			}
			return "FAILURE";
		}

		TriageGroup tg = tgResp.getPayload();
		setTriageGroup(tg);
		setSessionAttribute(SMCLINIC_TRIAGE_GROUP_SESSION_KEY,tg);
		String station = tg.getVistaDiv();
		Facility f = getFacilityService().getFacilityByStationNumber(station).getPayload();
		setFacility(f);
		this.setVisnId(f.getVisnId());
		return SUCCESS;
	}


	public String goBack() {
		String step = getParameter("step");
		setSessionAttribute("POPUPMESSAGE",null);
		if ( ! StringUtils.isBlank(step) ) {
			return "STEP" + step;
		} else {
			return "STEP1";
		}
	}

	// Get the Existing SM Clinic Relations from the database and set into the variable
	public Collection<SMClinicsTriageMap> getClinicRelations() {
		setDefaultSMClinicCPRSTitle(SM_CPRS_DEFAULT_HEADER);
		Collection<SMClinicsTriageMap> relations = getRelations();
		storeSelectedTriageRealationship(relations);
		return relations;
	}

	private Collection<SMClinicsTriageMap> getRelations() {
		Locale.setDefault(Locale.ENGLISH);
		Collection<SMClinicsTriageMap> result = new HashSet<SMClinicsTriageMap>();

		for(SMClinicsTriageMap clinicTriageMap : getTriageGroup().getSmClinics()) {
			if ( clinicTriageMap.isActive() )
			{
				result.add(clinicTriageMap);
				setDefaultSMClinicCPRSTitle(clinicTriageMap.getSmClinicNameCPRSTitle());
			}
		}
		// Removed pending deletions
		for(SMClinicsTriageMap tr : getRelationsPendingDelete()) {
			Collection<SMClinicsTriageMap> removeFromResult = new HashSet<SMClinicsTriageMap>();
			for(SMClinicsTriageMap resultTr : result) {
				if (matches(tr, resultTr) ) {
					removeFromResult.add(resultTr);
				}
			}
			result.removeAll(removeFromResult);
		}
		// Add pending adds
		for(SMClinicsTriageMap tr : getRelationsPendingAdd() )
		{
				result.add(tr);
		}

		TreeSet sortTriageRelationSet = new TreeSet(SMCLINICS_COMPARATOR);
		sortTriageRelationSet.addAll(result);
		return sortTriageRelationSet;
	}


	public TreeSet<String> getAllSMClinicsCPRSTitle(){

		String documentClassName=null;
		String vistAPatchStatus=null;
		TreeSet<String> cprsTitles = new TreeSet<String>();

		if(getWorkloadProperties()!=null){
			documentClassName = getWorkloadProperties().getTiuDocumentClassName();
			vistAPatchStatus= getWorkloadProperties().getVistAPatchStatus();
		}

		if(vistAPatchStatus!=null && !vistAPatchStatus.trim().equals(""))
		{
			if(vistAPatchStatus.equalsIgnoreCase("Field")) // Field Level VistA Patch
			{
				if(isVistaPatchFacility())
				{  // If the current facility is field testings, then fetch all cprs titles from VistA
					cprsTitles = fetchTitles(cprsTitles,documentClassName);
				}
				else
				{
					cprsTitles = getTriageGroupService().getAllActiveSMClinicsCPRSTitles();
				}
			}else if(vistAPatchStatus.equalsIgnoreCase("National")){
					cprsTitles = fetchTitles(cprsTitles,documentClassName);
			}
		}
		else
		{
			log.info("%%% Loading CPRS Titles from SMS Database%%%");
			cprsTitles = getTriageGroupService().getAllActiveSMClinicsCPRSTitles();
		}

		return cprsTitles;
	}

	private TreeSet<String> fetchTitles(TreeSet<String> cprsTitles,String documentClassName){
		if(getSessionAttribute(CPRS_TITLES)!=null)
		{
			log.info("%%%%%Fetch CPRS Titles from Session%%%%");
			cprsTitles =  (TreeSet<String>)getSessionAttribute(CPRS_TITLES);
		}
		else{
			log.info("%%%%%%Fetch CPRS Titles from Ensemble API%%%%");
			if(documentClassName!=null && documentClassName.equals("")){
				log.info("Please define the CPRS document class in sm-workload.properties"+documentClassName);
			}
			setSessionAttribute(CPRS_TITLES,getCPRSTitleFromVistA(documentClassName)); // Fetch the CPRS titles from VistA
			cprsTitles =  (TreeSet<String>)getSessionAttribute(CPRS_TITLES);
		}
		return cprsTitles;
	}


	public String searchSMClinics() {

		if ( cancelButtonPressed() ) {
			clearPendingRelations();
			return "CANCEL";
		}

		String query = getParameter("searchSMClinicName");

		Map<String, String> searchResultMap = new HashMap<String, String>();

		if (query.trim().length() == 0) {
			 handleError(NO_SMCLINIC_NAME_ENTERED);
		} else {

			String vistAPatchStatus=null;
			if(getWorkloadProperties()!=null)
				vistAPatchStatus=  getWorkloadProperties().getVistAPatchStatus();
			log.info("&*&*&*&*Vista Patch Status&*&*&&*&*&"+vistAPatchStatus);
			if(vistAPatchStatus!=null && !vistAPatchStatus.trim().equals("")){
				if(vistAPatchStatus.equalsIgnoreCase("Field")) // Field Level VistA Patch
				{
					if(isVistaPatchFacility()) // If the current faciliy is field testing facility then do the clinics search with new API.
					{
						log.info("###SM Clinic Search Uses -> getClinicsByNameAndStopCode###Field");
						searchResultMap = getSMClinicsByNameAndStopCode(searchResultMap,query);
					}else
					{   log.info("###SM Clinic Search Uses -> getClinicsByName###Field");
						searchResultMap = getClinicsByName(searchResultMap,query);
					}
				}
				else if(vistAPatchStatus.equalsIgnoreCase("National"))  // National Level VistA Patch
				{
					log.info("###SM Clinic Search Uses -> getClinicsByNameAndStopCode###National");
					searchResultMap = getSMClinicsByNameAndStopCode(searchResultMap,query);
				}
			}
			else  // Regular Clinics Search
			{
				log.info("###SM Clinic Search Uses->getClinicsByName Query####");
				searchResultMap = getClinicsByName(searchResultMap,query);
			}
		}
		Map sortedSearchResultMap = UserUtils.sortedResultMap(searchResultMap);
        setSessionAttribute("smClinicsSearchResult",sortedSearchResultMap);
		return SUCCESS;
	}

	// Check whether the current selected Facility is field testing facility and return the boolean.
	private boolean isVistaPatchFacility()
	{
		boolean stationExists=false;
		String facilityId = getFacility().getStationNumber();
		String fieldList= getWorkloadProperties().getVistAPatchField();
		if(fieldList!=null && !fieldList.trim().equals(""))
		{
			String[] facilitiesList = fieldList.split( ",\\s*" );
			for(String stationNumber:facilitiesList){
		    	if(stationNumber.equals(getFacility().getStationNumber())){
		    		log.info("%%%Yes - Field Testing Facility%%%%"+stationNumber);
		    		stationExists = true;
		    		break;
		    	}
		    }
		}
		return stationExists;
	}


	private Map getClinicsByName(Map searchResultMap, String name){
		log.info("##################Existing API####################");
		CollectionServiceResponse<Clinic> response = this.getAdminService().searchClinics(getFacility().getStationNumber(), name);
		Collection<Clinic> searchResult = response.getCollection();
		if ( (searchResult == null || searchResult.isEmpty()) && !response.getMessages().hasErrorMessages() ) {
			addActionError("No clinics found matching query string: " + name);
		} else {
			handleErrorMessages(response.getMessages());
			for(Clinic c : searchResult) {
				searchResultMap.put(c.getIEN(), c.getName());
			}
		}
		return searchResultMap;
	}

	private Map getSMClinicsByNameAndStopCode(Map searchResultMap,String name){
		log.info("##################New API####################");
		String creditStopeCode= getWorkloadProperties().getCreditStopCode();
		log.info("@@@@@@@@@@@@CreditStopCode"+creditStopeCode);
		CollectionServiceResponse<SMClinic> response = this.getAdminService().searchSMClinicsByStopCode(getFacility().getStationNumber(), name,creditStopeCode);
		Collection<SMClinic> searchResult = response.getCollection();
		if ( (searchResult == null || searchResult.isEmpty()) && !response.getMessages().hasErrorMessages() ) {
			addActionError("No clinics found matching query string: " + name);
		} else {
			handleErrorMessages(response.getMessages());
			for(SMClinic c : searchResult) {
				searchResultMap.put(c.getIEN(), c.getName());
			}
		}
		return searchResultMap;
	}

	private TreeSet<String> getCPRSTitleFromVistA(String documentClassName){
		TreeSet<String> tiuCPRSTitleSet = new TreeSet();
		CollectionServiceResponse<SMNoteTitle> response = this.getAdminService().getCPRSTIUTitles(getFacility().getStationNumber(),documentClassName);
		Collection<SMNoteTitle> searchResult = response.getCollection();
		if(searchResult!=null || !searchResult.isEmpty()){
			for(SMNoteTitle title : searchResult) {
				tiuCPRSTitleSet.add(title.getTIUTitle());
			}
		}
		return tiuCPRSTitleSet;
	}

	public String updateTriageSMClinics(){
		if ( cancelButtonPressed() ) {
			clearPendingRelations();
			setSessionAttribute(SMCLINICS_VISN_ATTR_NAME,null);
			setSessionAttribute(SMCLINICS_FACILITY_ATTR_NAME,null);
			setSessionAttribute(SMCLINIC_TRIAGE_GROUP_SESSION_KEY,null);
			setSessionAttribute("selectedsmClinicsTriageRelationship",null);
			setSessionAttribute("smClinicsAdd",null);
			setSessionAttribute("smClinicsDelete",null);
			return "CANCEL";
		}

		if ( ! StringUtils.isBlank(this.getParameter("add")) ) {
			Map<String, String> searchResultMap = (Map)getSessionAttribute("smClinicsSearchResult");
			Map<String, String> smClinicsSelectedRelationship = (Map)getSessionAttribute("selectedsmClinicsTriageRelationship");
			for(String clinicIen : getParameterValueList("smClinicsToAdd")) {
				SMClinicsTriageMap smClinicsTriageMap = new SMClinicsTriageMap();
				smClinicsTriageMap.setSmClinicIen(clinicIen);
				smClinicsTriageMap.setSmClinicName(searchResultMap.get(clinicIen));
				manageTriageRelationPendingAdd(smClinicsTriageMap);
				smClinicsSelectedRelationship.put(clinicIen,smClinicsTriageMap.getSmClinicName());
			}

		}
	 else if ( ! StringUtils.isBlank(getParameter("remove")) )
	 {
		Map<String, String> selectedTriageRelationship = (Map)getSessionAttribute("selectedsmClinicsTriageRelationship");

		for(String clinicIen : getParameterValueList("smClinicsToRemove"))
		{
			SMClinicsTriageMap smClinicsTriageMap = new SMClinicsTriageMap();
			smClinicsTriageMap.setSmClinicIen(clinicIen);
			manageTriageRelationPendingDelete(smClinicsTriageMap);
			selectedTriageRelationship.remove(smClinicsTriageMap.getSmClinicIen());

		}

	 }
	 else if(!StringUtils.isBlank(getParameter("save")))
	 {
		 /*
		 if(getParameter("canSaveRelationship").equals("No")){
			 addActionError("No Clinic Selected. A Clinic must be selected before saving the relationship.");
			 return "SAVERELATIONSHIP_ERROR";
		 }else{
			 if(saveRelationship())
				 return "SAVERELATIONSHIP";
			 else
				 return "SAVERELATIONSHIP_ERROR";
		 }
		 */
		 // Jazz Story: Clinic association is not mandatory to save the relationship
		if(saveRelationship())
				 return "SAVERELATIONSHIP";
	    else
		 return "SAVERELATIONSHIP_ERROR";
	 }
		return "SMCLINICS";
	}

	private void manageTriageRelationPendingAdd(SMClinicsTriageMap smClinicsTriageMap) {
		Collection<SMClinicsTriageMap> toDelete = getRelationsPendingDelete();
		Collection<SMClinicsTriageMap> toAdd = getRelationsPendingAdd();
		manageTriageRelationChange(toAdd, toDelete, smClinicsTriageMap);
	}

	private void manageTriageRelationPendingDelete(SMClinicsTriageMap smClinicsTriageMap) {
		Collection<SMClinicsTriageMap> toDelete = getRelationsPendingDelete();
		Collection<SMClinicsTriageMap> toAdd = getRelationsPendingAdd();
		manageTriageRelationChange(toDelete, toAdd, smClinicsTriageMap);
	}


	private void manageTriageRelationChange(Collection<SMClinicsTriageMap> toAddColl, Collection<SMClinicsTriageMap> toDeleteColl, SMClinicsTriageMap tr) {
		// See if we can just pull it from the to delete collection
		SMClinicsTriageMap removeMe = null;
		for(SMClinicsTriageMap toDelete : toDeleteColl) {
			if ( matches(toDelete, tr) ) {
				removeMe = toDelete;
				break;
			}
		}
		if ( removeMe != null ) {
			toDeleteColl.remove(removeMe);
			return;
		}
		for(SMClinicsTriageMap added : toAddColl) {
			if ( matches(added, tr) ) {
				// Nothing to do
				added.setSmClinicName(tr.getSmClinicName());
				return;
			}
		}
		toAddColl.add(tr);
	}



	private void storeSelectedTriageRealationship(Collection<SMClinicsTriageMap> store){
		Map<String, String> selectedTriageRealationship = new HashMap<String, String>();
		for (Iterator iter = store.iterator(); iter.hasNext();) {
			SMClinicsTriageMap element = (SMClinicsTriageMap) iter.next();
			selectedTriageRealationship.put(element.getSmClinicIen(),element.getSmClinicName());

		}
		setSessionAttribute("selectedsmClinicsTriageRelationship",selectedTriageRealationship);

	}



	public boolean saveRelationship(){

		TriageGroup tg = getTriageGroup();

		for(SMClinicsTriageMap tr : getRelationsPendingDelete()) {
			for(SMClinicsTriageMap existing : getTriageGroup().getSmClinics()) {
				if (matches(tr, existing) ) {
					existing.setActive(false);
				}
			}
		}
		for(SMClinicsTriageMap clinicTriageMap : getRelationsPendingAdd()) {
			if(!getSelectedCPRSTitle().equals("-1"))
				clinicTriageMap.setSmClinicNameCPRSTitle(getSelectedCPRSTitle());
			boolean added = false;
			for(SMClinicsTriageMap existing : getTriageGroup().getSmClinics()) {
				if (matches(clinicTriageMap, existing) ) {
					existing.setActive(true);
					existing.setSmClinicName(clinicTriageMap.getSmClinicName());
					existing.setSmClinicIen(clinicTriageMap.getSmClinicIen());
					existing.setSmClinicNameCPRSTitle(clinicTriageMap.getSmClinicNameCPRSTitle());
					added = true;
					break;
				}
			}
			if ( ! added ) {
				clinicTriageMap.setActive(true);
				tg.addSMClinics(clinicTriageMap);
			}
		}
		clearPendingRelations();
		try{
			for(SMClinicsTriageMap clinicTriageMap : tg.getSmClinics()) {
				if(clinicTriageMap.isActive())
				{
					if(!getSelectedCPRSTitle().equals("-1"))
							clinicTriageMap.setSmClinicNameCPRSTitle(getSelectedCPRSTitle());
				}
			}
				ServiceResponse<TriageGroup> response  = getAdminService().saveTriageGroup(tg);
				if ( response.getMessages().hasErrorMessages() ) {
					handleError(ERROR_SAVING_GROUP);
					return false;

				}
		}catch(Exception e1){
			getLog().debug("Error while Saving Triage Group...."+e1);
			handleError(ERROR_SAVING_GROUP);

		}
		return true;

	}

	private void clearPendingRelations() {
		getRelationsPendingAdd().clear();
		getRelationsPendingDelete().clear();
		setSessionAttribute("POPUPMESSAGE",null);
		setSessionAttribute("triageGroupId",null);
		setSelectedTriageGroupId(null);
	}

	public static final Comparator<SMClinicsTriageMap> SMCLINICS_COMPARATOR = new Comparator<SMClinicsTriageMap>() {
		public int compare(SMClinicsTriageMap triageRelationObj1, SMClinicsTriageMap triageRelationObj2) {
			if(triageRelationObj1 == null || triageRelationObj2 == null) return 0;
			int result = triageRelationObj1.getSmClinicName().toUpperCase().compareTo(triageRelationObj2.getSmClinicName().toUpperCase());
			return result;
		}
	};

	@SuppressWarnings("unchecked")
	private Collection<SMClinicsTriageMap> getRelationsPendingAdd() {
		Collection<SMClinicsTriageMap> result = (Collection)getSessionAttribute("smClinicsAdd");
		if ( result == null ) {
			result = new ArrayList<SMClinicsTriageMap>();
			setSessionAttribute("smClinicsAdd", result);
		}
		return result;
	}


	private boolean matches(SMClinicsTriageMap tr1, SMClinicsTriageMap tr2)
	{
		return tr1.getSmClinicIen().equals(tr2.getSmClinicIen());
	}

	private Collection<SMClinicsTriageMap> getRelationsPendingDelete() {
		Collection<SMClinicsTriageMap> result = (Collection)getSessionAttribute("smClinicsDelete");
		if ( result == null ) {
			result = new ArrayList<SMClinicsTriageMap>();
			setSessionAttribute("smClinicsDelete", result);
		}
		return result;
	}

	public void setTriageGroup(TriageGroup group) {
		setSessionAttribute(SMCLINIC_TRIAGE_GROUP_SESSION_KEY, group);
	}

	public TriageGroup getTriageGroup(){

		return (TriageGroup)getSessionAttribute(SMCLINIC_TRIAGE_GROUP_SESSION_KEY);
	}
	public void setVisnId(Long visnId) {
		setSessionAttribute(SMCLINICS_VISN_ATTR_NAME, getFacilityService().getFacility(visnId).getPayload());
	}

	public static void setAllSMClinicsCPRSTitle(Collection<SMClinicsCPRSTitle> allSMClinicsCPRSTitle) {
		ManageGroupsForSMClinics.allSMClinicsCPRSTitle = allSMClinicsCPRSTitle;
	}

	public static String getDefaultSMClinicCPRSTitle() {
		return defaultSMClinicCPRSTitle;
	}

	public static void setDefaultSMClinicCPRSTitle(String defaultSMClinicCPRSTitle) {
		ManageGroupsForSMClinics.defaultSMClinicCPRSTitle = defaultSMClinicCPRSTitle;
	}

	public static String getSelectedCPRSTitle() {
		return selectedCPRSTitle;
	}

	public static void setSelectedCPRSTitle(String selectedCPRSTitle) {
		ManageGroupsForSMClinics.selectedCPRSTitle = selectedCPRSTitle;
	}

	public static String getPopupMessage() {
		return popupMessage;
	}

	public static void setPopupMessage(String popupMessage) {
		ManageGroupsForSMClinics.popupMessage = popupMessage;
	}

	public static String getDefaultSMClinic() {
		return defaultSMClinic;
	}

	public static void setDefaultSMClinic(String defaultSMClinic) {
		ManageGroupsForSMClinics.defaultSMClinic = defaultSMClinic;
	}

	public SMWorkloadProperties getWorkloadProperties() {
		return workloadProperties;
	}

	public void setWorkloadProperties(SMWorkloadProperties workloadProperties) {
		this.workloadProperties = workloadProperties;
	}

	public static Long getSelectedTriageGroupId() {
		return selectedTriageGroupId;
	}

	public static void setSelectedTriageGroupId(Long selectedTriageGroupId) {
		ManageGroupsForSMClinics.selectedTriageGroupId = selectedTriageGroupId;
	}
}
