package gov.va.med.mhv.sm.web.actions;

import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.sm.dao.FacilityDao;
import gov.va.med.mhv.sm.dao.TriageGroupDao;
import gov.va.med.mhv.sm.dao.UserDao;
import gov.va.med.mhv.sm.enumeration.RoleScopeEnum;
import gov.va.med.mhv.sm.model.Administrator;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.Facility;
import gov.va.med.mhv.sm.model.Patient;
import gov.va.med.mhv.sm.model.PatientBlockedFacility;
import gov.va.med.mhv.sm.model.TriageGroup;
import gov.va.med.mhv.sm.model.User;
import gov.va.med.mhv.sm.model.UserProfileVW;
import gov.va.med.mhv.sm.service.PatientBlockedService;
import gov.va.med.mhv.sm.service.UserManagementService;
import gov.va.med.mhv.sm.util.DateUtils;
import gov.va.med.mhv.sm.web.form.LookupParam;
import gov.va.med.mhv.sm.web.form.LookupVO;
import gov.va.med.mhv.sm.web.session.BlockPatientSession;
import gov.va.med.mhv.sm.web.util.ClinicianVO;
import gov.va.med.mhv.sm.model.report.SelectElement;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.Locale;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import com.opensymphony.xwork2.Preparable;

public class LookupAction extends BaseSMAdminAction implements Preparable {

	@SuppressWarnings("unused")
	private static final Log log = LogFactory.getLog(BlockPatientAccess.class);

	private Administrator admin;
	private UserManagementService userManagementService;
	private PatientBlockedService patientBlockedService;
	private TriageGroupDao triageGroupDao;
	private FacilityDao facilityDao;
	private UserDao userDao;

	private static final String HAS_SEARCH_RESULTS = "has.search.results";
	private static final String HAS_SELECTED_PATIENT = "has.selected.patient";

	
	// struts fields
	private BlockPatientSession blockSession;
	private String firstName;
	private String lastName;
	private String nssn;
	private String lookupSearchBtn;
	private String lookupClinicianSearchBtn;
	private String cancelBtn;
	private String selectPatientBtn;
	private String selectVisnBtn;
	private List associatedTriageTeamList;
	private Long selectedPatientId;
	private Long selectedClinicianId;
	private Patient selectedPatient;
	private Long facilityId;
	private String selectedVisnName;
	private Long visnId;
	private String selectAction;
	private String dateMonthOnly;
	private Collection patientsList;
	private String createPatientRptBtn;
	private String createClinicianRptBtn;
	private String runAnotherReportbtn;
	private Collection cliniciansList;
	private String stationNumber;


	protected RoleScopeEnum role = null;
	private List<SelectElement> filters = new ArrayList<SelectElement>();
	private String selectedFilter;
	
	@SuppressWarnings("unchecked")
	public void prepare() throws Exception {
		super.prepare();
		WebApplicationContext ctx = WebApplicationContextUtils
				.getWebApplicationContext(ServletActionContext.getServletContext());
		userManagementService = (UserManagementService) ctx.getBean("userManagementService");
		patientBlockedService = (PatientBlockedService) ctx.getBean("patientBlockedService");
		triageGroupDao = (TriageGroupDao) ctx.getBean("triageGroupDao");
		facilityDao = (FacilityDao)ctx.getBean("facilityDao");
		userDao = (UserDao)ctx.getBean("userDao");
		if(getSession().getAttribute("userType")==null){
			if(getRequest().getParameter("user").equals("0"))
			{
				setSessionAttribute("userType","PATIENT");
			}else {
				setSessionAttribute("userType","CLINICIAN");
			}	
		}
	
		admin = (Administrator)getSessionAttribute(CURRENT_USER);
		if ( admin.isNational() ) {
			role = RoleScopeEnum.NATIONAL;
		} else if ( ! admin.getVisns().isEmpty() ) {
			role = RoleScopeEnum.VISN;
		} else {
			role = RoleScopeEnum.FACILITY;
		}
		
		filters = setViewableFilters(role);

	}
	public void resetParameters() {
		removeSessionAttribute("selectedFilter");
	}
	
	public void removeSessionAttr(){
		removeSessionAttribute("facilities");
		removeSessionAttribute("selectedUsers");
		removeSessionAttribute("selectedVisn");
	}
	
	private String searchPatient(){
		Locale.setDefault(Locale.ENGLISH);
		if(getSelectedFilter().equals("-1")){
			addActionError("Select a Filter.");
			return "patient_success";
		}
		
		if(StringUtils.isBlank(lastName) && StringUtils.isBlank(nssn)){
			addActionError("Last Name or First Letter of Last Name + Last 4 of SSN are required.");
			return "patient_success";
		}
	  
		
		
		String tempArray[] = StringUtils.split(getSelectedFilter(),"|");
		
		String facilityArray[]  = StringUtils.split(tempArray[0],":");
		String visnArray[] = StringUtils.split(tempArray[1],":");
		
		Facility facility = facilityDao.findById(new Long(facilityArray[1]));
		
		Facility visn = facilityDao.findById(new Long(visnArray[1]));
		
		if(firstName !=null) firstName = firstName.trim();
		if(lastName !=null) lastName = lastName.trim();
		if(nssn !=null) nssn = nssn.trim();
		
		CollectionServiceResponse<Patient> response =
				userManagementService.searchForPatients(firstName, lastName, nssn, facility.getStationNumber());
		
		Collection<Patient> collectionPatient = new TreeSet<Patient>(PATIENT_BY_NAME_COMPARATOR); // fix for CQ# 5163
		collectionPatient.addAll(response.getCollection());

		LookupParam lookupParam = new LookupParam();
		lookupParam.setFirstName(firstName);
		lookupParam.setLastName(lastName);
		lookupParam.setNssn(nssn);
		lookupParam.setSelectedFilter(getSelectedFilter());
		setSessionAttribute("lookupParameters",lookupParam);
		
		setPatientsList(collectionPatient);
		if(collectionPatient.size() == 0){
			addActionError("No Results Returned.");
			setAttribute(HAS_SEARCH_RESULTS, Boolean.FALSE);
			return "patient_success";
		}
		setSessionAttribute("facilityName",facility.getName());
		setSessionAttribute("visnName",visn.getName());		
		setAttribute(HAS_SEARCH_RESULTS, Boolean.TRUE);

		return "patient_success";
	}

	private String searchClinician(){
		Locale.setDefault(Locale.ENGLISH);
		if(getSelectedFilter().equals("-1")){
			addActionError("Select a Filter.");
			return "staff_success";
		}
		
		if(StringUtils.isBlank(lastName)){
			addActionError("Last Name is required.");
			return "staff_success";
		}
	  
		String tempArray[] = StringUtils.split(getSelectedFilter(),"|");
		
		String facilityArray[]  = StringUtils.split(tempArray[0],":");
		String visnArray[] = StringUtils.split(tempArray[1],":");
		
		Facility facility = facilityDao.findById(new Long(facilityArray[1]));
		
		Facility visn = facilityDao.findById(new Long(visnArray[1]));
		
		if(firstName !=null) firstName = firstName.trim();
		if(lastName !=null) lastName = lastName.trim();
		
		CollectionServiceResponse<Clinician> response = userManagementService.searchForClinicians(firstName,lastName,facility.getStationNumber());
		
		Collection<Clinician> collectionClinician = new TreeSet<Clinician>(User.USER_BY_NAME_SORTER); // fix for CQ# 5163
		collectionClinician.addAll(response.getCollection());
		
		LookupParam lookupParam = new LookupParam();
		lookupParam.setFirstName(firstName);
		lookupParam.setLastName(lastName);
		lookupParam.setSelectedFilter(getSelectedFilter());
		setSessionAttribute("lookupParameters",lookupParam);
		setCliniciansList(collectionClinician);
		ArrayList cliniciansWithProviderList = new ArrayList();
		for(Clinician clin:collectionClinician){
			ClinicianVO clinicianVO = new ClinicianVO();
			clinicianVO.setClinicianId(clin.getId());
			String userType = "";
			if(clin.getClinicalUserType() != null){ 
				userType = clin.getClinicalUserType().getName();
			}
			clinicianVO.setClincianFullName(clin.getLastName()+", "+clin.getFirstName()+" ("+userType+")");
			cliniciansWithProviderList.add(clinicianVO);
		}
		setSessionAttribute("cliniciansWithProviderList",cliniciansWithProviderList);

	    
	    if(collectionClinician.size() == 0){
			addActionError("No Results Returned.");
			setAttribute(HAS_SEARCH_RESULTS, Boolean.FALSE);
			return "staff_success";
		}
		
		setSessionAttribute("facilityName",facility.getName());
		setSessionAttribute("visnName",visn.getName());		
		setAttribute(HAS_SEARCH_RESULTS, Boolean.TRUE);
		
		return "staff_success";
	}

	

	public String submit(){
		if(!StringUtils.isBlank(cancelBtn)){   
			return "cancel";
		}

		if(!StringUtils.isBlank(lookupSearchBtn)){
			return searchPatient();
		}
		
		if(!StringUtils.isBlank(lookupClinicianSearchBtn)){
			return searchClinician();
		}

		if(!StringUtils.isBlank(createPatientRptBtn)){
			return runPatientReport();
		}
		if(!StringUtils.isBlank(createClinicianRptBtn)){
			return runClinicianReport();
		}
		
		if(!StringUtils.isBlank(runAnotherReportbtn)){
			return runAnotherReport();
		}
		
		

		return patientOrStaff("success");
	}

	private String patientOrStaff(String keyword) {
		if("CLINICIAN".equals(getSessionAttribute("userType"))) {
			return "staff_"+keyword;
		} else if("PATIENT".equals(getSessionAttribute("userType"))) {
			return "patient_"+keyword;
		} else {
			return "error";
		}
	}
	
	public String runPatientReport(){
	
		if(selectedPatientId == -1){
			addActionError("Please select a patient.");
			setAttribute(HAS_SEARCH_RESULTS, Boolean.TRUE);
			return "patient_success";
		}
		
		Patient patient = (Patient)userDao.findById(selectedPatientId);
		setSelectedPatient(patient);
		String facilityName = (String)getSessionAttribute("facilityName");
		Facility facility = facilityDao.getFacilityByName(facilityName);

		List<TriageGroup> triageGroupList = (List)triageGroupDao.getTriageGroupsForPatientByStation(patient,facility.getStationNumber());
		List patientBlockedList = new ArrayList();
		
		LookupVO lookupObj = new LookupVO();
		
		CollectionServiceResponse<PatientBlockedFacility> patientBlockedResponse = patientBlockedService.getBlockedFacilityPatientsByPatientIdAndStation(patient.getId(), new Long(facility.getStationNumber()));
		Collection<PatientBlockedFacility> patientBlockedFacilityList = patientBlockedResponse.getCollection();
		if(patientBlockedFacilityList!=null && patientBlockedFacilityList.size()!=0){
			lookupObj.setPatientBlockedFacility(true);
		}else{
			List<Object[]> list = patientBlockedService.getPatientBlockedTriageGroupsByPatientIdAndStation(patient.getId(),new Long(facility.getStationNumber()));
			for(Object[] obj:list)
			{
				Long tgId = ((BigDecimal)obj[2]).longValue();
				patientBlockedList.add(tgId);
			}	
		}
		UserProfileVW userProfileVw = userManagementService.getUserProfileByUserName(patient.getUsername());
		if(userProfileVw!=null){
			lookupObj.setPatientMHVLastLogin(DateUtils.formatDate(userProfileVw.getCurrentLogin(),DateUtils.ENGLISH_DD_MMM_YYYY_FORMAT));
			lookupObj.setPatientSMLastLogin(DateUtils.formatDate(patient.getCurrentLogin(),DateUtils.ENGLISH_DD_MMM_YYYY_FORMAT));
		}
		lookupObj.setTriageTeamList(triageGroupList);
		lookupObj.setFirstName(patient.getFirstName());
		lookupObj.setLastName(patient.getLastName());
		lookupObj.setNssn(patient.getNssn());
		lookupObj.setUserType("0");
		lookupObj.setDateMonthOnly(DateUtils.formatDate(selectedPatient.getDob(),"MM/dd"));
		lookupObj.setFacilityName(facilityName);
		lookupObj.setVisnName((String)getSessionAttribute("visnName"));
		lookupObj.setPatientBlockedTeamList(patientBlockedList);
		
		StringBuffer sb = new StringBuffer();
		LookupParam lookupParam = (LookupParam)getSession().getAttribute("lookupParameters");
		sb.append("This report was generated on "+lookupObj.getFormattedRunDate()+"\n");
		sb.append("Report Parameters:");
		sb.append(" Type: " + "Search by Patient");
		sb.append("\n");
		sb.append("Last Name: "+lookupObj.getLastName()+"  First Name: "+lookupObj.getFirstName()+"  Nssn: "+lookupObj.getNssn()+"  Month and Day of Birth:"+lookupObj.getDateMonthOnly()+"\n\n");
		sb.append("Visn"+","+"Facility"+","+"Team Name"+","+"Status"+"\n\n");
		for(TriageGroup tg:triageGroupList){
			sb.append((String)getSessionAttribute("visnName"));
			sb.append(",");
			sb.append((String)getSessionAttribute("facilityName"));
			sb.append(",");
			sb.append("\""+tg.getName()+"\"");
			if(lookupObj.isPatientBlockedFacility()){
				sb.append(",");
				sb.append("Blocked");
			}else if(patientBlockedList.contains(tg.getId())){
					sb.append(",");
					sb.append("Blocked");
			}
			sb.append("\n");
		}
		lookupObj.setCsv(sb.toString());
		setSessionAttribute("lookupResults",lookupObj);		
		
		return patientOrStaff("runReport");
	}

	public String runClinicianReport(){
		
		if(selectedClinicianId == -1){
			addActionError("Please select a Clinician.");
			setAttribute(HAS_SEARCH_RESULTS, Boolean.TRUE);
			return "staff_success";
		}
		
		Clinician clinician = (Clinician)userDao.findById(selectedClinicianId);

		List<TriageGroup> triageGroupList = (List)triageGroupDao.getTriageGroupsForClinician(clinician);
		
		LookupVO lookupObj = new LookupVO();
		lookupObj.setTriageTeamList(triageGroupList);
		lookupObj.setFirstName(clinician.getFirstName());
		lookupObj.setLastName(clinician.getLastName());
		if(clinician.getClinicalUserType()!=null)
		lookupObj.setUserType(clinician.getClinicalUserType().getName());
		lookupObj.setFacilityName((String)getSessionAttribute("facilityName"));
		lookupObj.setVisnName((String)getSessionAttribute("visnName"));
		
		StringBuffer sb = new StringBuffer();
		LookupParam lookupParam = (LookupParam)getSession().getAttribute("lookupParameters");
		sb.append("This report was generated on "+lookupObj.getFormattedRunDate()+"\n");
		sb.append("Report Parameters:");
		sb.append(" Type: " + "Search by Staff");
		sb.append("\n");
		sb.append("Last Name: "+lookupObj.getLastName()+"  First Name: "+lookupObj.getFirstName()+" Clinical User Type:"+lookupObj.getUserType()+"\n\n");
		sb.append("Visn"+","+"Facility"+","+"Team Name\n\n");
		for(TriageGroup tg:triageGroupList){
			sb.append((String)getSessionAttribute("visnName"));
			sb.append(",");
			sb.append((String)getSessionAttribute("facilityName"));
			sb.append(",");
			sb.append("\""+tg.getName()+"\"");
			sb.append("\n");
		}
		lookupObj.setCsv(sb.toString());
		setSessionAttribute("lookupResults",lookupObj);		
		
		return patientOrStaff("runReport");
	}

	public String runAnotherReport(){

		LookupParam lookupParam = (LookupParam)getSession().getAttribute("lookupParameters");
		setFirstName(lookupParam.getFirstName());
		setLastName(lookupParam.getLastName());
		setNssn(lookupParam.getNssn());
		setSelectedFilter(lookupParam.getSelectedFilter());
		return patientOrStaff("runAnotherReport");
	}
	
	
	/*
	 * Comparator to Compare the Patient object for the Sorting order implementation (CQ# 5163)
	 */
	public static final Comparator<Patient> PATIENT_BY_NAME_COMPARATOR = new Comparator<Patient>() {
		public int compare(Patient a, Patient b) {
			if(a == null || b == null) return 0;
			int result = (a.getLastName().toUpperCase()).compareTo(b.getLastName().toUpperCase());
			if ( result == 0 ) {
				result = a.getFirstName().toUpperCase().compareTo(b.getFirstName().toUpperCase());
			}
			return result;
		}
	};

	
	private List<SelectElement> setViewableFilters( RoleScopeEnum role ) {
		List<SelectElement> tmpFilters = new ArrayList<SelectElement>();
		tmpFilters.add(new SelectElement("-- Select Facility or VISN --", "-1"));
		if( role.equals(RoleScopeEnum.NATIONAL)) {
			Collection<Facility> visns = getAdministeredVisns();
			for( Facility v: visns ) {
				Collection<Facility> facilities = getAdministeredFacilitiesInVisn(v);
				for( Facility f: facilities ) {
					tmpFilters.add( new SelectElement(String.valueOf(v.getName()) + ":" + f.getName(), "F:"+String.valueOf(f.getId()) +"|V:" + v.getId()));
				}
			}
		} else if(role.equals(RoleScopeEnum.VISN)) {
			Collection<Facility> visns = getAdministeredVisns();
			for( Facility v: visns ) {
				Collection<Facility> facilities = getAdministeredFacilitiesInVisn(v);
				for( Facility f: facilities ) {
					tmpFilters.add( new SelectElement("VISN " + f.getVisn() + ":" + f.getName(), "F:"+String.valueOf(f.getId()) +"|V:" + v.getId()));
				}
			}
		} else if(role.equals(RoleScopeEnum.FACILITY)) {
			Collection<Facility> visns = getAdministeredVisns();
			for( Facility v: visns ) {
				Collection<Facility> facilities = getAdministeredFacilitiesInVisn(v);
				for( Facility f: facilities ) {
					tmpFilters.add( new SelectElement("VISN " + f.getVisn() + ":" + f.getName(), "F:"+String.valueOf(f.getId()) +"|V:" + v.getId()));
				}
					
			}
			
		}
		
		return tmpFilters;
	}
	
	public List<SelectElement> getViewableFilters() {
		return filters;
	}


	public String getFirstName() {
		return firstName;
	}
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}
	public String getLastName() {
		return lastName;
	}
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}
	public String getNssn() {
		return nssn;
	}
	public void setNssn(String nssn) {
		this.nssn = nssn;
	}
	public String getLookupSearchBtn() {
		return lookupSearchBtn;
	}
	public void setLookupSearchBtn(String lookupSearchBtn) {
		this.lookupSearchBtn = lookupSearchBtn;
	}
	public String getCancelBtn() {
		return cancelBtn;
	}
	public void setCancelBtn(String cancelBtn) {
		this.cancelBtn = cancelBtn;
	}
	public Long getSelectedPatientId() {
		return selectedPatientId;
	}
	public void setSelectedPatientId(Long selectedPatientId) {
		this.selectedPatientId = selectedPatientId;
	}
	public String getSelectPatientBtn() {
		return selectPatientBtn;
	}
	public void setSelectPatientBtn(String selectPatientBtn) {
		this.selectPatientBtn = selectPatientBtn;
	}
	public Patient getSelectedPatient() {
		return selectedPatient;
	}
	public void setSelectedPatient(Patient selectedPatient) {
		this.selectedPatient = selectedPatient;
	}

	public Long getFacilityId() {
		return facilityId;
	}
	public void setFacilityId(Long facilityId) {
		this.facilityId = facilityId;
	}
	public Long getVisnId() {
		return visnId;
	}
	public void setVisnId(Long visnId) {
		this.visnId = visnId;
	}

	public BlockPatientSession getBlockSession() {
		return blockSession;
	}

	public void setBlockSession(BlockPatientSession blockSession) {
		this.blockSession = blockSession;
	}
	public String getSelectVisnBtn() {
		return selectVisnBtn;
	}
	public void setSelectVisnBtn(String selectVisnBtn) {
		this.selectVisnBtn = selectVisnBtn;
	}

	public String getSelectAction() {
		return selectAction;
	}

	public void setSelectAction(String selectAction) {
		this.selectAction = selectAction;
	}

	public String getSelectedVisnName() {
		return selectedVisnName;
	}

	public void setSelectedVisnName(String selectedVisnName) {
		this.selectedVisnName = selectedVisnName;
	}

	public String getDateMonthOnly() {
		return dateMonthOnly;
	}

	public void setDateMonthOnly(String dateMonthOnly) {
		this.dateMonthOnly = dateMonthOnly;
	}

	public String getSelectedFilter() {
		return selectedFilter;
	}

	public void setSelectedFilter(String selectedFilter) {
		this.selectedFilter = selectedFilter;
	}
	public Collection getPatientsList() {
		return patientsList;
	}
	public void setPatientsList(Collection patientsList) {
		this.patientsList = patientsList;
	}
	
	public List getAssociatedTriageTeamList() {
		return associatedTriageTeamList;
	}
	public void setAssociatedTriageTeamList(List associatedTriageTeamList) {
		this.associatedTriageTeamList = associatedTriageTeamList;
	}
	public String getLookupClinicianSearchBtn() {
		return lookupClinicianSearchBtn;
	}
	public void setLookupClinicianSearchBtn(String lookupClinicianSearchBtn) {
		this.lookupClinicianSearchBtn = lookupClinicianSearchBtn;
	}
	public Collection getCliniciansList() {
		return cliniciansList;
	}
	public void setCliniciansList(Collection cliniciansList) {
		this.cliniciansList = cliniciansList;
	}
	public Long getSelectedClinicianId() {
		return selectedClinicianId;
	}
	public void setSelectedClinicianId(Long selectedClinicianId) {
		this.selectedClinicianId = selectedClinicianId;
	}
	public String getCreateClinicianRptBtn() {
		return createClinicianRptBtn;
	}
	public void setCreateClinicianRptBtn(String createClinicianRptBtn) {
		this.createClinicianRptBtn = createClinicianRptBtn;
	}
	public String getCreatePatientRptBtn() {
		return createPatientRptBtn;
	}
	public void setCreatePatientRptBtn(String createPatientRptBtn) {
		this.createPatientRptBtn = createPatientRptBtn;
	}
	public String getRunAnotherReportbtn() {
		return runAnotherReportbtn;
	}
	public void setRunAnotherReportbtn(String runAnotherReportbtn) {
		this.runAnotherReportbtn = runAnotherReportbtn;
	}
}
