package gov.va.med.mhv.sm.web.actions;

import gov.va.med.mhv.foundation.util.ConfigurationManager;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.opensymphony.xwork2.Preparable;

public class Help extends BaseSMAdminAction implements Preparable {

	
	private static final long serialVersionUID = -7572414237396219248L;
	
	private static final Log log = LogFactory.getLog(Help.class);
	public static final String HELP_CONTENT_ATTRIBUTE_NAME = "HELP_CONTENT";
	private static String HELP_PREFIX = null;
	private static final String PROP_FILE_NAME = File.separator + "sm-web.properties";
	private static final String HELP_PREFIX_KEY = "sm.web.help.url.prefix";
	
	public void prepare() throws Exception {
		super.prepare();
		if ( HELP_PREFIX == null ) {
			Properties props = ConfigurationManager.getConfiguration(PROP_FILE_NAME);
			if ( props == null ) {
				log.error("Could not load properties file: " + PROP_FILE_NAME);
			} else {
				HELP_PREFIX = props.getProperty(HELP_PREFIX_KEY);
				if ( HELP_PREFIX == null ) {
					log.error("Could not find property " + HELP_PREFIX_KEY + " in " + PROP_FILE_NAME);
				}
			}
		}
	}
	
	public String execute() {
		String helpPage = getParameter("content");
		String content = null;
		try {
			content = getContent(helpPage);
		} catch (Exception e) {
			e.printStackTrace();
			content = "Unable to retrieve help content for " 
				+ helpPage
				+ " - " + e.getMessage();
		}
		getServletRequest().setAttribute(HELP_CONTENT_ATTRIBUTE_NAME, content);
		return SUCCESS;
	}
	
	public String getContent(String pagetoDisplay) throws IOException {
		if ( HELP_PREFIX == null ) return "SM Help Configuration error";
		StringBuilder buffer = null;
		InputStream in = null;
		try {
			//read and download the page text
			URL url = new URL(getHelpUrlPrefix() + pagetoDisplay);
			in = url.openStream();    	
			byte[] data = new byte[1024];
			buffer = new StringBuilder();
			for(int length = in.read(data); length != -1; length = in.read(data) ) {
				buffer.append(new String(data, 0, length));
			}
		}catch (Exception e) {
			log.error("Requested help file "+pagetoDisplay+ " could not be processed.", e);
			buffer = new StringBuilder("Unable to retrieve content for " + pagetoDisplay);
		} finally {           
			if (in != null) in.close();       	
		}
		return (buffer != null) ? buffer.toString() : null;
	}

	protected static String getHelpUrlPrefix() throws IOException {
		return HELP_PREFIX;
	}

}

