package gov.va.med.mhv.sm.web.actions;

import org.apache.commons.lang.StringUtils;

import gov.va.med.mhv.sm.model.TriageGroup;


public class CreateTriageGroup extends AbstractTriageGroupAction{
	
	private static final String CREATE_TRIAGE_GROUP_STEP = "CREATE_TG_STEP";
	private static final String GROUP_NAME_PARAMETER = "groupName";
	private static final String ADMINISTERED_VISNS = "administeredVisns";
	private static final String STEP1 = "STEP1";
	private static final String STEP2 = "STEP2";
	private static final String FAILURE_RESULT = "FAILURE";
	
	protected static final String CHOOSE_VISN = "CHOOSE_VISN";
	protected static final String CHOOSE_FACILITY = "CHOOSE_FACILITY";

	@Override
	protected String getFunction() {
		return AbstractTriageGroupAction.CREATE_FUNCTION;
	}
	
	public String start() {
		clearTriageGroup();
		//Set step step1a.  (Set Group Name)
		setSessionAttribute(CREATE_TRIAGE_GROUP_STEP, STEP1);
		
		return SUCCESS;
	}
	
	public String processStep1() {
		if ( cancelButtonPressed() ) {
			return "CANCEL";
		}
		String name = this.getParameter(GROUP_NAME_PARAMETER); 
		name = name.trim();
		if ( ! validTriageGroupName(name) ) return FAILURE_RESULT;
		TriageGroup group = getTriageGroup();
		group.setName(name);
		if ( getSessionAttribute(ADMINISTERED_VISNS) == null ) {
			setSessionAttribute(ADMINISTERED_VISNS, getAdministeredVisns());
		}
		
		String step = (String)getSessionAttribute(CREATE_TRIAGE_GROUP_STEP);
		if ( getVisnId() == null || STEP1.equals(step) ) {
			return CHOOSE_VISN;
		} else if ( getFacilityId() == null || STEP1.equals(step) ) {
			return CHOOSE_FACILITY;
		} else {
			setFacilityId(getFacilityId());
			setSessionAttribute(CREATE_TRIAGE_GROUP_STEP,STEP2);
			return SUCCESS;  // Choose staff page
		}
	}
	
	public String showDefineRelationships() {
		if ( cancelButtonPressed() ) {
			return "CANCEL";
		}
		if ( saveTriageGroup() ) {
			return SUCCESS;
		} else {
			return "NO_PROVIDER";
		}
	}

}
