package gov.va.med.mhv.sm.web.actions;

import gov.va.med.mhv.foundation.util.ConfigurationManager;
import gov.va.med.mhv.sm.dao.UserDao;
import gov.va.med.mhv.sm.model.ContactUs;
import gov.va.med.mhv.sm.service.ContactUsService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import com.opensymphony.xwork2.ModelDriven;

public class ContactUsAction extends BaseSMAdminAction implements ModelDriven {

	private static final long serialVersionUID = -3336711383592471493L;
	private ContactUsService contactUsService = null;
	private ContactUs contactUs = new ContactUs();
	private UserDao userDao = null;
	private static final List<String> STANDARD_SUBJECTS;
	private static final String OTHER = "Other";

	static {
		List<String> subjects = new ArrayList<String>();
		subjects.add("Application \"How Do I?\"");
		subjects.add("Compliments");
		subjects.add("Criticisms");
		subjects.add("Error Message Displayed");
		subjects.add("Future Functionality");
		subjects.add("Login Problems");
		subjects.add("Questions");
		subjects.add(OTHER);
		STANDARD_SUBJECTS = Collections.unmodifiableList(subjects);
	}

	private static final Log log = LogFactory.getLog(ContactUsAction.class);

	public String contactUsInput() throws Exception {
		if ( getCurrentUser() != null ) {
			log.info("Entering Properties class");
			//String irisServerAddress = getIrisEncodedURL();
			//Referencing just the not logged in URL.
			String irisServerAddress = getIrisNotLoggedInURL();
	    	//getServletRequest().getSession().setAttribute("irisServerAddress", irisServerAddress);
	    	contactUs.setIrisServerAddress(irisServerAddress);
	    	log.info("***Iris Server Address*** " + irisServerAddress);
		}
		return SUCCESS;
	}

    public String getIrisNotLoggedInURL() {
    	return getContactUsRedirectAddress();
    }

    public String getContactUsRedirectAddress() {
    	Properties properties = ConfigurationManager.getConfiguration("/sm-iris.properties");
    	return properties.getProperty("contactus.irisServerAddressSM");
    }

	public void prepare() throws Exception {
		super.prepare();
		WebApplicationContext ctx = WebApplicationContextUtils
				.getWebApplicationContext(ServletActionContext
						.getServletContext());
		this.setContactUsService((ContactUsService)ctx.getBean("contactUsService"));
		setUserDao((UserDao)ctx.getBean("userDao"));
	}

	public ContactUsService getContactUsService() {
		return contactUsService;
	}

	public void setContactUsService(ContactUsService contactUsService) {
		this.contactUsService = contactUsService;
	}

	public ContactUs getContactUs() {
		return contactUs;
	}

	public void setContactUs(ContactUs contactUs) {
		this.contactUs = contactUs;
	}

	public Object getModel() {
		return getContactUs();
	}

	public List<String> getStandardSubjects() {
		return STANDARD_SUBJECTS;
	}

	public UserDao getUserDao() {
		return userDao;
	}

	public void setUserDao(UserDao userDao) {
		this.userDao = userDao;
	}
}
