package gov.va.med.mhv.sm.web.actions;

import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.model.Administrator;
import gov.va.med.mhv.sm.model.Credentials;
import gov.va.med.mhv.sm.model.MhvAuthenticationSubject;
import gov.va.med.mhv.sm.service.AuthenticationService;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AdministratorAuthentication extends BaseSMAdminAction {
	
	private static final long serialVersionUID = 1595905245111660531L;
	
	private static final Log LOG = LogFactory.getLog(
		AdministratorAuthentication.class);

	private AuthenticationService authenticationService = null;
	private MhvAuthenticationSubject subject = new MhvAuthenticationSubject();
	private Credentials credentials = null;
	
	public void prepare() throws Exception {
		super.prepare();
		authenticationService = (AuthenticationService) getBean(
			"authenticationService");
	}
	
	public Log getLog() {
		return LOG;
	}

	public String login() {
		ServiceResponse<Administrator> response = (credentials != null)
		? authenticationService.authenticateAdministrator(credentials)
		: authenticationService.authenticateAdministrator(subject); 
		
		if (hasError(response)) {
			return loginFailed(getErrorText(response) + " for " + 
				MhvAuthenticationSubject.describe(subject));
		}
		Administrator administrator = response.getPayload();
		if (administrator == null) {
			return loginFailed("No patient found for " + 
				MhvAuthenticationSubject.describe(subject));
		}
		
		setSessionAttribute(CURRENT_USER, administrator);
		return SUCCESS;
	}
	
	public void setUserId(String userId) {
		// Note the difference between userid (used for test methods)
		// and userId (used for patient login from MHV)
		subject.setUserName(userId);
	}

	public void setFirstName(String firstName) {
		subject.setFirstName(firstName);
	}
	public void setLastName(String lastName) {
		subject.setLastName(lastName);
	}
	public void setSource(String source) {
		subject.setSource(source);
	}
	public void setIcn(String icn) {
		subject.setIcn(icn);
	}
	public void setSsn(String ssn) {
		subject.setSsn(ssn);
	}
	public void setNational(String national) {
		subject.setNational(Boolean.parseBoolean(national));
	}
	public void setChecksum(String checksum) {
		subject.setChecksum(checksum);
	}
	public void setTimestamp(String timestamp) {
		try {
			subject.setTimestamp(Long.parseLong(timestamp));
		} catch (NumberFormatException e) {
			LOG.error("Failed to parse val. The input is required to be an integer value", e);
			subject.setTimestamp(null);
		}
	}
	public void setVisn(String[] visn) {
		subject.setVisns(visn);
	}
	public void setStation(String[] station) {
		subject.setFacilities(station);
	}

	public void setKey(String key) {
		credentials = new Credentials();
		credentials.setKey(key);
	}

	private String loginFailed() {
		invalidateSession();
		return "LOGINFAILED";
	}
	private String loginFailed(String logMessage) {
		return loginFailed(logMessage, null);
	}
	private String loginFailed(String logMessage, String userMessage) {
		if (StringUtils.isBlank(userMessage)) {
			userMessage = "Login attempt failed, due to invalid credentials.";
		}
		addActionError(userMessage);
		if (!StringUtils.isBlank(logMessage)) {
			LOG.error("login failed, because " + logMessage);
		} else {
			LOG.debug("login failed");
		}
		return loginFailed();
	}

	private void invalidateSession() {
		if (getRequest() != null) {
			// The user successfully authenticated against the container,
			// but the credentials provided by the user conflicted with 
			// the original request. 
			// Therefore, the session must invalidated, such that the user 
			// will be forced to re-authenticate and can provide other, 
			// correct credentials.
			getSession().invalidate();
			// When upon failure, typically the browser should be redirected 
			// to the original. In that case the session is the only way in  
			// which to pass error information, such that it can be shown on 
			// the authentication form.
			getSession().setAttribute(SESSION_ATTRIBUTE_LOGIN_ERRORS, 
				getActionErrors());
		}
	}


}
