var hideLink = '<a class="helpLink" href="#" onClick="javascript:hideHelpText()">Hide</a>';
var wildCardHelp = " For wildcard search us the % symbol, i.e.: JON% or %SON or %EVE%";
var dtFormat = "<br/>Date format:  DD/MM/YYYY, please use a 4 digit year."
var helpTextMap = {};
/* fnodRecordFragment.xhtml items */
helpTextMap['pdfPrint'] = {header: "Display Printable PDF", helpText: "This will display a PDF document which will contain all the form data.", size: "0"};
helpTextMap['displayCaseData'] = {header: "Display Case Data", helpText: "This will display formatted case data in a new popup window.", size: "0"};
helpTextMap['fnodRecUser'] = {header: "User Info", helpText: "The current user of the system.", size: "0"};
helpTextMap['fnodRecCaseCreateDt'] = {header: "Create Date", helpText: "The date and time the record was created", size: "0"};
helpTextMap['fnodRecCaseId'] = {header: "Case Id", helpText: "The Case Id for this FNOD Record", size: "0"};
helpTextMap['fnodRecCaseLockedDt'] = {header: "Case Lock Date", helpText: "If the FNOD Record is locked, this field displays when it was locked", size: "0"};
helpTextMap['fnodRecCaseStatus'] = {header: "Case Status", helpText: "The status of the case in the FNOD system.", size: "0"};
helpTextMap['fnodRecFnodDt'] = {header: "FNOD Create Date", helpText: "If the First Notice of Death (FNOD) has been created, this is the date it was created.", size: "0"};
helpTextMap['fnodRecVetFirstNm'] = {header: "Veteran First Name", helpText: "The first name of the veteran.", size: "15"};
helpTextMap['fnodRecVetMidNm'] = {header: "Veteran Middle Name", helpText: "The middle name of the veteran (optional).", size: "15"};
helpTextMap['fnodRecVetLastNm'] = {header: "Veteran Last Name", helpText: "The last name of the veteran.", size: "25"};
helpTextMap['fnodRecVetSuffixNm'] = {header: "Veteran Suffix Name", helpText: "The suffix attached to the last name of the veteran (optional).", size: "3"};
helpTextMap['fnodRecVetBirthDt'] = {header: "Veteran Birth Date", helpText: "Birth Date" + dtFormat, size: "0"};
helpTextMap['fnodRecVetDeathDt'] = {header: "Veteran Death Date", helpText: "Date of Death" + dtFormat, size: "0"};
helpTextMap['fnodRecVetSSN'] = {header: "Veteran Social Security Number", helpText: "The Veterans Social Security number in the format: ###-##-####", size: "11"};
helpTextMap['fnodRecVetClaimNum'] = {header: "Veteran Claim Number", helpText: "Field accepts all numeric characters or can start with C or C- followed by numeric characters.", size: "9"};
helpTextMap['fnodRecVetMilServcNum'] = {header: "Military Service Number", helpText: "Field accepts alpha-numeric characters and hyphens and must contain at least one numeric character.", size: "10"};
helpTextMap['fnodRecRegionalOffice'] = {header: "Regional Office", helpText: "The regional office this case is assigned to. ", size: "0"};
helpTextMap['benefitCancelled'] = {header: "Benefit Cancelled", helpText: "Have the Veterans Benefits been cancelled?  If selected, must enter amount in the Montly Amount field.", size: "0"};
helpTextMap['fnodRecFlagIssued'] = {header: "Flag Issued", helpText: "Has a flag been issued for this veteran ", size: "0"};
helpTextMap['fnodRecPMC'] = {header: "PMC", helpText: "Has a Presidential Memorial Certificate been requested ", size: "0"};
helpTextMap['tooOld'] = {header: "Too Old To Create", helpText: "Is this too old to create", size: "0"};
helpTextMap['nmi'] = {header: "NMI", helpText: "Need More Information.  Selected when a SHARE update could not be performed and/or Veteran Distinguishing ID - SSN, Claim Number, or Military Service Number are null.  PSA users can only Park and not Complete a record with this option selected.", size: "0"};
helpTextMap['fnodRecFNOD'] = {header: "FNOD", helpText: "Selected when FNOD processing was performed in SHARE.", size: "0"};
helpTextMap['monthlyAmount'] = {header: "Monthly Amount", helpText: "Monthly Amount of the veterans benefit, must be filled in if Benefit Cancelled is selected.", size: "0"};
helpTextMap['fnodRecBirlsAdd'] = {header: "Birls Add", helpText: "Birls Add, Rules: FNOD must be selected, Veteran DOD must be present;  Birls Update, Benefit Cancelled and DOD Already Present cannot be selected.", size: "0"};
helpTextMap['fnodRecBirlsUpdate'] = {header: "Birls Update", helpText: "Birls Update, Rules: Veteran DOD must be present; Birls Add, Benefit Cancelled cannot be selected", size: "0"};
helpTextMap['fnodRecEligibilityVerf'] = {header: "Eligibility Verification", helpText: "Have benefits been verified and is the veteran eligible", size: "0"};
helpTextMap['fnodRecDodPresent'] = {header: "DOD Already Present", helpText: "Is DOD already present", size: "0"};
helpTextMap['iris'] = {header: "IRIS", helpText: "Selected when an IRIS notification was sent.", size: "0"};
helpTextMap['nis'] = {header: "NIS", helpText: "Not in System, cannot be selected if Sensitive is selected", size: "0"};
helpTextMap['sensitive'] = {header: "Sensitive", helpText: "Access to a record assigned in SHARE.  Cannot be selected if NIS is selected.", size: "0"};
helpTextMap['folderOnlyBenefit'] = {header: "Folder Only Benefit", helpText: "Folder Only Benefit need text", size: "0"};
helpTextMap['fnodRecComments'] = {header: "Comments", helpText: "Any addtional comments which are needed for this record.", size: "4000+"};


/* searchFNODRecordsCriteria.xhtml items */
helpTextMap['userName'] = {header: "User Name", helpText: "Search for records associated with a particular user of the system by using their login id", size: "0"};
helpTextMap['searchCaseId'] = {header: "Case ID", helpText: "Search for records using a Case ID", size: "9"};
helpTextMap['searchFirstName'] = {header: "First Name", helpText: "Search for records using the first name of a Veteran." + wildCardHelp, size: "15"};
helpTextMap['searchMiddleName'] = {header: "Middle Name", helpText: "Search for records using the middle name of a Veteran. " + wildCardHelp, size: "15"};
helpTextMap['searchLastName'] = {header: "Last Name", helpText: "Search for records using the last name of a Veteran."  + wildCardHelp, size: "25"};

helpTextMap['searchSuffixName'] = {header: "Suffix Name", helpText: "Search for records using the last name suffix of a Veteran.", size: "3"};
helpTextMap['searchDOB'] = {header: "Birth Date", helpText: "Search for records using the Veteran's Birth Date" + dtFormat, size: "0"};
helpTextMap['searchDOD'] = {header: "Date of Death", helpText: "Search for records using the Veteran's Date of Death" + dtFormat, size: "0"};
helpTextMap['searchFnodCreateDate'] = {header: "FNOD Create Date", helpText: "Search for records using the date the FNOD record was created" + dtFormat, size: "0"};
helpTextMap['searchSSN'] = {header: "Social Security Number", helpText: "Search for records using the Veteran's SSN, use 9 digits or ###-##-####", size: "11"};
helpTextMap['searchClaimNum'] = {header: "Veteran Claim Number", helpText: "Field accepts all numeric characters or can start with C or C- followed by numeric characters.", size: "9"};
helpTextMap['searchMilitaryNum'] = {header: "Military Service Number", helpText: "Field accepts alpha-numeric characters and hyphens and must contain at least one numeric character.", size: "10"};

/* samplePendingCasesCriteria.xhtml items */
helpTextMap['samplePendingPercent'] = {header: "Sample Percent", helpText: "Sample size in percent of available records in specified date range, valid values 0.1-100", size: "0"};
helpTextMap['samplePendingSampleSize'] = {header: "Sample Size", helpText: "Maximum number of rows in the returned sampple set, valid values 1-1000", size: "0"};
helpTextMap['samplePendingFromDate'] = {header: "From Date", helpText: "The beginning date for the sample set.", size: "0"};
helpTextMap['samplePendingToDate'] = {header: "To Date", helpText: "The end date of the sample set.", size: "0"};
helpTextMap['samplePendingSourceSystem'] = {header: "Source System", helpText: "Source System of the returned sample set.", size: "0"};

/* sampleCompleteCasesCriteria.xhtml items */
helpTextMap['sampleCompleteUserName'] = {header: "User Name", helpText: "Search for records associated with this user.", size: "0"};
helpTextMap['sampleCompletePercent'] = {header: "Sample Percent", helpText: "Sample size in percent of available records in specified date range, valid values 0.1-100", size: "0"};
helpTextMap['sampleCompleteSampleSize'] = {header: "Sample Size", helpText: "Maximum number of rows in the returned sampple set, valid values 1-1000", size: "0"};
helpTextMap['sampleCompleteFromDate'] = {header: "From Date", helpText: "The beginning date for the sample set." + dtFormat, size: "0"};
helpTextMap['sampleCompleteToDate'] = {header: "To Date", helpText: "The end date of the sample set." + dtFormat, size: "0"};
helpTextMap['sampleCompleteSourceSystem'] = {header: "Source System", helpText: "Source System of the returned sample set.", size: "0"};






function hideHelpText () { 
  var s= document.getElementById("helpArea");
  s.style.visibility = 'hidden';
}

function setHelpText(elementId) {
	var s= document.getElementById("helpArea");
	var html = "<table class='helpTable'><tr><td class='helpTableHeader'>" + helpTextMap[elementId].header + "</td><td class='helpTableHeaderLink'>" + hideLink +  "</td></tr>";
	if(helpTextMap[elementId].size != 0) { 
		html += "<tr><td colspan='2' class='helpTDSize'>Max Size: " + helpTextMap[elementId].size + "</td></tr>";
	}
	html += "<tr><td colspan='2' class='helpTD'>" + helpTextMap[elementId].helpText + "</td></tr>";
	// html += "<tr><td class='helpTD'>" + hideLink + "</td></tr></table?";
	s.innerHTML = html;
	s.style.visibility = 'visible';
	
}