package gov.va.fnod.view.validator;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

@FacesValidator("ssnValidator")
public class SsnValidator implements Validator {
    public SsnValidator() {
        super();
    }

    @Override
    public void validate(FacesContext facesContext, UIComponent uiComponent, Object value) {
        
        if ( value != null ) {
            String ssn = value.toString();
            if ( ! ssn.matches("(\\d{3}-\\d{2}-\\d{4})|(\\d{9})") ) {
                FacesMessage message = new FacesMessage("SSN must be entered as ###-##-#### or 9 digits");
                throw new ValidatorException(message);
            }
        }
        
        
    }
}
