package gov.va.fnod.view.validator;



import java.util.regex.Pattern;



import javax.faces.application.FacesMessage;

import javax.faces.component.UIComponent;

import javax.faces.context.FacesContext;

import javax.faces.validator.FacesValidator;

import javax.faces.validator.Validator;

import javax.faces.validator.ValidatorException;





// FNOD_LETTERS_CodeCR115 - VET FIRST NAME, MIDDLE NAME, LAST NAME and SUFFIX fields



/*

 * This is intended to be used to satisfy name validation that match BOSS/AMAS names

 * 		1) Must be upper case - this is handled by converter

 * 		2) Must allow all alpha characters

 * 		3) Allows the following special characters: hyphen (-), space ( ), apostrophe (')

 * 		4) First character must be alpha 

 */

@FacesValidator("bossNameValidator")

public class NameValidator implements Validator {



	private static final String NAME_PATTERN = "^([A-Za-z](?:[A-Za-z \\-\\'])*)?([A-Za-z])$";

	private Pattern namePattern;

	

	

	public NameValidator() {

		namePattern = Pattern.compile(NAME_PATTERN);

	}

	

	@Override

	public void validate(FacesContext context, UIComponent component, Object value)

			throws ValidatorException {

		

		String name = value.toString().trim();

		

		if ( !(name == null || name.isEmpty()) && ! namePattern.matcher(name).matches() ) {

			FacesMessage msg = new FacesMessage();			

			msg.setSummary("Invalid name format: ");

			msg.setDetail("names can only have alpha characters, hyphens (-) or apostrophes (')");

			msg.setSeverity(FacesMessage.SEVERITY_ERROR);

			throw new ValidatorException(msg);

		}

		

		

	}



}

