package gov.va.fnod.view.validator;



import gov.va.fnod.util.FNODConstants;

import java.util.regex.Pattern;




import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;



@FacesValidator("militaryServiceNumValidator")

public class MilitaryServiceNumValidator implements Validator {



		// Allow Alphanumeric and hyphen (-). Require at least one digit. 

		private static final String validCharacter = "^[A-Za-z0-9\\-]*[0-9][A-Za-z0-9\\-]*$";

		

		private Pattern charsPattern;	

		

		public MilitaryServiceNumValidator() {

			charsPattern = Pattern.compile(validCharacter);

		}

		

		@Override

		public void validate(FacesContext context, UIComponent component, Object value)

				throws ValidatorException {

			

			String serviceNumber = value.toString().trim();

			

			if ( !(serviceNumber == null || serviceNumber.isEmpty()) 

				&& !charsPattern.matcher(serviceNumber).matches() ) {

				

				FacesMessage msg = new FacesMessage();			

				msg.setSummary(FNODConstants.ERR_MILSRVC_VALIDATION_SUMMARY);

				msg.setDetail(FNODConstants.ERR_MILSRVC_VALIDATION_DETAIL);

				msg.setSeverity(FacesMessage.SEVERITY_ERROR);

				throw new ValidatorException(msg);

			}

			

			

		}



}



