package gov.va.fnod.view.validator;



import java.util.regex.Pattern;



import javax.faces.application.FacesMessage;

import javax.faces.component.UIComponent;

import javax.faces.context.FacesContext;

import javax.faces.validator.FacesValidator;

import javax.faces.validator.Validator;

import javax.faces.validator.ValidatorException;



@FacesValidator("claimNumberValidator")

public class ClaimNumberValidator implements Validator {



		private static final String PATTERN = "^(C[ -]|C)?(?:[0-9]+)$";

		private Pattern pattern;

		

		

		public ClaimNumberValidator() {

			pattern = Pattern.compile(PATTERN);

		}

		

		@Override

		public void validate(FacesContext context, UIComponent component, Object value)

				throws ValidatorException {

			

			String serviceNumber = value.toString().trim();

			

			if ( !(serviceNumber == null || serviceNumber.isEmpty()) && ! pattern.matcher(serviceNumber).matches() ) {

				FacesMessage msg = new FacesMessage();			

				msg.setSummary("Invalid Claim Number: ");

				msg.setDetail("Can be all digits or start with C or C- followed by digits");

				msg.setSeverity(FacesMessage.SEVERITY_ERROR);

				throw new ValidatorException(msg);

			}

			

		}



}



