package gov.va.fnod.view.filters;



import gov.va.fnod.view.UserBean;



import java.io.IOException;



import javax.servlet.Filter;

import javax.servlet.FilterChain;

import javax.servlet.FilterConfig;

import javax.servlet.ServletException;

import javax.servlet.ServletRequest;

import javax.servlet.ServletResponse;

import javax.servlet.http.HttpServletRequest;

import javax.servlet.http.HttpServletResponse;

import javax.servlet.http.HttpSession;





public class LoginFilter implements Filter {



    private FilterConfig config;

    private String loginPage;



    public LoginFilter() {

        super();

    }



    @Override

    public void init(FilterConfig filterConfig) {

        config = filterConfig;

        loginPage = config.getInitParameter("loginPage");

    }



    @Override

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse,

                         FilterChain filterChain) throws IOException, ServletException {



        /*

         * To be logged in a user must have an active session a userBean that has been authenticated.

         */

        boolean forceLogin = true;



        HttpServletRequest request = (HttpServletRequest)servletRequest;

        String url = request.getRequestURI().toString();

		if ( matchesLoginPage(url)) {

            forceLogin = false;

        } else {

            HttpSession session = request.getSession(true);

            if (session != null) {

                UserBean userBean = (UserBean)session.getAttribute("user");

                if (userBean != null) {

                    forceLogin = userBean.getUserContext() == null;

                }

            }

        }

        

        if ( forceLogin ) {

            HttpServletResponse response = (HttpServletResponse)servletResponse;

            response.sendRedirect(request.getContextPath() + loginPage);

        } else {

            filterChain.doFilter(servletRequest, servletResponse);

        }



    }



    @Override

    public void destroy() {

        config = null;

        loginPage = null;

    }



    private boolean matchesLoginPage(String loginPage) {

        return loginPage.endsWith(this.loginPage);

    }

}