package gov.va.fnod.view.converter;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;

@FacesConverter("ssnConverter")
public class SsnConverter implements Converter {
    
    public SsnConverter() {
        super();
    }

    @Override
    public Object getAsObject(FacesContext facesContext, UIComponent uiComponent, String value) {
        Object retval = null;
        if ( value != null ) {
            retval = value.replaceAll("-","");            
        }
        return retval;            
    }

    @Override
    public String getAsString(FacesContext facesContext, UIComponent uiComponent, Object value) {
        if ( value == null ) {
            return null;
        }
        
        String ssn = value.toString();
        if ( ssn.length() == 9 ) {
            StringBuilder sb = new StringBuilder();
            sb.append(ssn.substring(0,3)).append('-');
            sb.append(ssn.substring(3,5)).append('-');
            sb.append(ssn.substring(5,9));
            ssn = sb.toString();
        }
        return ssn;
    }
}
