package gov.va.fnod.view.converter;

import java.util.HashMap;
import java.util.Map;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;

@FacesConverter(value = "sourceSystemConverter")
public class SourceSystemConverter implements Converter {

	Map<Integer, String> idsToDescriptions = new HashMap<Integer, String>();
	Map<String, Integer> descriptionsToIDs = new HashMap<String, Integer>();

	public SourceSystemConverter() {
		idsToDescriptions.put(1, "AMAS");
		idsToDescriptions.put(2, "BOSS");
		idsToDescriptions.put(3, "Flag Application");
		idsToDescriptions.put(4, "Insurance Report");
		
		descriptionsToIDs.put("AMAS", 1);
		descriptionsToIDs.put("BOSS", 2);
		descriptionsToIDs.put("Flag Application", 3);
		descriptionsToIDs.put("Insurance Report", 4);
	}

	@Override
	public Object getAsObject(FacesContext context, UIComponent component, String value) {
		return descriptionsToIDs.get(value);
	}

	@Override
	public String getAsString(FacesContext context, UIComponent component,
			Object value) {
		return idsToDescriptions.get((Integer) value);
	}

}
