package gov.va.fnod.view.converter;



import java.util.HashMap;

import java.util.Map;



import javax.faces.component.UIComponent;

import javax.faces.context.FacesContext;

import javax.faces.convert.Converter;

import javax.faces.convert.FacesConverter;



@FacesConverter(value = "sourceCaseTypeMapConverter")

public class SourceCaseTypeMapConverter implements Converter {



	Map<Integer, String> idsToDescriptions = new HashMap<Integer, String>();

	Map<String, Integer> descriptionsToIDs = new HashMap<String, Integer>();



	public SourceCaseTypeMapConverter() {

		idsToDescriptions.put(1, "AMAS");

		idsToDescriptions.put(2, "AMAS Spouse");

		idsToDescriptions.put(3, "BOSS");

		idsToDescriptions.put(4, "BOSS Spouse");

		idsToDescriptions.put(5, "Flag Application");

		idsToDescriptions.put(6, "Insurance");

		idsToDescriptions.put(7, "ANC FNOD");

		idsToDescriptions.put(8, "ANC FNOD Spouse");

		idsToDescriptions.put(9, "PRUDENTIAL INSURANCE");

		

		// Setup reverse map

		for(Map.Entry<Integer, String> map: idsToDescriptions.entrySet() ) {

			descriptionsToIDs.put(map.getValue(), map.getKey());

		}

	}



	@Override

	public Object getAsObject(FacesContext context, UIComponent component, String value) {

		return descriptionsToIDs.get(value);

	}



	@Override

	public String getAsString(FacesContext context, UIComponent component,

			Object value) {

		Integer val = (value instanceof Integer) ? (Integer) value : Integer.parseInt(value.toString());

		return idsToDescriptions.get(val);

	}

	

}

