package gov.va.fnod.view.converter;

import gov.va.fnod.model.fnoddata.RegionalOffice;
import gov.va.fnod.util.JSFUtil;
import gov.va.fnod.view.LookupBean;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;

@FacesConverter(value = "regionalOfficeConverter")
public class RegionalOfficeConverter implements Converter {

	@Override
	public Object getAsObject(FacesContext facesContext, UIComponent comp, String value) {
		String result = null;
		if (value != null) {
			LookupBean lookup = (LookupBean) JSFUtil.resolveExpression("#{lookup}", LookupBean.class);
			for (RegionalOffice ro : lookup.getRegionalOffices()) {
				if (value.equals(String.valueOf(ro.getRegionalOfficeName()))) {
					result = String.valueOf(ro.getRegionalOfficeId());
					break;
				}
			}
		}
		return result;	
	}

	@Override
	public String getAsString(FacesContext facesContext, UIComponent comp, Object value) {
		String result = null;
		Long longValue = (Long) value;
		if (longValue != null) {
			LookupBean lookup = (LookupBean) JSFUtil.resolveExpression("#{lookup}", LookupBean.class);
			for (RegionalOffice ro : lookup.getRegionalOffices()) {
				if (longValue.equals(ro.getRegionalOfficeId())) {
					result = ro.getRegionalOfficeNum() + " " + ro.getRegionalOfficeName();
					break;
				}
			}
		}
		return result;

	}
	

}
