package gov.va.fnod.view.converter;

import java.util.HashMap;
import java.util.Map;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;

@FacesConverter(value = "regionConverter")
public class RegionConverter implements Converter {

	Map<Integer, String> idsToDescriptions = new HashMap<Integer, String>();
	Map<String, Integer> descriptionsToIDs = new HashMap<String, Integer>();

	public RegionConverter() {
		idsToDescriptions.put(1, "Western");
		idsToDescriptions.put(2, "Central");
		idsToDescriptions.put(3, "Southern");
		idsToDescriptions.put(4, "Eastern");
		
		descriptionsToIDs.put("Western", 1);
		descriptionsToIDs.put("Central", 2);
		descriptionsToIDs.put("Southern", 3);
		descriptionsToIDs.put("Eastern", 4);
	}

	@Override
	public Object getAsObject(FacesContext context, UIComponent component, String value) {
		return descriptionsToIDs.get(value);
	}

	@Override
	public String getAsString(FacesContext context, UIComponent component,
			Object value) {
		if (value instanceof Integer) {
			return idsToDescriptions.get((Integer) value);
		}
		else if (value instanceof Long) {
			return idsToDescriptions.get(((Long) value).intValue());
		}
		else {
			return null;
		}
	}

}
