package gov.va.fnod.view.converter;

import java.util.HashMap;
import java.util.Map;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;

@FacesConverter(value = "caseTypeConverter")
public class CaseTypeConverter implements Converter {

	Map<Integer, String> idsToDescriptions = new HashMap<Integer, String>();
	Map<String, Integer> descriptionsToIDs = new HashMap<String, Integer>();

	public CaseTypeConverter() {
		idsToDescriptions.put(1, "FNOD");
		idsToDescriptions.put(2, "FNOD Spouse");
		idsToDescriptions.put(3, "Flag Application");
		idsToDescriptions.put(4, "Insurance Report");
		
		descriptionsToIDs.put("FNOD", 1);
		descriptionsToIDs.put("FNOD Spouse", 2);
		descriptionsToIDs.put("Flag Application", 3);
		descriptionsToIDs.put("Insurance Report", 4);
	}

	@Override
	public Object getAsObject(FacesContext context, UIComponent component, String value) {
		return descriptionsToIDs.get(value);
	}

	@Override
	public String getAsString(FacesContext context, UIComponent component,
			Object value) {
		return idsToDescriptions.get((Integer) value);
	}

}
