package gov.va.fnod.view.converter;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;


/**
 * This converter makes any control bound to the model/application, return capital values, rather than
 * camel-cased values as typed.  It was conceived when we needed a way to capitalize usernames, so that
 * when we typed them into the create user or login screen, they'd be saved and compared as all caps.
 *  
 * @author VHAISLHODGEJ
 *
 */
@FacesConverter(value = "capitalizeStringConverter")
public class CapitalizeStringConverter implements Converter {

	@Override
	public Object getAsObject(FacesContext facesContext, UIComponent comp, String value) {
		if (value == null) {
			return null;
		}
		return value.toUpperCase().trim();
	}

	@Override
	public String getAsString(FacesContext facesContext, UIComponent comp, Object value) {
		if (value == null) {
			return null;
		}
		return value.toString().toUpperCase().trim();
	} 


}
