package gov.va.fnod.view.converter;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;

// import org.apache.myfaces.trinidad.component.core.input.CoreSelectBooleanCheckbox;

/**
 * A simple converter to be used within tr:selectBooleanCheckbox tags to convert the database values of 'Y' and 'N' 
 * to the 'true' and 'false' expected by the UI components.
 * 
 * @author VHAISLHODGEJ
 *
 */
@FacesConverter(value = "booleanToYNConverter")
public class BooleanToYNConverter implements Converter {

	@Override
	public Object getAsObject(FacesContext facesContext, UIComponent component, String value) {
		String result = null;
		if (value == null) {
			result = null;
		}
		else if ("false".equals(value)) {
			result = "N";
//			if (component instanceof CoreSelectBooleanCheckbox) {
//				CoreSelectBooleanCheckbox checkbox = (CoreSelectBooleanCheckbox) component;
//				if (checkbox.isDisabled()) {
//					result = null;
//				}
//			}
		}
		else if ("true".equals(value)){
			result = "Y";
		}
		return result;
	}

	@Override
	public String getAsString(FacesContext facesContext, UIComponent component, Object value) {
		String result = null;
		if (value == null) {
			result = null;
		}
		else if ("Y".equalsIgnoreCase(value.toString())) {
			result = "true";
		}
		else if ("N".equalsIgnoreCase(value.toString())) {
			result = "false";
		}
		return result;
	}

}
