package gov.va.fnod.view;

import gov.va.fnod.model.ErrorCode;
import gov.va.fnod.model.FNODModelConstants;
import gov.va.fnod.model.UserPrivilege;
import gov.va.fnod.model.fnoddata.AppRole;
import gov.va.fnod.model.fnoddata.AppUser;
import gov.va.fnod.model.fnoddata.AppUserRole;
import gov.va.fnod.security.LoginStatus;
import gov.va.fnod.security.exception.AccountLockedException;
import gov.va.fnod.service.UserAuthorizationSession;
import gov.va.fnod.service.UserContextSession;
import gov.va.fnod.service.UserMaintenenceSession;
import gov.va.fnod.service.UserSession;
import gov.va.fnod.util.JSFMessageUtil;

import java.io.Serializable;
import java.security.PrivilegedActionException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.ViewScoped;

import org.apache.log4j.Logger;
import org.apache.myfaces.trinidad.component.core.input.CoreSelectManyListbox;
import org.apache.myfaces.trinidad.context.RequestContext;



@ManagedBean(name = "userProfile")
@ViewScoped
public class UserProfileBean implements Serializable {

	private static final long serialVersionUID = 232325416487L;
	private static final Logger log = Logger.getLogger(UserProfileBean.class);
	
	@EJB
	private UserMaintenenceSession userMaintenance;
	
	@EJB
	private UserAuthorizationSession userAuthorization;
	
	@EJB 
	UserContextSession userContextSession;
	
	@EJB
	private UserSession userSession;
	
	private String appUserSearch;
	private String appRoleSearch;
	private List<AppRole> appRoles;
	private List<AppUser> searchList;
	private AppUser selAppUser;
	private boolean isUserLocked;
	private List<String> assignedRoles;
	private boolean displayChangePassword;
	private boolean displayAdmin;
	private boolean displayAddUser;
	private boolean displaySearchGrid;
	private boolean displayResetPassword;
	private boolean displayAddEditUser;	
	private boolean isUserEdited;
	private boolean displayChangeOwnPassword = true;
	private String displaynameOld;
	private List<String> assignedRolesOld;
	private String oldPassword;
	private String newPassword;
	private String confirmNewPassword;
	private String editedPassword;
	private String confirmEditedPassword;
	private String resetPassword;
	private String confirmResetPassword;
		
	@ManagedProperty("#{user}")
	private UserBean activeUser;
	
	private CoreSelectManyListbox assignedRolesListBox;
	
	public UserProfileBean() {
		super();
	}
	
	
	/**
	 * @param activeUser the activeUser to set
	 */
	public void setActiveUser(UserBean activeUser) {
		this.activeUser = activeUser;
	}

	@PostConstruct
	public void init() {
		resetAllDisplay(); 
		
		if(activeUser.getUserContext() != null) {
			setDisplayChangePassword(answerPrivQ(UserPrivilege.LOGIN));
						
			setDisplayAdmin(answerPrivQ(UserPrivilege.RESET_PASSWORD, UserPrivilege.LOCK_ACCOUNT) &&
			               ( answerPrivQ(UserPrivilege.CREATE_ACCOUNT, UserPrivilege.ADD_ANY_ROLE) 
			                  || answerPrivQ(UserPrivilege.ADD_USER_ROLES) ));
				
			setDisplayAddUser(answerPrivQ(UserPrivilege.CREATE_ACCOUNT));
		}
	}

	/**
	 * @return the appRoles
	 */
	public List<AppRole> getAppRoles() {
		if(null == appRoles) {	
			appRoles = userSession.getAppRoles();
		}
		return appRoles;
	}
	
	/**
	 * when the Add User is clicked
	 */
	public void addUser() {
		resetAllDisplay();
		setDisplayAddEditUser(true);
		setDisplayAddUser(true);
		setDisplayChangeOwnPassword(false);
		selAppUser = userSession.createUser();		
	}
	
	/**
	 * when the Search User is clicked
	 */
	public void searchUser() {
		resetAllDisplay();
		setDisplayAdmin(true);
		setDisplaySearchGrid(true);
		setDisplayChangeOwnPassword(false);
	}
	
	/**
	 * when the search button is clicked
	 */
	public void search() {
		searchList = null;
	}
	
	/**
	 * @return the searchList
	 */
	public List<AppUser> getSearchList() {
		if(searchList == null) {
			if(appRoleSearch != null) {
				searchList = userSession.getAppUsers(appUserSearch, appRoleSearch, activeUser.getUserContext(), answerPrivQ(UserPrivilege.ADD_ANY_ROLE));				
			}
		}		
		return searchList;
	}
	
	/**
	 * when Edit is clicked on the search grid
	 */
	public void editUserProfile() {
		this.isUserEdited = true;
		resetAllDisplay();
		setDisplayAddEditUser(true);
		setUserEdited(true);
		selAppUser =  (AppUser) RequestContext.getCurrentInstance().getPageFlowScope().get("selectedUser");
		if(selAppUser != null) {
			displaynameOld = selAppUser.getDisplayName();
			if(selAppUser.getStatus().equals(LoginStatus.LOCKED.toString())) {
				isUserLocked = true;
			}			
			List<AppUserRole> roles = selAppUser.getAppUserRoles();
			if(roles != null && !roles.isEmpty()) {
				if(assignedRoles == null) {
					assignedRoles = new ArrayList<String>();				
				}
				if(assignedRolesOld == null) {
					assignedRolesOld = new ArrayList<String>();				
				}
				for(AppUserRole role: roles) {					
					assignedRoles.add(role.getAppRole().getRoleCd());
					assignedRolesOld.add(role.getAppRole().getRoleCd());
				}		
			}
		}
		setDisplayChangeOwnPassword(false);
	}
	
	/**
	 * delete the user profile
	 * @return 
	 */
	public String deleteProfile() {
		try { 
			// ensure the active user has delete privileges.
			if (answerPrivQ(UserPrivilege.DELETE_ACCOUNT)) {
				userSession.deleteUserProfile(activeUser.getUser(), selAppUser); 
				selAppUser = null; // clear all reference to the deleted user
				this.searchList = null; // clear the search results so they'll be re-fetched without the deleted user
				this.clearPasswords();
				this.resetAllDisplay();
			}
			else {
				JSFMessageUtil.addError("PRIV-02", "Privileged Operation!", "You do not have the required privileges to delete an account.");
			}
		} catch (PrivilegedActionException e) {
			JSFMessageUtil.addError("PRIV-01", e.getMessage(), e.getMessage());
		}

		return null;
	}
	
	/**
	 * when Reset Password is clicked
	 */
	public void resetPassword() {
		resetAllDisplay();
		setDisplayResetPassword(true);
		selAppUser =  (AppUser) RequestContext.getCurrentInstance().getPageFlowScope().get("selectedUser");
		if(selAppUser != null) {
			selAppUser.setPassword(null);
		}
		setDisplayChangeOwnPassword(false);
	}
	
	public String saveUserProfile() {
//		PasswordManagerBase passwordManager = new PasswordManager(new PasswordHasher(), new PasswordValidator());
		Map<ErrorCode, String> errors = null;		
		
		// WE ARE ADDING or EDITING A USER
		if(displayAddEditUser) {
			// ensure both edited password and re-entered edited password are the same
			if (displayAddUser && (this.editedPassword == null || !this.editedPassword.equals(this.confirmEditedPassword))) {
				JSFMessageUtil.addError("PSWD-02", "Passwords do not match!", "Please enter the same password twice.");
				return null;
			}
			
			String errorMessage = null;
			if(! answerPrivQ(UserPrivilege.ADD_ANY_ROLE) ) {				
				if(appRoles != null && !appRoles.isEmpty()) {
					for(AppRole role: appRoles) {
						if(assignedRoles.contains(role.getRoleCd())) {
							if(!role.getRoleUser().equals(FNODModelConstants.IS_USER_ROLE)) {								
								if(errorMessage == null) {
									errorMessage = ErrorCode.CANNOT_ASSIGN_ROLE.getErrorMsg().concat(role.getDescription());	
								}
								else {
									errorMessage = errorMessage.concat(" , " + role.getDescription());
								}
							}
						}
					}
				}
			}
			if(errorMessage != null) {
				errors = new HashMap<ErrorCode, String>();
				errors.put(ErrorCode.CANNOT_ASSIGN_ROLE, errorMessage);
				log.error(ErrorCode.CANNOT_ASSIGN_ROLE);
			}
			if(errors == null || errors.isEmpty()) {
				
				//edit user
				if(isUserEdited) {
					if(!displaynameOld.equalsIgnoreCase(selAppUser.getDisplayName()) || selAppUser.isLockUnlockAct() || !compareRoles(assignedRolesOld, assignedRoles)) {
						
						// lock or unlock the user account
						if(selAppUser.isLockUnlockAct()) {
							if(isUserLocked) {
								selAppUser.setStatus(LoginStatus.OPEN.toString());
								selAppUser.setLockedTime(null);
								JSFMessageUtil.addInfo("USR-DUP", "User Edit Succeeded!", "User " + selAppUser.getUsername() + " unlocked.");
							}
							else {
								selAppUser.setStatus(LoginStatus.LOCKED.toString());
								selAppUser.setLockedTime(new Timestamp(System.currentTimeMillis()));
								JSFMessageUtil.addInfo("USR-03", "User Edit Succeeded!", "User " + selAppUser.getUsername() + " locked.");
							}
						}
						
						// assign roles
						List<AppRole> selAppRoleList = null;
						if(assignedRoles != null && !assignedRoles.isEmpty()) {
							selAppRoleList = new ArrayList<AppRole>();
							for(AppRole role: appRoles) {
								if(assignedRoles.contains(role.getRoleCd())) {
									selAppRoleList.add(role);
								}						
							}
						}
						
						if(selAppRoleList != null && !selAppRoleList.isEmpty()) {
							if(selAppUser.getAppUserRoles() == null || selAppUser.getAppUserRoles().isEmpty()) {
								selAppUser.setAppUserRoles(new ArrayList<AppUserRole>());
								for(AppRole role: selAppRoleList) {
									AppUserRole appUserRole = new AppUserRole();
									appUserRole.setAppRole(role);
									appUserRole.setAppUser(selAppUser);
									selAppUser.getAppUserRoles().add(appUserRole);
									JSFMessageUtil.addInfo("USR-ROLE-" + role.getRoleCd(), "Add Role Succeeded!", "User " + selAppUser.getUsername() + " assigned role " + role.getDescription() + ".");
								}
							}
							else {							
								// remove roles
								boolean isRoleExists = false;
								for(AppRole role: selAppRoleList) {
									isRoleExists = false;
									for(AppUserRole appUserRole: selAppUser.getAppUserRoles()) {	
										if(role.getRoleCd().equals(appUserRole.getAppRole().getRoleCd())) {
											isRoleExists = true;
											break;
										}
									}
									if(!isRoleExists) {
										AppUserRole appUserRole = new AppUserRole();
										appUserRole.setAppRole(role);
										appUserRole.setAppUser(selAppUser);
										selAppUser.getAppUserRoles().add(appUserRole);
										JSFMessageUtil.addInfo("USR-ROLE-" + role.getRoleCd(), "Add Role Succeeded!", "User " + selAppUser.getUsername() + " assigned role " + role.getDescription() + ".");
									}
								}
								AppUserRole appUserRoleIt;
								Iterator<AppUserRole> it = selAppUser.getAppUserRoles().iterator();
								isRoleExists = false;
								while(it.hasNext()) {
									isRoleExists = false;
									appUserRoleIt = it.next();
									for(AppRole role: selAppRoleList) {
										if(appUserRoleIt.getAppRole().getRoleCd().equals(role.getRoleCd())) {
											isRoleExists = true;
											break;
										}
									}
									if(!isRoleExists) {
										it.remove();
										JSFMessageUtil.addInfo("USR-ROLE-" + appUserRoleIt.getAppRole().getRoleCd(), "Remove Role Succeeded!", "Removed role " + appUserRoleIt.getAppRole().getDescription() + " from user " + selAppUser.getUsername() + ".");
									}
								}
							}
						}
						else {				
							selAppUser.getAppUserRoles().clear();
							JSFMessageUtil.addInfo("USR-ROLE-REMOVED-ALL", "All Roles Removed!", "All Roles deleted for user " + selAppUser.getUsername() + ".");
						}						
					}
				}
				
				// this is ADD USER
				else {
					// check if user already exists
					
					if( userContextSession.getUserContext(selAppUser.getUsername()) != null  ) {
						errors = new HashMap<ErrorCode, String>();
						log.error(ErrorCode.USER_EXISTS.getErrorMsg());
						JSFMessageUtil.addError("USR-02", "Duplicate.", "User already exists.");
						return null;
					}

					if(errors == null || errors.isEmpty()) {
						selAppUser.setPassword("TEMP_INVALID_PASSWORD"); // just use a temporary, and we'll reset it later
						
						// assign the user any selected roles
						if (assignedRoles == null || assignedRoles.isEmpty()) {
							JSFMessageUtil.addError("ROLE-01", "No role selected.", "New users must be assigned at least 1 role.");
							return null;
						}
						if(appRoles != null && !appRoles.isEmpty() && assignedRoles != null && !assignedRoles.isEmpty()) {
							selAppUser.setAppUserRoles(new ArrayList<AppUserRole>());
							for(AppRole role: appRoles) {
								if(assignedRoles.contains(role.getRoleCd())) {
									AppUserRole appUserRole = new AppUserRole();
									appUserRole.setAppUser(selAppUser);
									appUserRole.setAppRole(role);
									selAppUser.getAppUserRoles().add(appUserRole);						
								}
							}
						}
						JSFMessageUtil.addInfo("USR-01", "Add User Succeeded!", "User " + selAppUser.getUsername() + " added to the system.");
					}				
				}
			}
		}
		
		
		
		
		
		// this is RESET PASSWORD
		if(displayResetPassword) {
			try {
				if (resetPassword == null || !resetPassword.equals(confirmResetPassword)) {
					JSFMessageUtil.addError("PSWD-03", "Passwords do not match!", "Please enter the same, valid password twice to reset the user's password.");
					return null;
				}
				userMaintenance.resetPswd(activeUser.getUserContext(), userMaintenance.getUserContext(selAppUser.getUsername()), this.resetPassword);
			} catch (Exception e) {
				log.error("Unable to reset password user: " + selAppUser.getUsername());
				JSFMessageUtil.addError("UNLK-01", "Operation Failed!", e.getMessage());
				return null;
			}
		}

		
		
		
		// NOW SAVE IT ALL 
		try { 
			// this is RESET PASSWORD
			if(newPassword != null && !newPassword.isEmpty()) {
				if (!newPassword.equals(confirmNewPassword)) {
					JSFMessageUtil.addError("PSWD-01", "Passwords do not match!", "Please enter the same valid password twice to change the password.");
					return null;
				}
				userMaintenance.changePswd(activeUser.getUserContext(), oldPassword, newPassword);
//				UserContext userToChange = (selAppUser == null) ? activeUser.getUserContext() : userMaintenance.getUserContext(selAppUser.getUsername());
//				
//				//userSession.saveUserProfile(selAppUser, displayAddEditUser, displayResetPassword, activeUser.getUser());
//				userMaintenance.resetPswd(activeUser.getUserContext(), userToChange, selAppUser.getPassword());
				JSFMessageUtil.addInfo("USR-00", "User Profile Saved!", "Profile saved for user: " + activeUser.getUsername());
			}
			else {
				// this is SAVE USER PROFILE DETAILS
				saveModifiedUser();
				
				// this was an initial creation of the user, so once we've saved the user with a default password,
				// go in and reset the password for the user.
				if (displayAddUser) {					
					userMaintenance.resetPswd(activeUser.getUserContext(),userMaintenance.getUserContext(selAppUser.getUsername()),  this.editedPassword);
					clearPasswords();
				}
				if(isUserEdited) {
					JSFMessageUtil.addInfo("USR-00", "User Profile Saved!", "Profile saved for user " + selAppUser.getUsername() + ".");
				}
			}

		}
		catch (Exception e) {
			JSFMessageUtil.addError("USR-00", "User Profile NOT Saved!", e.getMessage());
			log.error(e);
		}
		
		return null;
	}
	
	private void clearPasswords() {
		oldPassword = null;
		newPassword = null;
		confirmNewPassword = null;	
		editedPassword = null;
		confirmEditedPassword = null;
		resetPassword = null;
		confirmResetPassword = null;
//		TODO: Reset Roles List Box
		this.selAppUser = new AppUser();
	}


	/**
	 * Called for all save user operations that aren't specifically covered by the new Security API's contract
	 */
	private void saveModifiedUser() {
		if (!displayResetPassword) {
			userSession.saveUserProfile(activeUser.getUser(), selAppUser, displayAddEditUser, displayResetPassword);
		} // else, it's called elsewhere
	}
	
	public boolean isDeletePossible() {
		boolean deletePossible = false;
		try {				
			deletePossible = selAppUser != null 
						  && selAppUser.getPswdHash() != null; //pswd hash is only populated upon persistence, so use that to indicate a saved state
		}
		catch (Exception e) {
			// this means the user wasn't found.  No problem, often expected
		}
		return deletePossible;
	}
	
	
	/**
	 * cancel is clicked on the User Profile screen
	 * @return
	 */
	public String cancelUserProfile() {
		return "main";
	}
	
	/**
	 * compare the assigned roles
	 * @param list1
	 * @param list2
	 * @return
	 */
	private boolean compareRoles(List<String> list1,
			List<String> list2) {
		if(list1 == null || list2 == null) {
			throw new IllegalArgumentException("list1 and list2 must not be null");
		}
		if(list1.size() != list2.size()) {
			return false;
		}
		for(String role: list1) {
			if(!list2.contains(role)) {
				return false;
			}
		}
		for(String role: list2) {
			if(!list1.contains(role)) {
				return false;
			}
		}
		return true;
	}
	
	/**
	 * reset the user profile params
	 */
	private void resetAllDisplay() {
		setDisplayAdmin(false);
		setDisplaySearchGrid(false);
		setDisplayResetPassword(false);
		setDisplayAddEditUser(false);
		setDisplayAddUser(false);
		setUserEdited(false);
		setDisplayChangeOwnPassword(true);
	}
	

	/**
	 * @return the appRoleSearch
	 */
	public String getAppRoleSearch() {
		return appRoleSearch;
	}

	/**
	 * @param appRoleSearch the appRoleSearch to set
	 */
	public void setAppRoleSearch(String appRoleSearch) {
		this.appRoleSearch = appRoleSearch;
	}

	/**
	 * @return the appUserSearch
	 */
	public String getAppUserSearch() {
		return appUserSearch;
	}

	/**
	 * @param appUserSearch the appUserSearch to set
	 */ 
	public void setAppUserSearch(String appUserSearch) {
		this.appUserSearch = appUserSearch;
	}

	/**
	 * @return the selAppUser
	 */
	public AppUser getSelAppUser() {
		return selAppUser;
	}

	/**
	 * @param selAppUser the selAppUser to set
	 */
	public void setSelAppUser(AppUser selAppUser) {
		this.selAppUser = selAppUser;
	}

	/**
	 * @return the assignedRoles
	 */
	public List<String> getAssignedRoles() {
		return assignedRoles;
	}

	/**
	 * @param assignedRoles the assignedRoles to set
	 */
	public void setAssignedRoles(List<String> assignedRoles) {
		this.assignedRoles = assignedRoles;
	}

	/**
	 * @return the displayChangePassword
	 */
	public boolean isDisplayChangePassword() {
		return displayChangePassword;
	}

	/**
	 * @param displayChangePassword the displayChangePassword to set
	 */
	public void setDisplayChangePassword(boolean displayChangePassword) {
		this.displayChangePassword = displayChangePassword;
	}

	/**
	 * @return the displayAdmin
	 */
	public boolean isDisplayAdmin() {
		return displayAdmin;
	}

	/**
	 * @param displayAdmin the displayAdmin to set
	 */
	public void setDisplayAdmin(boolean displayAdmin) {
		this.displayAdmin = displayAdmin;
	}

	/**
	 * @return the displayResetPassword
	 */
	public boolean isDisplayResetPassword() {
		return displayResetPassword;
	}

	/**
	 * @param displayResetPassword the displayResetPassword to set
	 */
	public void setDisplayResetPassword(boolean displayResetPassword) {
		this.displayResetPassword = displayResetPassword;
	}

	/**
	 * @return the displayAddEditUser
	 */
	public boolean isDisplayAddEditUser() {
		return displayAddEditUser;
	}

	/**
	 * @param displayAddEditUser the displayAddEditUser to set
	 */
	public void setDisplayAddEditUser(boolean displayAddEditUser) {
		this.displayAddEditUser = displayAddEditUser;
	}

	/**
	 * @return the displaySearchGrid
	 */
	public boolean isDisplaySearchGrid() {
		return displaySearchGrid;
	}

	/**
	 * @param displaySearchGrid the displaySearchGrid to set
	 */
	public void setDisplaySearchGrid(boolean displaySearchGrid) {
		this.displaySearchGrid = displaySearchGrid;
	}

	/**
	 * @return the isUserEdited
	 */
	public boolean isUserEdited() {
		return isUserEdited;
	}

	/**
	 * @param isUserEdited the isUserEdited to set
	 */
	public void setUserEdited(boolean isUserEdited) {
		this.isUserEdited = isUserEdited;
	}

	/**
	 * @return the displaynameOld
	 */
	public String getDisplaynameOld() {
		return displaynameOld;
	}

	/**
	 * @param displaynameOld the displaynameOld to set
	 */
	public void setDisplaynameOld(String displaynameOld) {
		this.displaynameOld = displaynameOld;
	}

	/**
	 * @return the assignedRolesOld
	 */
	public List<String> getAssignedRolesOld() {
		return assignedRolesOld;
	}

	/**
	 * @param assignedRolesOld the assignedRolesOld to set
	 */
	public void setAssignedRolesOld(List<String> assignedRolesOld) {
		this.assignedRolesOld = assignedRolesOld;
	}

	/**
	 * @return the isUserLocked
	 */
	public boolean isUserLocked() {
		return isUserLocked;
	}

	/**
	 * @param isUserLocked the isUserLocked to set
	 */ 
	public void setUserLocked(boolean isUserLocked) {
		this.isUserLocked = isUserLocked;
	}

	/**
	 * @return the displayAddUser
	 */
	public boolean isDisplayAddUser() {
		return displayAddUser;
	}


	/**
	 * @param displayAddUser the displayAddUser to set
	 */
	public void setDisplayAddUser(boolean displayAddUser) { 
		this.displayAddUser = displayAddUser;
	}

	/**
	 * @return the newPassword
	 */
	public String getNewPassword() {
		return newPassword;
	}

	/**
	 * @param newPassword the newPassword to set
	 */
	public void setNewPassword(String newPassword) {
		this.newPassword = newPassword;
	}
	
	private boolean answerPrivQ(UserPrivilege ... privileges) {
		try {
			return userAuthorization.isUserAuthorized(this.activeUser
					.getUserContext(), userAuthorization
					.createSystemContext("UserProfilePriv", privileges));
		} catch (AccountLockedException ex) {
			// TODO - force logout
			return false;
		}
	}


	public String getOldPassword() {
		return oldPassword;
	}


	public void setOldPassword(String oldPassword) {
		this.oldPassword = oldPassword;
	}


	public String getConfirmNewPassword() {
		return confirmNewPassword;
	}


	public void setConfirmNewPassword(String confirmNewPassword) {
		this.confirmNewPassword = confirmNewPassword;
	}


	public String getConfirmEditedPassword() {
		return confirmEditedPassword;
	}


	public void setConfirmEditedPassword(String confirmEditedPassword) {
		this.confirmEditedPassword = confirmEditedPassword;
	}


	public String getEditedPassword() {
		return editedPassword;
	}


	public void setEditedPassword(String editedPassword) {
		this.editedPassword = editedPassword;
	}


	public CoreSelectManyListbox getAssignedRolesListBox() {
		return assignedRolesListBox;
	}


	public void setAssignedRolesListBox(CoreSelectManyListbox assignedRolesListBox) {
		this.assignedRolesListBox = assignedRolesListBox;
	}


	public boolean isDisplayChangeOwnPassword() {
		return displayChangeOwnPassword;
	}


	public void setDisplayChangeOwnPassword(boolean displayChangeOwnPassword) {
		this.displayChangeOwnPassword = displayChangeOwnPassword;
	}


	public String getResetPassword() {
		return resetPassword;
	}


	public void setResetPassword(String resetPassword) {
		this.resetPassword = resetPassword;
	}


	public String getConfirmResetPassword() {
		return confirmResetPassword;
	}


	public void setConfirmResetPassword(String confirmResetPassword) {
		this.confirmResetPassword = confirmResetPassword;
	}
}