package gov.va.fnod.view;

import gov.va.fnod.model.UserPrivilege;
import gov.va.fnod.model.fnoddata.AppUser;
import gov.va.fnod.security.authorization.UserContext;
import gov.va.fnod.security.exception.AccountLockedException;
import gov.va.fnod.service.UserAuthorizationSession;
import gov.va.fnod.service.UserSession;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import javax.ejb.EJB;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.servlet.http.HttpSession;

@ManagedBean(name = "user")
@SessionScoped
public class UserBean implements Serializable {

	
	private static final long serialVersionUID = 7788546452L;
	
	@EJB
	private UserSession userSession;

	@EJB
	private UserAuthorizationSession userAuthorization;
  
  private Locale userLoc;
	
	// private AppUser user; 
	private UserContext userContext;
	private AppUser user;
	
	
	public UserBean() {
		super();
	}
	
	public String logout() {
		HttpSession session = (HttpSession) FacesContext.getCurrentInstance().getExternalContext().getSession(false);
		session.invalidate();
		return "login.xhtml?faces-redirect=true";
	}

	/**
	 * invalidate the session
	 */
	public void invalidateSession() {
		HttpSession session = (HttpSession) (FacesContext.getCurrentInstance()
				.getExternalContext().getSession(false));
		if (session != null) {
			session.invalidate();
		}
		setUserContext(null);
	}
	
	public List<SelectItem> getAppUserSelectList() {
		return getAppUserSelectList(user, false, true);
	}
	
	public List<SelectItem> getAppUserSelectListNoAll() {
		return getAppUserSelectList(user, false, false);
	}
	
	public List<SelectItem> getParkingLotAppUserSelectList() {
		return getAppUserSelectList(user, true, true);
	}
	
	public List<SelectItem> getParkingLotAppUserSelectListNoAll() {
		return getAppUserSelectList(user, true, false);
	}
	
	public List<SelectItem> getAppUserSelectList(AppUser currentUser,
			boolean filterByParkingLot, boolean addAll) {
		ArrayList<SelectItem> selectList = new ArrayList<SelectItem>();
		try {
			List<AppUser> list = null;
			if (filterByParkingLot) {
				list = userSession.getParkingLotAppUsers();
			}
			else {
				list = userSession.getAppUsers();
			}
			if (answerPrivQ(UserPrivilege.ASSIGN_CASE)) {
				if (addAll) {
					selectList.add(new SelectItem(null, "All"));
				}
				for (AppUser user : list) {
					if (answerPrivQ(user, UserPrivilege.PROCESS_CASE)) {
						selectList.add(new SelectItem(user));
					}
				}
			}
			else {
				selectList.add(new SelectItem(currentUser));
			}
		}
		catch (Exception e) {
			e.printStackTrace();
		}
		return selectList;
	}

	public boolean isSupervisor() {
		return answerPrivQ(UserPrivilege.ASSIGN_CASE);
	}

	public boolean isAuditor() {
		return answerPrivQ(UserPrivilege.EXECUTE_AUDIT);
	}

	public UserContext getUserContext() {
		return userContext;
	}

	public void setUserContext(UserContext userContext) {
		AppUser value = null;
		if ( userContext != null ) {
			// If there is an issue, let it happen first
			value = userSession.getUserInfo(userContext.getUserName());	
			if ( value == null ) {
				throw new IllegalArgumentException("can find user in database");
			}
		}
		// If not problems, both assignments will work
		this.user = value; 
		this.userContext = userContext;
	}

	private boolean answerPrivQ(UserPrivilege... privileges) {
		return answerPrivQ(this.getUserContext(), privileges);	
	}

	private boolean answerPrivQ(UserContext user, UserPrivilege... privileges) {
		try {
			return userAuthorization.isUserAuthorized(user,
			userAuthorization.createSystemContext("ReportBeanPriv",
			privileges));
		} catch (AccountLockedException ex) {
			return false;
		}	
	}

	public String getUsername() {
		if ( this.userContext == null ) {
			return null;
		} else {
			return this.userContext.getUserName();
		}
	}
	
	public AppUser getUser() {
		return user;
	}
  
  public void setUserLocale(final Locale loc) {
    userLoc = loc;
  }
  
  public Locale getUserLocale() {
    return userLoc;
  }

}