package gov.va.fnod.view;

import gov.va.fnod.model.fnoddata.SystemParameter;
import gov.va.fnod.service.UserSession;

import java.io.Serializable;
import java.util.List;

import javax.ejb.EJB;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ViewScoped;

@ManagedBean(name = "systemParameters")
@ViewScoped
public class SystemParametersBean implements Serializable {

	private static final long serialVersionUID = -3151761410413429760L;
	
	@EJB
	private UserSession userSession;
	
	private List<SystemParameter> systemParams;

	
	
	public SystemParametersBean() {
		super();
	}
	
	
	
	
	/**
	 * @return the systemParams
	 */
	public List<SystemParameter> getSystemParams() {
		if (null == systemParams) {
			systemParams = userSession.getSystemParameters();
		}
		return systemParams;
	}
	
	/**
	 * when save is clicked on the Set System Parameters screen
	 * @return
	 */
	public String saveSystemParams() {
		userSession.saveSystemParameters(systemParams);
		return "main";
	}
	
	/**
	 * when cancel is clicked on the Set System Parameters screen
	 * @return
	 */
	public String cancelSystemParams() {
		return "cancelLogin";
	}

}