package gov.va.fnod.view;

import gov.va.fnod.model.CaseLinkData;
import gov.va.fnod.model.fnoddata.SourceCaseTypeMap;
import gov.va.fnod.service.SourceCaseTypeMapSession;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.ejb.EJB;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.ViewScoped;
import javax.faces.model.SelectItem;

@ManagedBean(name = "sourceCaseTypeMap")
@ViewScoped
public class SourceCaseTypeMapBean implements Serializable {

	private static final long serialVersionUID = -7755477763068297146L;

	@EJB
	private SourceCaseTypeMapSession sourceCaseTypeMapSession;

	@ManagedProperty(value="#{caseBean}")
    private CaseBean caseBean;
	
	
	public SourceCaseTypeMapBean() {
		super();
	}
	
	
	public CaseBean getCaseBean() {
		return caseBean;
	}

	public void setCaseBean(CaseBean caseBean) {
		this.caseBean = caseBean;
	}

	public List<SourceCaseTypeMap> getSourceCaseTypeMapList() {
		return sourceCaseTypeMapSession.getSourceCaseTypeMapList();
	}

	public SourceCaseTypeMap getSourceCaseTypeMap() {
		return sourceCaseTypeMapSession.getSourceCaseTypeMap(caseBean.getCaseLink().getSourceSystem(), caseBean.getCaseLink().getCaseType());
	}
	
	/**
	 * get the list of all CaseData objects matching the SourcecaseTypeMap, assigned to the given user
	 * 
	 * @return
	 */
	public List<CaseLinkData> getCaseLinkData(SourceCaseTypeMap sourceCaseTypeMap, String username) {
		
		if(username != null)
			return sourceCaseTypeMapSession.getCaseLinkData2(sourceCaseTypeMap, username);
		else 
			return sourceCaseTypeMapSession.getCaseLinkDataAllUser(sourceCaseTypeMap);
			
	}
	
	/**
	 * get a select list of all SourceCaseTypeMap objects
	 * 
	 * @return
	 */
	public List<SelectItem> getSourceCaseTypeMapSelectList() {
		ArrayList<SelectItem> selectList = new ArrayList<SelectItem>();
		
		try {
			List<SourceCaseTypeMap> list = getSourceCaseTypeMapList();
			
			selectList.add(new SelectItem(null, "All"));
			
			for (int i = 0; i < list.size(); i++) {
				SourceCaseTypeMap item = list.get(i);
				selectList.add(new SelectItem(item));
			}
		}
		
		catch (Exception e) {
			e.printStackTrace();
		}
		
		return selectList;
	}
}