package gov.va.fnod.view;

import gov.va.fnod.business.CaseLinkValidator;
import gov.va.fnod.model.SearchFNODRecordsCriteria;
import gov.va.fnod.model.SearchFNODRecordsResult;
import gov.va.fnod.service.CaseSession;
import gov.va.fnod.service.SearchFNODRecordsSession;
import gov.va.fnod.util.JSFMessageUtil;

import java.io.Serializable;
import java.util.List;

import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.ViewScoped;
import javax.faces.model.SelectItem;

import org.apache.log4j.Logger;
import org.apache.myfaces.trinidad.component.UIXTable;
import org.apache.myfaces.trinidad.model.SortableModel;

@ManagedBean(name = "searchFnod")
@ViewScoped
public class SearchFNODRecordsBean implements Serializable {

	private static final long serialVersionUID = 2465545476866710287L;
	private Logger log = Logger.getLogger(SearchFNODRecordsBean.class);
	
	private static final String NO_RESULTS_RETURNED = null;
	private static final String SINGLE_RESULT_RETURNED = null;
	private static final String MULTIPLE_RESULTS_RETURNED = null;
	private static final String VALIDATION_ERRORS = null;
	
	@EJB
	SearchFNODRecordsSession searchDatabaseSession;
	
	@EJB
	CaseSession caseSession;
	
	@ManagedProperty(value="#{caseBean}")
    private CaseBean caseBean;
	
	@ManagedProperty(value="#{user}")
    private UserBean userBean;
	
	@ManagedProperty(value="#{caseLinkValidator}")
	CaseLinkValidator caseLinkValidator;
	
	@ManagedProperty(value="#{fnodRecordUsersBean}")
	private FnodRecordUsersBean fnodRecordUsersBean;
	
	private SearchFNODRecordsCriteria criteria;
	private List<SearchFNODRecordsResult> matchingFnodRecords;
	private SortableModel tableModel = new SortableModel();
	private UIXTable matchFnodRecordsTable;
	private boolean showCriteria;
	private SearchFNODRecordsResult selectedFnodRecord;
	private List<SelectItem> userSelectList;
	
	
	public SearchFNODRecordsBean() {
		super();
	}

	@PostConstruct
	public void init() {
		getUserSelectList();
	}
	
	
	
	
	public String search() {
		String result = null;
		
		// clear any previous results
		selectedFnodRecord = null;
		matchingFnodRecords = null;
		tableModel = null;
		
		try {
			if (validateSearch(criteria)) {
				
				matchingFnodRecords = searchDatabaseSession.searchDatabase(criteria);
				
				if (matchingFnodRecords == null || matchingFnodRecords.size() == 0) {
					JSFMessageUtil.addWarning("NORES-01", 
							"No Match.", 
							"No FNOD Records match the given criteria.");
					result = NO_RESULTS_RETURNED;
				}
				else if (matchingFnodRecords.size() == 1) {
					Long caseId = matchingFnodRecords.iterator().next().getCaseId();
					caseBean.loadCaseLink(caseId);
					selectedFnodRecord = matchingFnodRecords.iterator().next();
					result = SINGLE_RESULT_RETURNED;
				}
				else {
					result = MULTIPLE_RESULTS_RETURNED;
				}
			}
			else {
				result = VALIDATION_ERRORS;
			}
		}catch (Exception e) {
			log.error("The system is experiencing technical problems while trying to search FNOD records.", e);
			JSFMessageUtil.addError("SRCH-02", 
					"Error.", 
					"The system is experiencing technical problems while trying to search FNOD records.");
		}
		
		return result;
	}

	private boolean validateSearch(SearchFNODRecordsCriteria criteria) {
		boolean result = true;
		// ensure at least one field filled in
		if (criteria.getCaseId() == null 
				&& criteria.getFirstName() == null 
				&& criteria.getLastName() == null
				&& criteria.getMiddleName() == null
				&& criteria.getSuffixName() == null
				&& criteria.getBirthDate() == null
				&& criteria.getDeathDate() == null
				&& criteria.getFnodCreatedDate() == null
				&& criteria.getSocialSecurityNumber() == null
				&& criteria.getVeteranClaimNumber() == null
				&& criteria.getMilitaryServiceNumber() == null) {
			JSFMessageUtil.addError("SRCH-01", "Invalid Request!", "At least one criteria field must be supplied.");
			result = false;
		}

		return result;
	}

	/**
	 * If a single result was returned, go all the way back to criteria, if there were multiple results, go back to list
	 * @return
	 */
	public String cancelEdit() {
		String result;
		this.selectedFnodRecord = null;
		if (matchingFnodRecords.size() == 1) {
			matchingFnodRecords.clear();
			result = NO_RESULTS_RETURNED;
		}
		else {
			result = MULTIPLE_RESULTS_RETURNED;
		}
		caseBean.cancel();
		return result;
	}
	
	public String cancelList() {
		matchingFnodRecords.clear();
		return NO_RESULTS_RETURNED;
	}
	
	public String editFNODRecordForRow() {
		String username = userBean.getUsername();
		SearchFNODRecordsResult selectedFNOD = (SearchFNODRecordsResult) this.getMatchFnodRecordsTable().getSelectedRowData();
		
		if (selectedFNOD != null ) {
			Long caseId = selectedFNOD.getCaseId();
			this.setSelectedFnodRecord(selectedFNOD);
			boolean ok = true;
//			if( selectedFNOD.getLockedStatus().equalsIgnoreCase("PENDING")) { 
//				ok = caseSession.addFnodRecordForPendingCase(selectedFNOD.getCaseId(), username);
//			}
			if(ok) { 
				caseBean.loadCaseLink(caseId);
			}
		}
		return MULTIPLE_RESULTS_RETURNED;
	}
	
	public SearchFNODRecordsCriteria getCriteria() {
		if (criteria == null) {
			criteria = new SearchFNODRecordsCriteria();
		}
		return criteria;
	}

	public void setCriteria(SearchFNODRecordsCriteria criteria) {
		this.criteria = criteria;
	}

	public List<SearchFNODRecordsResult> getMatchingFnodRecords() {
		return matchingFnodRecords;
	}

	public void setMatchingFnodRecords(
			List<SearchFNODRecordsResult> matchingFnodRecords) {
		this.matchingFnodRecords = matchingFnodRecords;
	}

	public void showCriteriaSection() {
		this.showCriteria = true;
	}
	
	public boolean isShowCriteria() {
		return this.showCriteria;
	}

	public CaseBean getCaseBean() {
		return caseBean;
	}

	public void setCaseBean(CaseBean caseBean) {
		this.caseBean = caseBean;
	}

	public SearchFNODRecordsResult getSelectedFnodRecord() {
		return selectedFnodRecord;
	}

	public void setSelectedFnodRecord(SearchFNODRecordsResult selectedFnodRecord) {
		this.selectedFnodRecord = selectedFnodRecord;
	}

	public UIXTable getMatchFnodRecordsTable() {
		return matchFnodRecordsTable;
	}

	public void setMatchFnodRecordsTable(UIXTable matchFnodRecordsTable) {
		this.matchFnodRecordsTable = matchFnodRecordsTable;
	}
	
	public String cancel() {
		caseBean.cancel();
		return "main";
	}

	public List<SelectItem> getUserSelectList() {
		if (userSelectList == null) {
			String currentUser = userBean.getUser().getUsername();
			
			userSelectList = fnodRecordUsersBean.getFnodRecordUsers();
			String selectedUser=null;
			if ( userSelectList.size() > 0 ) {			
				for(int i=0; i < userSelectList.size() && selectedUser == null; i++) {
					if ( currentUser.equals(userSelectList.get(i).getLabel())) {
						selectedUser = currentUser;
					}
				}			
			} 
			//getCriteria().setSelectedUserName(selectedUser);
			
			userSelectList.add(0,new SelectItem(null,"ALL"));
		}
		return userSelectList;
	}

	public void setUserSelectList(List<SelectItem> userSelectList) {
		this.userSelectList = userSelectList;
	}

	public UserBean getUserBean() {
		return userBean;
	}

	public void setUserBean(UserBean userBean) {
		this.userBean = userBean;
	}

	
	public void save() {
		caseLinkValidator.setCreateMessages(true);
		
		boolean validated = caseLinkValidator.validateForComplete(caseBean.getCaseLink());		
		if (validated) {
			
			caseLinkValidator.setFnodFieldsForComplete(caseBean.getCaseLink());
			caseBean.saveAndReopen();
		}
		else {
			JSFMessageUtil.addError("SAV-01", "Fnod record NOT saved!", "Please correct the errors and try again.");
		}
	}

	public SortableModel getTableModel() {
		if (tableModel == null) {
			if (this.getMatchingFnodRecords() == null) {
				tableModel = new SortableModel();
			} 
			else {
				tableModel = new SortableModel(this.getMatchingFnodRecords());
			}
		}
		return tableModel;
	}

	public void setTableModel(SortableModel tableModel) {
		this.tableModel = tableModel;
	}
	
	public String getResultsMessage() {
		String message = null;
		if (tableModel == null) {
			message = "";
		}
		else if (tableModel.getRowCount() == SearchFNODRecordsSession.MAX_ROWS_TO_FETCH) {
			message = "Max of " + SearchFNODRecordsSession.MAX_ROWS_TO_FETCH + " records returned. There may be additional results. Please narrow your criteria to see more specific results."; 
		}
		else {
			message = "Search returned " + tableModel.getRowCount() + " records.";
		}
		
		return message;
	}

	public FnodRecordUsersBean getFnodRecordUsersBean() {
		return fnodRecordUsersBean;
	}

	public void setFnodRecordUsersBean(FnodRecordUsersBean fnodRecordUsersBean) {
		this.fnodRecordUsersBean = fnodRecordUsersBean;
	}

	public void setCaseLinkValidator(CaseLinkValidator caseLinkValidator) {
		this.caseLinkValidator = caseLinkValidator;
	}
}
