package gov.va.fnod.view;

import gov.va.fnod.model.FNODModelConstants;
import gov.va.fnod.model.SourceCaseType;
import gov.va.fnod.model.fnoddata.Region;
import gov.va.fnod.model.fnoddata.RegionalOffice;
import gov.va.fnod.model.fnoddata.SourceCaseTypeMap;
import gov.va.fnod.service.SourceCaseTypeMapSession;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.ViewScoped;
import javax.faces.model.SelectItem;

import org.apache.myfaces.trinidad.component.core.input.CoreSelectOneListbox;

@ManagedBean(name="sampleCriteria")
@ViewScoped
public class SampleCriteriaUI implements Serializable {
	
	private static final long serialVersionUID = 12702249825177L;
	
	private final static Long ALL_REGIONS = 0L;
	private Timestamp fromDate;
	private Timestamp toDate;
	private Long sourceSystemId;
	private Long caseTypeId;
	private Long regionId;
	private Long regionalOfficeId;
	private Integer maxRows;
	private Double samplePercent;
	private String selectedUserName;
	private List<SelectItem> userSelectList;
	private Long sourceCaseTypeMapId;
	
	@ManagedProperty(value = "#{lookup}")
	private LookupBean lookupBean;
	
	@ManagedProperty(value="#{user}")
    private UserBean userBean;
	
	@ManagedProperty(value="#{fnodRecordUsersBean}")
	private FnodRecordUsersBean fnodRecordUsersBean;
	
	@EJB
	private SourceCaseTypeMapSession sourceCaseTypeMapSession;
	
	private List<SelectItem> regions;// list of Regions
	private List<SelectItem> regionalOffices;// list of Regional Offices
	private List<SelectItem> sourceCaseTypeMapSelectItems;
	
	private CoreSelectOneListbox caseSourceListBox;
	private CoreSelectOneListbox regionListBox;
	private CoreSelectOneListbox regionalOfficeListBox;
	
	private List<RegionalOffice> regionalOfficeList;
	
	// Flag application search
	// criteria
	
	public SampleCriteriaUI() {
		super();
	}
	
	@PostConstruct
	public void init() {
		try {
			userSelectList = fnodRecordUsersBean.getFnodRecordUsers();
			String selectedUsername = (String)userSelectList.get(0).getValue();
			
			// if the current user is in the list, pre-select that user's user name
			if (userSelectList.size() > 1) {
				String currentUsername= userBean.getUser().getUsername();
				for (SelectItem item : userSelectList) {					
					String itemUserName = (String)item.getValue();
					if (currentUsername.equals(itemUserName)) {
						selectedUsername = itemUserName;
					}
				}
			}
			
			this.setSelectedUserName(selectedUsername);
			userSelectList.add(0,new SelectItem(null,"ALL"));
		}
				
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public SampleCriteriaUI(
			Timestamp fromDate, 
			Timestamp toDate, 
			Long sourceSystemId, 
			Long caseTypeId, 
			Long regionId, 
			Long regionalOfficeId, 
			int maxRows, 
			double samplePercent,
			String selectedUserName) { 
		
		this.fromDate = fromDate;
		this.toDate = toDate;
		this.sourceSystemId = sourceSystemId;
		this.caseTypeId = caseTypeId;
		this.regionId = regionId;
		this.regionalOfficeId = regionalOfficeId;
		this.maxRows = maxRows;
		this.samplePercent = samplePercent;
		this.selectedUserName = selectedUserName;
	}

	public Timestamp getFromDate() {
		return fromDate;
	}

	public void setFromDate(Timestamp fromDate) {
		this.fromDate = fromDate;
	}

	public Timestamp getToDate() {
		return toDate;
	}

	public void setToDate(Timestamp toDate) {
		this.toDate = toDate;
	}

	public Long getSourceSystemId() {
		return sourceSystemId;
	}

	public void setSourceSystemId(Long sourceSystemId) {
		this.sourceSystemId = sourceSystemId;
	}

	public Long getCaseTypeId() {
		return caseTypeId;
	}

	public void setCaseTypeId(Long caseTypeId) {
		this.caseTypeId = caseTypeId;
	}

	public Long getRegionId() {
		return regionId;
	}

	public void setRegionId(Long regionId) {
		this.regionId = regionId;
	}

	public Long getRegionalOfficeId() {
		return regionalOfficeId;
	}

	public void setRegionalOfficeId(Long regionalOfficeId) {
		this.regionalOfficeId = regionalOfficeId;
	}

	public Integer getMaxRows() {
		return maxRows;
	}

	public void setMaxRows(Integer maxRows) {
		this.maxRows = maxRows;
	}

	public Double getSamplePercent() {
		return samplePercent;
	}

	public void setSamplePercent(Double samplePercent) {
		this.samplePercent = samplePercent;
	}

	public String getSelectedUserName() {
		return selectedUserName;
	}

	public void setSelectedUserName(String selectedUserName) {
		this.selectedUserName = selectedUserName;
	}

	public List<SelectItem> getUserSelectList() {
		return userSelectList;
	}

	public void setUserSelectList(List<SelectItem> userSelectList) {
		this.userSelectList = userSelectList;
	}

	public Long getSourceCaseTypeMapId() {
		return sourceCaseTypeMapId;
	}

	public void setSourceCaseTypeMapId(Long sourceCaseTypeMapId) {
		this.sourceCaseTypeMapId = sourceCaseTypeMapId;
	}

		
	
	public LookupBean getLookupBean() {
		return lookupBean;
	}

	public void setLookupBean(LookupBean lookupBean) {
		this.lookupBean = lookupBean;
	}




	public UserBean getUserBean() {
		return userBean;
	}

	public void setUserBean(UserBean userBean) {
		this.userBean = userBean;
	}

	/**
	 * get the list of Regions
	 * 
	 * @return the regions
	 */
	public List<SelectItem> getRegions() {
		if (null == regions) {
			List<Region> regionList = lookupBean.getRegions();
			if (regionList != null) {
				regions = new ArrayList<SelectItem>();
				regions.add(new SelectItem(0, FNODModelConstants.SELECT_ALL));
				for (Region reg : regionList) {
					regions.add(new SelectItem(reg.getRegionId(), reg
							.getDescription()));
				}
			}
		}
		return regions;
	}

	/**
	 * get the list of Regional Offices
	 * 
	 * @return the regionalOffices
	 */
	public List<SelectItem> getRegionalOffices() {
		if (getLoadedRegionalOffices() != null) {
			regionalOffices = new ArrayList<SelectItem>();
			regionalOffices.add(new SelectItem(ALL_REGIONS,
					FNODModelConstants.SELECT_ALL));
			
			for (RegionalOffice regOffice : getLoadedRegionalOffices()) {
				Long officeRegion = regOffice.getRegion().getRegionId();
				if (ALL_REGIONS.equals(this.regionId) || officeRegion.equals(this.regionId)) {
					regionalOffices.add(new SelectItem(regOffice
							.getRegionalOfficeId(), regOffice
							.getRegionalOfficeName()));
				}
			}
		}
		return regionalOffices;
	}
	
	private List<RegionalOffice> getLoadedRegionalOffices() {
		if (regionalOfficeList == null) {
			regionalOfficeList = lookupBean.getRegionalOffices(0);
		}
		return regionalOfficeList;
	}

	public boolean isDisplayFlagAppSearchCriteria() {
		Long flagAppId = SourceCaseType.FLAG_APPLICATION.getSourceCaseTypeId();
		return flagAppId.equals(sourceCaseTypeMapId);
	}

	public List<SelectItem> getSourceCaseTypeMapSelectList() {
		if (sourceCaseTypeMapSelectItems == null) {
			sourceCaseTypeMapSelectItems = new ArrayList<SelectItem>();
			for (SourceCaseTypeMap s : getSourceCaseTypeMapList()) {
				sourceCaseTypeMapSelectItems.add(new SelectItem(s.getSourceCaseTypeMapId(), s.getDescription()));
			}
		}
		return sourceCaseTypeMapSelectItems;
	}
	
	public List<SourceCaseTypeMap> getSourceCaseTypeMapList() {
		return sourceCaseTypeMapSession.getSourceCaseTypeMapList();
	}

	public org.apache.myfaces.trinidad.component.core.input.CoreSelectOneListbox getCaseSourceListBox() {
		return caseSourceListBox;
	}

	public void setCaseSourceListBox(
			org.apache.myfaces.trinidad.component.core.input.CoreSelectOneListbox caseSourceListBox) {
		this.caseSourceListBox = caseSourceListBox;
	}

	public org.apache.myfaces.trinidad.component.core.input.CoreSelectOneListbox getRegionListBox() {
		return regionListBox;
	}

	public void setRegionListBox(
			org.apache.myfaces.trinidad.component.core.input.CoreSelectOneListbox regionListBox) {
		this.regionListBox = regionListBox;
	}

	public org.apache.myfaces.trinidad.component.core.input.CoreSelectOneListbox getRegionalOfficeListBox() {
		return regionalOfficeListBox;
	}

	public void setRegionalOfficeListBox(
			org.apache.myfaces.trinidad.component.core.input.CoreSelectOneListbox regionalOfficeListBox) {
		this.regionalOfficeListBox = regionalOfficeListBox;
	}

	public FnodRecordUsersBean getFnodRecordUsersBean() {
		return fnodRecordUsersBean;
	}

	public void setFnodRecordUsersBean(FnodRecordUsersBean fnodRecordUsersBean) {
		this.fnodRecordUsersBean = fnodRecordUsersBean;
	}
	
	
}

