package gov.va.fnod.view;

import gov.va.fnod.model.CaseLinkData;
import gov.va.fnod.model.UserPrivilege;
import gov.va.fnod.model.fnoddata.ActivityTypeCode;
import gov.va.fnod.model.fnoddata.AppUser;
import gov.va.fnod.model.fnoddata.FnodRecord;
import gov.va.fnod.model.fnoddata.SourceCaseTypeMap;
import gov.va.fnod.security.exception.AccountLockedException;
import gov.va.fnod.service.CaseSession;
import gov.va.fnod.service.UserAuthorizationSession;
import gov.va.fnod.util.FNODConstants;
import gov.va.fnod.util.FNODEJBConstants;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.ViewScoped;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;

import org.apache.myfaces.trinidad.component.UIXTable;
import org.apache.myfaces.trinidad.component.core.input.CoreSelectBooleanCheckbox;
import org.apache.myfaces.trinidad.model.SortableModel;

@ManagedBean(name = "parkingLotController")
@ViewScoped
public class ParkingLotControllerBean implements Serializable {
	
	private static final long serialVersionUID = -1116034770161952153L;

	@EJB
	private CaseSession caseSession;
	
	@EJB
	private UserAuthorizationSession userAuthorization;

	@ManagedProperty(value="#{caseBean}")
    private CaseBean caseBean;
	
	@ManagedProperty(value="#{user}")
    private UserBean userBean;
	
	@ManagedProperty(value="#{sourceCaseTypeMap}")
    private SourceCaseTypeMapBean sourceCaseTypeMapBean;
	
	private List<SelectItem> sourceCaseTypeMapSelectList;
	private List<SelectItem> userSelectList;
	private List<SelectItem> userReassignList;
	private SourceCaseTypeMap sourceCaseTypeMap;
	private AppUser selectedUser;
	private AppUser assignedUser;
	private List<CaseLinkData> caseLinkData;
	private UIXTable table;
	private UIComponent editButton;
	private CoreSelectBooleanCheckbox showReassignCheckbox;
	private SortableModel tableModel = null;
	
	public ParkingLotControllerBean() {
		super();
	}
	
	@PostConstruct
	public void init() {
		try {
			sourceCaseTypeMapSelectList = sourceCaseTypeMapBean.getSourceCaseTypeMapSelectList();
			SelectItem selectItem = (SelectItem)sourceCaseTypeMapSelectList.get(0);
			sourceCaseTypeMap = (SourceCaseTypeMap)selectItem.getValue();
			
			userSelectList = userBean.getParkingLotAppUserSelectList();
			selectItem = (SelectItem)userSelectList.get(0);
			if (userSelectList.size() > 1) {
				for (SelectItem item : userSelectList) {
					AppUser currentUser = userBean.getUser();
					AppUser itemUser = (AppUser)item.getValue();
					if (currentUser.equals(itemUser)) {
						selectItem = item;
					}
				}
			}
			selectedUser = (AppUser)selectItem.getValue();
			assignedUser = selectedUser;
			
			userReassignList = userBean.getAppUserSelectListNoAll();
		}
		
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public CaseSession getCaseSession() {
		return caseSession;
	}

	public void setCaseSession(CaseSession caseSession) {
		this.caseSession = caseSession;
	}
	
	public CaseBean getCaseBean() {
		return caseBean;
	}

	public void setCaseBean(CaseBean caseBean) {
		this.caseBean = caseBean;
	}
	
	public UserBean getUserBean() {
		return userBean;
	}

	public void setUserBean(UserBean userBean) {
		this.userBean = userBean;
	}
	
	public SourceCaseTypeMapBean getSourceCaseTypeMapBean() {
		return sourceCaseTypeMapBean;
	}

	public void setSourceCaseTypeMapBean(SourceCaseTypeMapBean sourceCaseTypeMapBean) {
		this.sourceCaseTypeMapBean = sourceCaseTypeMapBean;
	}

	public List<SelectItem> getSourceCaseTypeMapSelectList() {
		return sourceCaseTypeMapSelectList;
	}

	public void setSourceCaseTypeMapSelectList(
			List<SelectItem> sourceCaseTypeMapSelectList) {
		this.sourceCaseTypeMapSelectList = sourceCaseTypeMapSelectList;
	}

	public List<SelectItem> getUserSelectList() {
		return userSelectList;
	}

	public void setUserSelectList(List<SelectItem> userSelectList) {
		this.userSelectList = userSelectList;
	}

	public List<SelectItem> getUserReassignList() {
		return userReassignList;
	}

	public void setUserReassignList(List<SelectItem> userReassignList) {
		this.userReassignList = userReassignList;
	}

	public SourceCaseTypeMap getSourceCaseTypeMap() {
		return sourceCaseTypeMap;
	}

	public void setSourceCaseTypeMap(SourceCaseTypeMap sourceCaseTypeMap) {
		this.sourceCaseTypeMap = sourceCaseTypeMap;
	}
	
	public AppUser getSelectedUser() {
		return selectedUser;
	}

	public void setSelectedUser(AppUser selectedUser) {
		this.selectedUser = selectedUser;
	}

	public AppUser getAssignedUser() {
		return assignedUser;
	}

	public void setAssignedUser(AppUser assignedUser) {
		this.assignedUser = assignedUser;
	}

	public List<CaseLinkData> getCaseLinkData() {
		String username = null;
		
		if(selectedUser != null)
			 username = selectedUser.getUsername();
		
		caseLinkData = sourceCaseTypeMapBean.getCaseLinkData(sourceCaseTypeMap, username);
		return caseLinkData;
	}
	
	public void setTable(UIXTable table) {
		this.table = table;
	}
	
	public UIXTable getTable() { 
		return table;
	}
	
	public void setEditButton(UIComponent editButton) {
		this.editButton = editButton;
	}      
	
	public UIComponent getEditButton() {
		return editButton;
	}
	
	public void search() {
		this.tableModel = null;
	}
	
	public String editAction() {
		try {
			UIXTable table = getTable();
			Iterator<Object> selection = table.getSelectedRowKeys().iterator();
			Object oldKey = table.getRowKey();
		  
			if (selection.hasNext()) {
				Object rowKey = selection.next();
				table.setRowKey(rowKey);
				
				CaseLinkData caseLinkData = (CaseLinkData) table.getRowData();
				caseBean.loadCaseLink(caseLinkData.getCaseId());				
			}
			else {
				FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, "Validation Error!", "A case must be selected before clicking the Edit button");             
				FacesContext context = FacesContext.getCurrentInstance();             
				context.addMessage(editButton.getClientId(context), message);
				return null;
			}
			
			// restore the old key:
			table.setRowKey(oldKey);
		}
		
		catch (Exception e) {
			e.printStackTrace();
		}
		
		return FNODConstants.ACTION_FNOD_RECORD_FROM_PARKING_LOT;
	}
	
	public boolean isReassignDisplayed() {
		try {
			return userAuthorization
					.isUserAuthorized(userBean.getUserContext(),
							userAuthorization.createSystemContext("ParkingLotPriv",
									UserPrivilege.ASSIGN_CASE));
		} catch (AccountLockedException ex) {
			return false;
		}
	}
	
	public String reassign() {
		try {
			UIXTable table = getTable();
			Iterator<Object> selection = table.getSelectedRowKeys().iterator();
			Object oldKey = table.getRowKey();
		  
			if (selection.hasNext()) {
				Object rowKey = selection.next();
				table.setRowKey(rowKey);
				
				CaseLinkData caseLinkData = (CaseLinkData) table.getRowData();
				
				// Open the case for processing
				caseBean.loadCaseLink(caseLinkData.getCaseId());
				
				// Set the activity code
				caseBean.setCurActivityTypeCode(ActivityTypeCode.ASSIGNED);
				
				// Reassign the assigned user using the caseBean instance of caseLink
				FnodRecord fnodRecord = caseBean.getCaseLink().getFnodRecord();
				fnodRecord.setUsername(assignedUser.getUsername());
				
				// Save change
				caseBean.saveCaseLink();
				
				// hide the reassign section on the page
				this.getShowReassignCheckbox().setValue(Boolean.FALSE);
			}
			else {
				String messageString = "A case must be selected before clicking the Reassign button";
				FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, "Validation Error!", messageString);             
				FacesContext context = FacesContext.getCurrentInstance();             
				context.addMessage(editButton.getClientId(context), message);
				return null;
			}
			
			// restore the old key:
			table.setRowKey(oldKey);
		}
		
		catch (Exception e) {
			e.printStackTrace();
		}
		
		return FNODConstants.ACTION_PARKING_LOT;
	}
	
	public boolean isShowReassignSection() {
		return showReassignCheckbox.getValue() == Boolean.TRUE;
	}

	public CoreSelectBooleanCheckbox getShowReassignCheckbox() {
		return showReassignCheckbox;
	}

	public void setShowReassignCheckbox(
			CoreSelectBooleanCheckbox showReassignCheckbox) {
		this.showReassignCheckbox = showReassignCheckbox;
	}

	public SortableModel getTableModel() {
		if (tableModel == null) {
			tableModel = new SortableModel(this.getCaseLinkData());
		}
		return tableModel;
	}

	public void setTableModel(SortableModel tableModel) {
		this.tableModel = tableModel;
	}
}