package gov.va.fnod.view;

import gov.va.fnod.model.SampleItem;
import gov.va.fnod.model.UserPrivilege;
import gov.va.fnod.security.exception.AccountLockedException;
import gov.va.fnod.service.UserAuthorizationSession;
import gov.va.fnod.util.JSFUtil;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.ejb.EJB;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.RequestScoped;

@ManagedBean(name = "mainController")
@RequestScoped
public class MainControllerBean implements Serializable {

	private static final long serialVersionUID = 551432120240035369L;
	private static final Logger logr = Logger
			.getLogger(MainControllerBean.class.getName());

	@ManagedProperty(value = "#{caseBean}")
	private CaseBean caseBean;

	@ManagedProperty(value = "#{user}")
	private UserBean userBean;

	@EJB
	UserAuthorizationSession userAuthorizationBean;
	
	public MainControllerBean() {
		super();
	}

	public CaseBean getCaseBean() {
		return caseBean;
	}

	public void setCaseBean(CaseBean caseBean) {
		this.caseBean = caseBean;
	}

	public UserBean getUserBean() {
		return userBean;
	}

	public void setUserBean(UserBean userBean) {
		this.userBean = userBean;
	}

	public boolean isProcessCaseDisplayed() {
		return answerPrivQ(UserPrivilege.PROCESS_CASE);
	}

	public boolean isParkingLotDisplayed() {
		return answerPrivQ(UserPrivilege.PROCESS_CASE);
	}

	public boolean isViewAggregateCountsDisplayed() {
		return answerPrivQ(UserPrivilege.ASSIGN_CASE);
	}

	public boolean isReportsDisplayed() {
		return answerPrivQ(UserPrivilege.RUN_USER_REPORT)
				|| answerPrivQ(UserPrivilege.RUN_REPORT);
	}

	public boolean isUserProfileDisplayed() {
		return answerPrivQ(UserPrivilege.LOGIN);
	}

	public boolean isAwardAuditDisplayed() {
		return answerPrivQ(UserPrivilege.EXECUTE_AUDIT);
	}

	public boolean isSamplePendingCasesDisplayed() {
		return answerPrivQ(UserPrivilege.EXECUTE_AUDIT);
	}

	public boolean isSampleCompletedCasesDisplayed() {
		return answerPrivQ(UserPrivilege.EXECUTE_AUDIT);
	}

	public boolean isSearchDatabaseDisplayed() {
		return answerPrivQ(UserPrivilege.PROCESS_CASE);
	}

	private boolean answerPrivQ(UserPrivilege... privileges) {
		try {
			logr.log(Level.FINE, "UserProfilePrivQuestions: {0}", privileges);
			return userAuthorizationBean.isUserAuthorized(this.userBean
					.getUserContext(),
					userAuthorizationBean.createSystemContext(
							"UserProfilePrivQuestions", privileges));
		} catch (AccountLockedException ex) {
			logr.log(Level.WARNING, "UserProfilePrivQuestions: {0}",
					ex.getMessage());
			return false;
		}
	}
	
	public String samplePendingCasesCriteriaAction() {
		caseBean.setSampleItem(new SampleItem());		
		return "samplePendingCasesCriteria";
	}
	
	public String sampleCompletedCasesCriteriaAction() {
		caseBean.setSampleItem(new SampleItem());
		return "sampleCompletedCasesCriteria";
	}
	
	public String awardAuditAction() {
		caseBean.setSampleItem(new SampleItem());
		SampleBean sampleBean = (SampleBean)JSFUtil.resolveExpression("#{sample}", SampleBean.class);
		return sampleBean.nextLoadedAuditCase(); 				
	}
	
}