package gov.va.fnod.view;

/**
 * ManagedBean used for lookup values
 */
import gov.va.fnod.model.fnoddata.Region;
import gov.va.fnod.model.fnoddata.RegionalOffice;
import gov.va.fnod.model.fnoddata.SourceCaseTypeMap;
import gov.va.fnod.service.LookupSession;
import gov.va.fnod.service.SourceCaseTypeMapSession;

import java.io.Serializable;
import java.util.List;

import javax.ejb.EJB;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;

@ManagedBean(name = "lookup")
@SessionScoped
public class LookupBean implements Serializable {

	private static final long serialVersionUID = 2184563749084548529L;
	
	@EJB
	private SourceCaseTypeMapSession sourceCaseTypeMapSession;
	
	@EJB
	private LookupSession lookupSession;

	List<SourceCaseTypeMap> sourceCaseTypeMap;// values for displaying Source
												// Case Type
	List<Region> regions;// values for displaying Regions
	List<RegionalOffice> regionalOffices;// values for displaying Regional
											// Offices

	public LookupBean() {
		super();
	}
	
	
	/**
	 * get Source Case Type
	 * 
	 * @return
	 */
	public List<SourceCaseTypeMap> getSourceCaseTypeMap() {
		if (null == sourceCaseTypeMap) {
			sourceCaseTypeMap = sourceCaseTypeMapSession.getSourceCaseTypeMapList();
		}
		return sourceCaseTypeMap;
	}

	public SourceCaseTypeMapSession getSourceCaseTypeMapSession() {
		return sourceCaseTypeMapSession;
	}

	public void setSourceCaseTypeMapSession(SourceCaseTypeMapSession sourceCaseTypeMapSession) {
		this.sourceCaseTypeMapSession = sourceCaseTypeMapSession;
	}

	public LookupSession getLookupSession() {
		return lookupSession;
	}

	public void setLookupSession(LookupSession lookupSession) {
		this.lookupSession = lookupSession;
	}

	/**
	 * get Regions
	 * 
	 * @return
	 */
	public List<Region> getRegions() {
		if (null == regions) {
			regions = lookupSession.getRegions();
		}
		return regions;
	}

	/**
	 * get Regional Offices given a Region Id
	 * 
	 * @param regionId
	 * @return
	 */
	public List<RegionalOffice> getRegionalOffices(long regionId) {
		regionalOffices = lookupSession.getRegionalOffices(regionId);
		return regionalOffices;
	}

	public List<RegionalOffice> getRegionalOffices() {
		regionalOffices = lookupSession.getRegionalOffices();
		return regionalOffices;
	}
	
	public Long getRegionIdForRegionalOfficeId(Long regionalOfficeId) {
		Long regionId = 0L;
		if (regionalOfficeId != null && regionalOfficeId != 0) {
			for (RegionalOffice off : getRegionalOffices()) {
				if (regionalOfficeId == off.getRegionalOfficeId()) {
					regionId = off.getRegion().getRegionId();
					break;
				}
			}
		}
		return regionId;
	}
}
