package gov.va.fnod.view;

import gov.va.fnod.model.fnoddata.CaseAttachment;
import gov.va.fnod.model.fnoddata.CaseLink;
import gov.va.fnod.service.LookupSession;
import gov.va.fnod.service.SourceCaseTypeMapSession;
import gov.va.fnod.util.FileCacheBean;

public interface FnodReportDataSupplierInterface {

	public abstract LookupSession getLookupSession();

	public abstract UserBean getUser();

	public abstract Long getCaseId();

	public abstract boolean isFlagApp();

	public abstract boolean isAmas();

	public abstract boolean isBoss();
	
	public abstract boolean isAnc();

	public abstract boolean isFnod();

	public abstract boolean isFnodSpouse();
	
	public abstract boolean isEligibilityVerifiedDisabled();

	public abstract boolean isComplete();

	public abstract String getCaseType();

	public abstract CaseLink getCaseLink();

	public abstract String getFlagAppFileName();

	public abstract String fetchAttachmentDocument(CaseAttachment attachment);

	public abstract String fetchFromDocumentStorage(Long docStorageId);

	public FileCacheBean getFilecache();

	public AttachmentHelper getAttachmentHelper();
	
	public SourceCaseTypeMapSession getSourceCaseTypeMapSession();
}