package gov.va.fnod.view;

import gov.va.cem.docstorage.service.DocumentStorageSession;
import gov.va.fnod.business.CaseLinkValidator;
import gov.va.fnod.business.FnodRecordPdfProcessBean;
import gov.va.fnod.model.fnoddata.AttachmentType;
import gov.va.fnod.model.fnoddata.CaseAttachment;
import gov.va.fnod.model.fnoddata.CaseLink;
import gov.va.fnod.model.fnoddata.FnodRecord;
import gov.va.fnod.model.fnoddata.LockedStatus;
import gov.va.fnod.model.fnoddata.RegionalOffice;
import gov.va.fnod.service.CaseSession;
import gov.va.fnod.service.LookupSession;
import gov.va.fnod.util.FNODConstants;
import gov.va.fnod.util.FileCacheBean;
import gov.va.fnod.util.JSFMessageUtil;
import gov.va.fnod.util.JSFUtil;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.ViewScoped;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;
import org.apache.myfaces.trinidad.component.UIXTable;
import org.apache.myfaces.trinidad.component.core.input.CoreSelectBooleanCheckbox;
import org.apache.myfaces.trinidad.model.UploadedFile;

@ManagedBean(name = "fnodController")
@ViewScoped
public class FnodControllerBean implements Serializable {
  private static final long serialVersionUID = 4493137179029189260L;

	private final static Logger log = Logger.getLogger(FnodControllerBean.class);
	
	private static final String FNOD_DELETED = "FNOD_DELETED";
	private static final String DELETE_FAILED = "DELETE_FAILED";
	
	private static final String COMPLETE_VALIDATION_FAILED = "COMPLETE_VALIDATION_FAILED";
	private static final String COMPLETE_VALIDATION_SUCCEEDED = "COMPLETE_VALIDATION_SUCCEEDED";
	
	private static final String PARK_VALIDATION_FAILED = "PARK_VALIDATION_FAILED";
	private static final String PARK_VALIDATION_SUCCEEDED = "PARK_VALIDATION_SUCCEEDED";
	
	@EJB
	private CaseSession caseSession;

	@EJB
	private LookupSession lookupSession;

	@EJB
	private DocumentStorageSession documentStorageSession;
	
	@ManagedProperty(value="#{caseBean}")
    private CaseBean caseBean;
	
	@ManagedProperty(value="#{caseLinkValidator}")
	CaseLinkValidator caseLinkValidator;
	
	@ManagedProperty(value="#{user}")
    private UserBean user;
	
	@ManagedProperty(value="#{userProfile}")
    private UserProfileBean userProfile;
	
	@ManagedProperty(value="#{filecache}")
    private FileCacheBean filecache;
	
	// bound UI components
	private UIXTable attachmentTable;
	
	private CoreSelectBooleanCheckbox benefitCancelledCheckbox;
	private CoreSelectBooleanCheckbox flagIssuedCheckbox;
	private CoreSelectBooleanCheckbox pmcCheckbox;
	private CoreSelectBooleanCheckbox tooOldCheckbox;
	private CoreSelectBooleanCheckbox nmiCheckbox;
	private CoreSelectBooleanCheckbox fnodCheckbox;
	private CoreSelectBooleanCheckbox birlsAddCheckbox;
	private CoreSelectBooleanCheckbox birlsUpdateCheckbox;
	private CoreSelectBooleanCheckbox eligibilityVerificationCheckbox;
	private CoreSelectBooleanCheckbox dodAlreadyPresentCheckbox;
	
	private CoreSelectBooleanCheckbox irisCheckbox;
	private CoreSelectBooleanCheckbox nisCheckbox;
	private CoreSelectBooleanCheckbox sensitiveCheckbox;
	private CoreSelectBooleanCheckbox folderOnlyBenefitCheckbox;
	
	private String attachmentFileName;
	private String numberOfAttachments;
	private String filecacheFileName;
	private AttachmentType attachmentType;
	private String attachmentComments;
	private UploadedFile attachmentFile;
	private CaseAttachment caseAttachment;
	private boolean attachmentViewableNow = false;
	private boolean showingAddAttachmentForm = false;
	private String attachmentURL = null;		
	private boolean displayPrint = false;
	
	private String fnodReportFilename;
	
	public FnodControllerBean() {
		super();
	}
	
	@PostConstruct
	public void init() {
		try {
			SelectItem selectItem = null;
			
			List<SelectItem> list = getAttachmentTypeSelectList();
			if (list.size() > 0) {
				selectItem = list.get(0);
				attachmentType = (AttachmentType)selectItem.getValue();
			}
			
			list = getCaseAttachmentSelectList();
			if (list.size() > 0) {
				selectItem = list.get(0);
				caseAttachment = (CaseAttachment)selectItem.getValue();
			}
		}
		
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public String getNumberOfAttachments() { 
		numberOfAttachments = "(";
		int num = (caseBean.getCaseLink().getCaseAttachments() == null || caseBean.getCaseLink().getCaseAttachments().isEmpty()) ? 0 : caseBean.getCaseLink().getCaseAttachments().size();
		numberOfAttachments += num + ")";
		return numberOfAttachments;
	}
	
	
	public CaseSession getCaseSession() {
		return caseSession;
	}

	public void setCaseSession(CaseSession caseSession) {
		this.caseSession = caseSession;
	}

	public LookupSession getLookupSession() {
		return lookupSession;
	}

	public void setLookupSession(LookupSession lookupSession) {
		this.lookupSession = lookupSession;
	}

	public DocumentStorageSession getDocumentStorageSession() {
		return documentStorageSession;
	}

	public void setDocumentStorageSession(
			DocumentStorageSession documentStorageSession) {
		this.documentStorageSession = documentStorageSession;
	}
	
	//------------------------------------------------

	public CaseBean getCaseBean() {
		return caseBean;
	}

	public void setCaseBean(CaseBean caseBean) {
		this.caseBean = caseBean;
	}
	
	public UserBean getUser() {
		return user;
	}

	public void setUser(UserBean user) {
		this.user = user;
	}

	public UserProfileBean getUserProfile() {
		return userProfile;
	}

	public void setUserProfile(UserProfileBean userProfile) {
		this.userProfile = userProfile;
	}

	public FileCacheBean getFilecache() {
		return filecache;
	}

	public void setFilecache(FileCacheBean filecache) {
		this.filecache = filecache;
	}

	//------------------------------------------------

	public List<SelectItem> getRegionalOfficeSelectList() {
		List<SelectItem> selectList = new ArrayList<SelectItem>();
		
		try {
			List<RegionalOffice> list = lookupSession.getRegionalOffices();
			for (int i = 0; i < list.size(); i++) {
				RegionalOffice item = list.get(i);
				selectList.add(new SelectItem(item));
			}
		}
		
		catch (Exception e) {
			e.printStackTrace();
		}
		
		return selectList;
	}
	
	//------------------------------------------------

	public String getAttachmentFileName() {
		return attachmentFileName;
	}

	public void setAttachmentFileName(String attachmentFileName) {
		this.attachmentFileName = attachmentFileName;
	}
	
	public String getFilecacheFileName() {
		return filecacheFileName;
	}

	public void setFilecacheFileName(String filecacheFileName) {
		this.filecacheFileName = filecacheFileName;
	}
	
	public String getAttachmentDisplayFileName() {
		return "/showReport/" + filecacheFileName;
	}

	public AttachmentType getAttachmentType() {
		return attachmentType;
	}

	public void setAttachmentType(AttachmentType attachmentType) {
		this.attachmentType = attachmentType;
	}

	public String getAttachmentComments() {
		return attachmentComments;
	}

	public void setAttachmentComments(String attachmentComments) {
		this.attachmentComments = attachmentComments;
	}

	public UploadedFile getAttachmentFile() {
		return attachmentFile;
	}

	public void setAttachmentFile(UploadedFile attachmentFile) {
		this.attachmentFile = attachmentFile;
	}

	public CaseAttachment getCaseAttachment() {
		return caseAttachment;
	}

	public void setCaseAttachment(CaseAttachment caseAttachment) {
		this.caseAttachment = caseAttachment;
	}

	public boolean isAttachmentViewable() {
		if (caseAttachment != null && caseAttachment.getAttachmentType().getDescription().equalsIgnoreCase(FNODConstants.VIEWABLE_ATTACHMENT_TYPE)) {
			return true;
		}
		else {
			return false;
		}
	}

	public boolean isAttachmentViewableNow() {
		if (isAttachmentViewable()) {
			return attachmentViewableNow;
		}
		else {
			return false;
		}
	}

	public List<SelectItem> getAttachmentTypeSelectList() {
		List<SelectItem> selectList = new ArrayList<SelectItem>();
		
		try {
			List<AttachmentType> list = lookupSession.getAttachmentTypes();
			
			for (int i = 0; i < list.size(); i++) {
				AttachmentType item = list.get(i);
				selectList.add(new SelectItem(item));
			}
		}
		
		catch (Exception e) {
			e.printStackTrace();
		}
		
		return selectList;
	}
	
	public List<SelectItem> getCaseAttachmentSelectList() {
		
		List<SelectItem> selectList = new ArrayList<SelectItem>();
		
		try {
			CaseLink caseLink = caseBean.getCaseLink();
			if (caseLink != null) {
				List<CaseAttachment> list = caseLink.getCaseAttachments();
				for (int i = 0; i < list.size(); i++) {
					CaseAttachment item = list.get(i);
					selectList.add(new SelectItem(item));
				}
			}
		}
		
		catch (Exception e) {
			e.printStackTrace();
		}
		
		return selectList;
	}
	
	private void clearAttachmentUploadForm() {
		attachmentFileName = null;
		filecacheFileName = null;
		attachmentType = null;
		attachmentComments = null;
		attachmentFile = null;
		caseAttachment = null;
		
		// duplicate what we do in init() in order to prevent null attachment types.
		SelectItem selectItem = null;		
		List<SelectItem> list = getAttachmentTypeSelectList();
		if (list.size() > 0) {
			selectItem = list.get(0);
			attachmentType = (AttachmentType)selectItem.getValue();
		}
	}
	
	public void attachAttachment() {
		try {
			if (attachmentFile == null) {
				JSFMessageUtil.addError("FLD-01", "Missing Required Field!", "Attachment File required.");
			}
			else if (attachmentType == null) {
				JSFMessageUtil.addError("FLD-04", "Missing Required Field!", "Attachment Type required.");
			}
			else {
		    	String filecacheFileName = filecache.addToCache(attachmentFile.getInputStream(), attachmentFileName);
		    	String filecacheFilePath = filecache.getFilePath(filecacheFileName);
		    	
		    	try {
		    		assertIsPDF(filecacheFilePath);
		    	} catch (Exception e) {
		    		filecache.removeFromCache(filecacheFileName);
		    	}
		    	
		    	CaseAttachment caseAttachment = new CaseAttachment(attachmentType, user.getUsername(), new Date(), attachmentFileName, attachmentComments);
		    	caseBean.addAttachment(caseAttachment, filecacheFileName);
		    	
		    	clearAttachmentUploadForm();
		    	showingAddAttachmentForm = false;
		    }
		}		
		catch (Exception e) {
			JSFMessageUtil.addError("ATCH-01", "Attachment Cancelled!", "An error occurred while trying to process your file attachment operation: add.");
			log.error("ATCH-01: An error occurred while trying to process your file attachment operation: add.", e);
		}
	}
	
	// TODO Check exception flow, not sure it complete/accurate
	private void assertIsPDF(String filePath) {
		FileInputStream fos = null;
		try {
			fos = new FileInputStream(filePath);
			byte[] bytes = new byte[4];
			fos.read(bytes);
			String firstFourBytesAsString = new String(bytes);
			if (!"%PDF".equals(firstFourBytesAsString)) {
				JSFMessageUtil.addError("FILE-02", "Wrong File Type!", "Error validating the format of the attachment file.  Only PDF files are permitted as attachments.");
				throw new IllegalArgumentException("The attached file does not appear to be of type PDF.");				
			}
		}
		catch (IOException ex) {
			JSFMessageUtil.addError("FILE-01", "Error reading file.", "Error validating the format of the attachment file");
		}
		finally {			
			if (fos != null) {
				try {fos.close();} catch (IOException e) {/* do nothing */}
			}
		}
	}
	
	public void viewAttachment() {
		try {
			if (this.getAttachmentTable().getSelectedRowData() == null) {
				JSFMessageUtil.addError("FLD-02", "Selection Required!", "Please select an attachment to view.");
			}
			else {
				caseAttachment = (CaseAttachment) this.getAttachmentTable().getSelectedRowData();
				filecacheFileName = caseBean.fetchAttachmentDocument(caseAttachment);
					
				attachmentViewableNow = true;
				HttpServletRequest request = (HttpServletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
				String attachmentURL = request.getContextPath() + "/showReport/" + filecacheFileName;
				this.attachmentURL = attachmentURL;
		    }
		}
		catch (Exception e) {
			JSFMessageUtil.addError("ATCH-02", "Attachment Error!", "An error occurred while trying to process your file attachment operation: view.");
			log.error("ATCH-02: An error occurred while trying to process your file attachment operation: view.", e);
		}
	}
	
	public void deleteAttachment() {
		try {
			if (this.getAttachmentTable().getSelectedRowData() == null) {
				JSFMessageUtil.addError("FLD-03", "Selection Required!", "Please select an attachment to delete.");
			}
			else {
				// Remove the attachment from the application
				caseAttachment = (CaseAttachment) this.getAttachmentTable().getSelectedRowData();
				caseBean.deleteAttachment(caseAttachment);								
		    }
		}
		catch (Exception e) {
			JSFMessageUtil.addError("ATCH-03", "Attachment Error!", "An error occurred while trying to process your file attachment operation: delete.");
			log.error("ATCH-02: An error occurred while trying to process your file attachment operation: delete.", e);
		}
	}
	
	public boolean isCaseDataDisplayed() {
		return caseBean.getCaseLink().getCaseData() != null;
	}
	
	public boolean isCaseFlagApplicationDisplayed() {
		return caseBean.getCaseLink().getCaseFlagApp() != null;
	}

	public UIXTable getAttachmentTable() {
		return attachmentTable;
	}

	public void setAttachmentTable(UIXTable attachmentTable) {
		this.attachmentTable = attachmentTable;
	}

	public void showAddAttachmentForm() {
		showingAddAttachmentForm = !showingAddAttachmentForm;
	}
	
	public boolean isCaseInsuranceDisplayed() {
		return caseBean.getCaseLink().getCaseInsurance()!= null;
	}
	
	public boolean isShowingAddAttachmentForm() {
		return showingAddAttachmentForm;
	}

	public void setShowingAddAttachmentForm(boolean showingAddAttachmentForm) {
		this.showingAddAttachmentForm = showingAddAttachmentForm;
	}

	public String getAttachmentURL() {
		return attachmentURL;
	}

	public void setAttachmentURL(String attachmentURL) {
		this.attachmentURL = attachmentURL;
	}
	
	public String hideAttachment() {
		this.attachmentURL = null;
		return null;
	}
	
	public String deleteFnod() {
		String result;
		long caseId = this.getCaseBean().getCaseLink().getCaseId();
		if (this.getCaseBean().isFnodQualifiedForDeletion() && user.isSupervisor()) {
			this.getCaseBean().getCaseLink().setLockedStatus(LockedStatus.DELETED);
			this.getCaseBean().saveCaseLink();
			JSFMessageUtil.addInfo("DEL-00", 
					"FNOD Deleted!", 
					"The FNOD record was deleted for Case #" + caseId);
			result = FNOD_DELETED;
		}
		else {
			JSFMessageUtil.addError("DEL-01", 
					"The FNOD record deletion failed!", 
					"Only Supervisors can delete FNODs that are Flag Applications and that have not been completed.");

			result = DELETE_FAILED;
		}
		return result;
	}
	
	public void pdfPrint() {
		try {
			FnodRecordPdfProcessBean pdf = new FnodRecordPdfProcessBean(caseBean);
			InputStream input = pdf.generateFnodRecordReport();
			fnodReportFilename = filecache.addToCache(input, "pdf");
		} catch (Exception ex) {
			JSFMessageUtil.addError("FRE-01", "Failed to generate fnod report", ex.getMessage());
			return;
		}
		setDisplayPrint(true);	
	}		
	
	public void pdfPrintBack() {
		filecache.removeFromCache(fnodReportFilename);
		fnodReportFilename = null;
		setDisplayPrint(false);	
	}
	
	public String getFnodReportName() {
		return fnodReportFilename;
	}
	
	public String cancel() {
		caseBean.cancel();
		return "main";
	}	
	
	public boolean isDisplayPrint() {
		return displayPrint;	
	}	
	
	public void setDisplayPrint(boolean displayPrint) {
		this.displayPrint = displayPrint;	
	}

	public String getFnodReportFilename() {
		return fnodReportFilename;
	}

	public void setFnodReportFilename(String fnodReportFilename) {
		this.fnodReportFilename = fnodReportFilename;
	}
	
	
	public boolean isNmiSelected() {
		return "Y".equals(caseBean.getCaseLink().getFnodRecord().getNmi());
	}
	
	public boolean isTooOldToCreate() {
		return "Y".equals(caseBean.getCaseLink().getFnodRecord().getTooOldToCreate());
	}
	
	public String complete() {
		
		processCheckboxValues();
		boolean validated = validateCheckboxes();
		if(validated) { 
			caseLinkValidator.setCreateMessages(true);
			caseLinkValidator.setUser(user);
			validated = caseLinkValidator.validateForComplete(caseBean.getCaseLink());
			if (validated) {
				JSFMessageUtil.addInfo("PRK-03", "Completed!", "Case Successfully Completed!");
	
				caseLinkValidator.setFnodFieldsForComplete(caseBean.getCaseLink());
				caseBean.getCaseLink().setLockedStatus(LockedStatus.COMPLETE);
				caseBean.getCaseLink().getFnodRecord().setFnodCreatedDt(new Timestamp(System.currentTimeMillis()));
				
				caseBean.saveCaseLink();
			}
			else {
				JSFMessageUtil.addWarning("PRK-04", "Cancelled.", "Case Completion Cancelled.");
			}
		} 
		return validated ? COMPLETE_VALIDATION_SUCCEEDED : COMPLETE_VALIDATION_FAILED;
	}
	
	public String completeAndNext() {
		String result = complete();
		if (COMPLETE_VALIDATION_SUCCEEDED.equals(result)) {
			ProcessCaseBean processCaseBean = (ProcessCaseBean) JSFUtil.resolveExpression("#{processCase}", ProcessCaseBean.class);
			processCaseBean.setSearchCriteria(caseBean.getSearchCriteria());
			result = processCaseBean.searchCase();
		}
		return result;
	}
	
	
	public String parkAndNext() {
		String result = park();
		if (PARK_VALIDATION_SUCCEEDED.equals(result)) {
			ProcessCaseBean processCaseBean = (ProcessCaseBean) JSFUtil.resolveExpression("#{processCase}", ProcessCaseBean.class); 
			processCaseBean.setSearchCriteria(caseBean.getSearchCriteria());
			result = processCaseBean.searchCase();
		}
		return result;
	}
	
	public String park() {
		processCheckboxValues();
		boolean validated = validateCheckboxes();
		if(validated) { 
			caseLinkValidator.setCreateMessages(true);
			caseLinkValidator.setUser(user);
			 validated = caseLinkValidator.validateForPark(caseBean.getCaseLink());
			if (validated) {
				if (! LockedStatus.COMPLETE.equals(caseBean.getCaseLink().getLockedStatus())) {
					JSFMessageUtil.addInfo("PRK-01", "Success!", "Case Successfully Parked!");
					caseBean.getCaseLink().setLockedStatus(LockedStatus.PARKED);
				}
				else {
					JSFMessageUtil.addWarning("LCK-01", "Status cannot be changed to 'PARKED'.",
							"Once a case has been completed, it may not be marked as 'PARKED'.");
				}
				if (caseBean.getCaseLink().getFnodRecord().getCaseLockedDt() == null) {
					caseBean.getCaseLink().getFnodRecord().setCaseLockedDt(new Timestamp(System.currentTimeMillis()));
				}
				this.caseBean.saveCaseLink();
			}
			else {
				JSFMessageUtil.addInfo("PRK-02", "Validation Failed!", "Case still parked, but changes not saved!");
			}
		}
		
		return validated ? PARK_VALIDATION_SUCCEEDED : PARK_VALIDATION_FAILED;
	}
	
	private boolean validateCheckboxes() { 
		boolean ok = validateNisAndSensitiveCheckBoxValues();;
		if(ok) { 
			ok = validateDodAndBenefitCheckBoxValues();
			if(ok) { 
				ok = validateIrisAndBenefitCheckBoxValues();
				if(!ok) { 
					JSFMessageUtil.addWarning("NIS-SEN-01", FNODConstants.WARN_IRIS_BENEFIT_CHECKBOX_SUMMARY, FNODConstants.WARN_IRIS_BENEFIT_CHECKBOX_TXT);
				}
				
			}else { 
				JSFMessageUtil.addWarning("NIS-SEN-02", FNODConstants.WARN_DOD_BENEFIT_CHECKBOX_SUMMARY, FNODConstants.WARN_DOD_BENEFIT_CHECKBOX_TXT);
			}
			
			
		}else { 
			JSFMessageUtil.addWarning("NIS-SEN-03", FNODConstants.WARN_NIS_SENSITIVE_CHECKBOX_SUMMARY, FNODConstants.WARN_NIS_SENSITIVE_CHECKBOX_TXT);
		}
		
		
		return ok;
	}

	private boolean validateNisAndSensitiveCheckBoxValues() {
		boolean ok = true;
		
		FnodRecord fnodRecord = caseBean.getCaseLink().getFnodRecord();
		if(FNODConstants.Y.equals(fnodRecord.getNis()) && FNODConstants.Y.equals(fnodRecord.getSensitive()) ) { 
			ok = false;
		}
		return ok;
	}
	
	private boolean validateDodAndBenefitCheckBoxValues() {
		boolean ok = true;
		
		FnodRecord fnodRecord = caseBean.getCaseLink().getFnodRecord();
		if(FNODConstants.Y.equals(fnodRecord.getDodAlreadyPresent()) && FNODConstants.Y.equals(fnodRecord.getBenefitCancelled()) ) { 
			ok = false;
		}
		return ok;
	}
	
	private boolean validateIrisAndBenefitCheckBoxValues() {
		boolean ok = true;
		
		FnodRecord fnodRecord = caseBean.getCaseLink().getFnodRecord();
		if(fnodRecord.getCaseLink().getCaseType().getDescription().contains(FNODConstants.SPOUSE)) { 
			if(FNODConstants.Y.equals(fnodRecord.getIris()) && !FNODConstants.Y.equals(fnodRecord.getBenefitCancelled()) ) { 
				ok = false;
			}
		}
		return ok;
	}
	
	private void processCheckboxValues() {
		FnodRecord fnodRecord = caseBean.getCaseLink().getFnodRecord();
		fnodRecord.setBenefitCancelled(businessCorrectValue(benefitCancelledCheckbox));
		fnodRecord.setFlagIssued(businessCorrectValue(flagIssuedCheckbox));
		fnodRecord.setPmc(businessCorrectValue(pmcCheckbox));
		fnodRecord.setTooOldToCreate(businessCorrectValue(tooOldCheckbox));
		fnodRecord.setNmi(businessCorrectValue(nmiCheckbox));
		fnodRecord.setFnod(businessCorrectValue(fnodCheckbox));
		fnodRecord.setBirlsAdd(businessCorrectValue(birlsAddCheckbox));
		fnodRecord.setBirlsUpdate(businessCorrectValue(birlsUpdateCheckbox));
		//fnodRecord.setEligibilityVerification(businessCorrectValue(eligibilityVerificationCheckbox));
		fnodRecord.setDodAlreadyPresent(businessCorrectValue(dodAlreadyPresentCheckbox));
		
		fnodRecord.setIris(businessCorrectValue(irisCheckbox));
		fnodRecord.setNis(businessCorrectValue(nisCheckbox));
		fnodRecord.setSensitive(businessCorrectValue(sensitiveCheckbox));
		fnodRecord.setFolderOnlyBenefit(businessCorrectValue(folderOnlyBenefitCheckbox));
	}
	
	/**
	 * This method returns the value that is represented by a check-box given the following rules
	 * 
	 * 		1)  A checked value always returns "Y"
	 * 		2)  An unchecked enabled box returns a value of "N"
	 * 		3)  An unchecked disabled box returns a value of null
	 * 
	 * @return the business-correct value of the given check-box.
	 */
	private String businessCorrectValue(CoreSelectBooleanCheckbox checkbox) {
		String result = null;
		if ("Y".equals(checkbox.getValue())) {
			result = "Y";
		}
		else if (!checkbox.isDisabled()) {
			result = "N";
		}
		return result;
	}
	
	public CoreSelectBooleanCheckbox getBenefitCancelledCheckbox() {
		return benefitCancelledCheckbox;
	}

	public void setBenefitCancelledCheckbox(
			CoreSelectBooleanCheckbox benefitCancelledCheckbox) {
		this.benefitCancelledCheckbox = benefitCancelledCheckbox;
	}

	public CoreSelectBooleanCheckbox getFlagIssuedCheckbox() {
		return flagIssuedCheckbox;
	}

	public void setFlagIssuedCheckbox(CoreSelectBooleanCheckbox flagIssuedCheckbox) {
		this.flagIssuedCheckbox = flagIssuedCheckbox;
	}

	public CoreSelectBooleanCheckbox getPmcCheckbox() {
		return pmcCheckbox;
	}

	public void setPmcCheckbox(CoreSelectBooleanCheckbox pmcCheckbox) {
		this.pmcCheckbox = pmcCheckbox;
	}

	public CoreSelectBooleanCheckbox getTooOldCheckbox() {
		return tooOldCheckbox;
	}

	public void setTooOldCheckbox(CoreSelectBooleanCheckbox tooOldCheckbox) {
		this.tooOldCheckbox = tooOldCheckbox;
	}

	public CoreSelectBooleanCheckbox getNmiCheckbox() {
		return nmiCheckbox;
	}

	public void setNmiCheckbox(CoreSelectBooleanCheckbox nmiCheckbox) {
		this.nmiCheckbox = nmiCheckbox;
	}

	public CoreSelectBooleanCheckbox getFnodCheckbox() {
		return fnodCheckbox;
	}

	public void setFnodCheckbox(CoreSelectBooleanCheckbox fnodCheckbox) {
		this.fnodCheckbox = fnodCheckbox;
	}

	public CoreSelectBooleanCheckbox getBirlsAddCheckbox() {
		return birlsAddCheckbox;
	}

	public void setBirlsAddCheckbox(CoreSelectBooleanCheckbox birlsAddCheckbox) {
		this.birlsAddCheckbox = birlsAddCheckbox;
	}

	public CoreSelectBooleanCheckbox getBirlsUpdateCheckbox() {
		return birlsUpdateCheckbox;
	}

	public void setBirlsUpdateCheckbox(CoreSelectBooleanCheckbox birlsUpdateCheckbox) {
		this.birlsUpdateCheckbox = birlsUpdateCheckbox;
	}

	public CoreSelectBooleanCheckbox getEligibilityVerificationCheckbox() {
		return eligibilityVerificationCheckbox;
	}

	public void setEligibilityVerificationCheckbox(
			CoreSelectBooleanCheckbox eligibilityVerificationCheckbox) {
		this.eligibilityVerificationCheckbox = eligibilityVerificationCheckbox;
	}

	public CoreSelectBooleanCheckbox getDodAlreadyPresentCheckbox() {
		return dodAlreadyPresentCheckbox;
	}

	public void setDodAlreadyPresentCheckbox(
			CoreSelectBooleanCheckbox dodAlreadyPresentCheckbox) {
		this.dodAlreadyPresentCheckbox = dodAlreadyPresentCheckbox;
	}

	public CoreSelectBooleanCheckbox getIrisCheckbox() {
		return irisCheckbox;
	}

	public void setIrisCheckbox(CoreSelectBooleanCheckbox irisCheckbox) {
		this.irisCheckbox = irisCheckbox;
	}

	public CoreSelectBooleanCheckbox getNisCheckbox() {
		return nisCheckbox;
	}

	public void setNisCheckbox(CoreSelectBooleanCheckbox nisCheckbox) {
		this.nisCheckbox = nisCheckbox;
	}

	public CoreSelectBooleanCheckbox getSensitiveCheckbox() {
		return sensitiveCheckbox;
	}

	public void setSensitiveCheckbox(CoreSelectBooleanCheckbox sensitiveCheckbox) {
		this.sensitiveCheckbox = sensitiveCheckbox;
	}

	public CoreSelectBooleanCheckbox getFolderOnlyBenefitCheckbox() {
		return folderOnlyBenefitCheckbox;
	}

	public void setFolderOnlyBenefitCheckbox(
			CoreSelectBooleanCheckbox folderOnlyBenefitCheckbox) {
		this.folderOnlyBenefitCheckbox = folderOnlyBenefitCheckbox;
	}

	public CaseLinkValidator getCaseLinkValidator() {
		return caseLinkValidator;
	}

	public void setCaseLinkValidator(CaseLinkValidator caseLinkValidator) {
		this.caseLinkValidator = caseLinkValidator;
	}

	public void setNumberOfAttachments(String numberOfAttachments) {
		this.numberOfAttachments = numberOfAttachments;
	}

	public void setAttachmentViewableNow(boolean attachmentViewableNow) {
		this.attachmentViewableNow = attachmentViewableNow;
	}
	
	
}