package gov.va.fnod.view;

import gov.va.cem.docstorage.service.DocumentStorageSession;
import gov.va.fnod.service.CaseSession;
import gov.va.fnod.util.FNODConstants;
import gov.va.fnod.util.FileCacheBean;

import java.io.File;
import java.io.Serializable;

import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.ViewScoped;

@ManagedBean(name = "flagAppController")
@ViewScoped
public class CaseFlagAppControllerBean implements Serializable {
	
	private static final long serialVersionUID = -7220604751527709889L;

	@EJB
	private CaseSession caseSession;
	
	@EJB
	private DocumentStorageSession documentStorageSession;
	
	@ManagedProperty(value="#{caseBean}")
    private CaseBean caseBean;
	
	@ManagedProperty(value="#{filecache}")
    private FileCacheBean filecache;
	
	private String flagAppFileName = "FlagApp";
	private String filecacheFileName;
	
	public CaseFlagAppControllerBean() {
		super();
	}
	
	@PostConstruct
	public void init() {
		try {
			viewFlagApp();
		}
		
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public CaseSession getCaseSession() {
		return caseSession;
	}

	public void setCaseSession(CaseSession caseSession) {
		this.caseSession = caseSession;
	}

	public DocumentStorageSession getDocumentStorageSession() {
		return documentStorageSession;
	}

	public void setDocumentStorageSession(
			DocumentStorageSession documentStorageSession) {
		this.documentStorageSession = documentStorageSession;
	}
	
	//------------------------------------------------

	public CaseBean getCaseBean() {
		return caseBean;
	}

	public void setCaseBean(CaseBean caseBean) {
		this.caseBean = caseBean;
	}

	public FileCacheBean getFilecache() {
		return filecache;
	}

	public void setFilecache(FileCacheBean filecache) {
		this.filecache = filecache;
	}
	
	//------------------------------------------------

	public String getFlagAppFileName() {
		return flagAppFileName;
	}

	public void setFlagAppFileName(String flagAppFileName) {
		this.flagAppFileName = flagAppFileName;
	}
	
	public String getFilecacheFileName() {
		return filecacheFileName;
	}

	public void setFilecacheFileName(String filecacheFileName) {
		this.filecacheFileName = filecacheFileName;
	}
	
	public String getFlagAppDisplayFileName() {
		return "/showReport/" + filecacheFileName;
	}
	
	public void viewFlagApp() {
		try {
			if (caseBean.getCaseLink().getCaseFlagApp() != null) {
				String filecacheFilePath = filecache.createCacheFilePath(getFlagAppFileName());
				File attachmentFile = new File(filecacheFilePath);
				filecacheFileName = attachmentFile.getName();
		    	documentStorageSession.getDocument(FNODConstants.SYSTEM_NAME, caseBean.getCaseLink().getCaseFlagApp().getDocStorageId(), filecacheFilePath);
		    }
		}
		
		catch (Exception e) {
			e.printStackTrace();
		}
	}
}