package gov.va.fnod.view;



import gov.va.fnod.model.fnoddata.CaseAttachment;



import java.io.Serializable;



/**

 * This class exists to assist in tracking adds and deletes of

 * case attachments during a user session and supports having

 * the edit session of an FNOD Record behave as a single document.

 * That is to say that all add/deletes of attachment and edits

 * of the FNOD Record values behave as a single transaction.

 */

public class AttachmentWrapper implements Serializable {

	

	private static final long serialVersionUID = 6568787891959231625L;

	

	private CaseAttachment attachment;

	private AttachmentAction action;

	private String cacheId;

	

	/**

	 * 

	 * @param attachment

	 * @param action

	 */

	public AttachmentWrapper(CaseAttachment attachment, AttachmentAction action ) {

		

		if ( attachment == null ) {

			throw new IllegalArgumentException("attachment is required");

		}		

		this.attachment = attachment;



		this.setAction(action);	

	}

	

	/**

	 * 

	 * @param attachment

	 * @param action

	 * @param cacheId

	 */

	public AttachmentWrapper(CaseAttachment attachment, AttachmentAction action, String cacheId ) {

		this(attachment,action);

		this.cacheId = cacheId;

	}



	/**

	 * 

	 * @return

	 */

	public CaseAttachment getAttachment() {

		return attachment;

	}



	public AttachmentAction getAction() {

		return action;

	}

	

	/**

	 * Sets the action property which cannot be null.  If a null

	 * value is passed an IllegalArgumentExcpetion will be thrown.

	 * <p />

	 * This value is allowed to be changed to allow for the handling of

	 * items that are added and deleted in the same transaction.

	 * 

	 * @param action

	 * @throws IllegalArgumentException is value is null.

	 */

	public void setAction(AttachmentAction action) {

		if ( action == null ) {

			throw new IllegalArgumentException("action is required");

		}

		this.action = action;

	}



	public String getCacheId() {

		return cacheId;

	}



	

	/**

	 * Equals for the wrapper is based on the wrapped CaseAttachment

	 * object being the same instance of the object. 

	 */

	@Override

	public boolean equals(Object obj) {

		

		// Don't change this without checking AttachmentHelper.locateAttachment

		

		boolean retval = false;

		

		if ( obj instanceof AttachmentWrapper ) {

			AttachmentWrapper wrapper = (AttachmentWrapper)obj;

			retval = (attachment == wrapper.attachment);

		}

		

		return retval;

	}

	

	@Override

	public int hashCode() {

		return this.attachment.hashCode();

	}

	

}

