package gov.va.fnod.view;



/**

 * This enum define different action that can be taken with

 * attachments.  

 */

public enum AttachmentAction {

	/**

	 * Indicate a document is being added to the case,

	 * and subsequently to document storage.

	 */

	ADD,

	

	/**

	 * A deleted document is being deleted from the case, and 

	 * may or may not have been saved to document storage.

	 */

	DELETE,

	

	/**

	 * To fetch the document, the document must have already have been

	 * saved to document storage, and was pulled into the file cache.

	 * This action requires the file cache object to be deleted when

	 * no longer in use.  This operation is not valid for something

	 * that is in a delete or add state.

	 */

	FETCH

}

