package gov.va.fnod.view;

import gov.va.fnod.model.app.AggregateCountItem;
import gov.va.fnod.service.AggregateCountsSession;
import gov.va.fnod.util.JSFMessageUtil;

import java.io.Serializable;
import java.util.List;

import javax.ejb.EJB;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ViewScoped;
import javax.faces.context.FacesContext;

import org.apache.log4j.Logger;
import org.apache.myfaces.trinidad.component.core.data.CoreTable;

@ManagedBean(name="aggregateCounts")
@ViewScoped
public class AggregateCountsBean implements Serializable {
	
	private static final long serialVersionUID = -5683264250500665260L;
	
	public static final Integer FLAG_APP_ID = 5;
	
	@EJB
	AggregateCountsSession aggregateCountsSession;
	
	List<AggregateCountItem> summaryRows = null;
	List<AggregateCountItem> auditSummaryRows = null;
	CoreTable summaryTable;
	String region;
	String regionalOffice;
	String sourceCaseTypeMapId;

	private List<AggregateCountItem> flagAppsByRegionalOffice = null;

	private List<AggregateCountItem> flagAppsByRegion = null;
	
	private List<AggregateCountItem> flagAppsByDate = null;

	private List<AggregateCountItem> drillDownAggregates = null;
	
	private List<AggregateCountItem> drillDownAwardAuditAggregates = null;
	
	
	
	
	public AggregateCountsBean() {
		super();
	}

	public List<AggregateCountItem> getAuditSummaryRows() {
		if (auditSummaryRows == null) {
			loadAuditSummaryRows();
		}
		return auditSummaryRows;
	}

	public void setAuditSummaryRows(List<AggregateCountItem> auditSummaryRows) {
		this.auditSummaryRows = auditSummaryRows;
	}
	
	protected void loadAuditSummaryRows() {
		if (auditSummaryRows != null) {
			auditSummaryRows.clear();
		}
		auditSummaryRows = aggregateCountsSession.getAwardAuditPendingSummary();
	}
	
	public List<AggregateCountItem> getSummaryRows() {
		if (summaryRows == null) {
			loadSummaryRows();
		}
		return summaryRows;
	}

	public void setSummaryRows(List<AggregateCountItem> summaryRows) {
		this.summaryRows = summaryRows;
	}
	
	/**
	 * Loads the rows from the result set into summaryRows as AggregateCountRow objects.
	 */
	protected void loadSummaryRows() {
		if (summaryRows != null) {
			summaryRows.clear();
		}
		summaryRows = aggregateCountsSession.getAggregateCountSummary();
	}

	public List<AggregateCountItem> getDrillDownRows() {
		if (flagAppsByRegionalOffice == null) {
			Object idParam = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("id");
			
			if (idParam != null) {
				if (idParam.toString().length() > 1) {
					throw new SecurityException("Invalid input parameter.");
				}
				Integer id = Integer.parseInt(idParam.toString());
				
				drillDownAggregates = aggregateCountsSession.getAggregateCountDetail(id);
			}
		}
		return drillDownAggregates;
	}
	public List<AggregateCountItem> getDrillDownAwardAuditRows() {
		if (flagAppsByRegionalOffice == null) {
			Object idParam = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("id");
			
			if (idParam != null) {
				if (idParam.toString().length() > 1) {
					throw new SecurityException("Invalid input parameter.");
				}
				Integer id = Integer.parseInt(idParam.toString());
				
				drillDownAwardAuditAggregates = aggregateCountsSession.getAggregateCountAwardAuditDetail(id);
			}
		}
		return drillDownAwardAuditAggregates;
	}
	
	
	/**
	 * Loads the flag apps by region
	 * @return
	 */
	public List<AggregateCountItem> getFlagAppByRegion() {
		if (flagAppsByRegionalOffice == null) {
			flagAppsByRegion = aggregateCountsSession.getAggregateCountFlagAppByRegion();
		}
		return flagAppsByRegion;
	}
	
	/**
	 * Loads the flag apps by regional office for a particular region
	 * @return
	 */
	public List<AggregateCountItem> getFlagAppByRegionalOffice() {
		if (flagAppsByRegionalOffice == null) {
			String regionParam = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("region");
			
			// though redundant, this is put in to support back-navigation via the cancel button on the next page.
			if (regionParam == null) {
				Logger.getLogger(this.getClass()).debug("Using back-navigation region set using '<f:setPropertyActionListener>'!!");
				regionParam = this.region;
			}
			
			Integer region = Integer.parseInt(regionParam);
			flagAppsByRegionalOffice = aggregateCountsSession.getAggregateCountFlagAppByRegionalOffice(region);
		}
		return flagAppsByRegionalOffice;
	}

	
	public List<AggregateCountItem> getFlagAppByDate() {
		if (flagAppsByDate == null) {
			String sourceCaseTypeMapId = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("id");
			String region = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("region");
			String regionalOffice = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get("regionalOffice");
			
			region = region == null ? this.region : region;
			regionalOffice = regionalOffice == null ? this.regionalOffice : regionalOffice;
			sourceCaseTypeMapId = sourceCaseTypeMapId == null ? this.sourceCaseTypeMapId : sourceCaseTypeMapId;
			
			if (region == null){
				JSFMessageUtil.addError("PARM-02", "Invalid Request!", "Required parameter, 'region' missing.");
			}
			
			if (regionalOffice == null) {
				JSFMessageUtil.addError("PARM-03", "Invalid Request!", "Required parameter, 'regionalOffice' missing.");
			}
			
			if (sourceCaseTypeMapId == null){
				JSFMessageUtil.addError("PARM-04", "Invalid Request!", "Required parameter, 'sourceCaseTypeMapId' missing.");
			}
			
			System.err.println("Region: " + region + " Regional Office: " + regionalOffice + " Source Case Type Map: " + sourceCaseTypeMapId);
			flagAppsByDate = aggregateCountsSession.getAggregateCountFlagAppByDate(Integer.parseInt(region), Integer.parseInt(regionalOffice));
		}
		return flagAppsByDate;
	}
	
	


	public String getRegion() {
		return region;
	}

	public void setRegion(String region) {
		this.region = region;
	}

	public String getRegionalOffice() {
		return regionalOffice;
	}

	public void setRegionalOffice(String regionalOffice) {
		this.regionalOffice = regionalOffice;
	}

	public String getSourceCaseTypeMapId() {
		return sourceCaseTypeMapId;
	}

	public void setSourceCaseTypeMapId(String sourceCaseTypeMapId) {
		this.sourceCaseTypeMapId = sourceCaseTypeMapId;
	}
	
	
}
