package gov.va.fnod.util;

import java.util.Iterator;

import javax.faces.application.FacesMessage;
import javax.faces.application.FacesMessage.Severity;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.RequestScoped;
import javax.faces.context.FacesContext;

@ManagedBean(name="msgHelper")
@RequestScoped
public class MessagesHelperBean {	
		
	@ManagedProperty(value="#{jsfMsgPageFlowHelper}")
	private JsfMsgPageFlowHelper jsfMsgPageFlowHelper;
	
	public boolean isMessagePresent() {
		
		jsfMsgPageFlowHelper.pushMessages();
		boolean msgs = (FacesContext.getCurrentInstance().getMessages() != null);
		
		return msgs;
	}
	
	public boolean isInfoPresent() {
		return levelPresent(FacesMessage.SEVERITY_INFO);
	}
	
	public boolean isWarnPresent() {
		return levelPresent(FacesMessage.SEVERITY_WARN);
	}
	
	public boolean isErrorPresent() {
		return levelPresent(FacesMessage.SEVERITY_ERROR);
	}
	
	public boolean isFatalPresent() {
		return levelPresent(FacesMessage.SEVERITY_FATAL);
	}
	
	private boolean levelPresent(Severity severity) {
		boolean result = false;
		Iterator<FacesMessage> messages = FacesContext.getCurrentInstance().getMessages();
		while (messages.hasNext()) {
			FacesMessage m = messages.next();
			if (severity.equals(m.getSeverity())) {
				result = true;
				break;
			}
		}
		return result;
	}
	
	public String testMessages() {
		JSFMessageUtil.addInfo("INFO-01", "Info Summary!", "This is the info detail!");
		JSFMessageUtil.addWarning("WARN-01", "Warn Summary!", "This is the warning detail!");
		JSFMessageUtil.addError("ERR-01", "Error Summary!", "This is the error detail!");
		JSFMessageUtil.addFatal("FAT-01", "Fatal Summary!", "This is the fatal detail!");
		return null;
	}
	
	public void setJsfMsgPageFlowHelper(JsfMsgPageFlowHelper value) {
		jsfMsgPageFlowHelper = value;
	}
	
	public JsfMsgPageFlowHelper getJsfMsgPageFlowHelper(JsfMsgPageFlowHelper value) {
		return jsfMsgPageFlowHelper;
	}

	public String getClearPageFlowMessages() {
		jsfMsgPageFlowHelper.releaseMessages();
		return "";
	}	
	
}
