package gov.va.fnod.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.RequestScoped;
import javax.faces.context.FacesContext;

@ManagedBean(name = "jsfMsgPageFlowHelper")
@RequestScoped
public class JsfMsgPageFlowHelper {

	private static final String JSF_MSG_PAGEFLOW = "JSF_MSG_PAGEFLOW";

	private List<JSFMessageCarrier> messages = null;

	public void pushMessages() {
		for (JSFMessageCarrier msg : getMessages()) {
			FacesContext.getCurrentInstance().addMessage(msg.getMsgId(),
					msg.getMsg());
		}
	}

	public void addInfoMsg(String msgId, String summary, String detail) {
		forceSessionBean();
		getMessages().add(
				new JSFMessageCarrier(msgId, new FacesMessage(
						FacesMessage.SEVERITY_INFO, summary, summary
								.equals(detail) ? "" : detail)));
	}

	public void addWarningMsg(String msgId, String summary, String detail) {
		forceSessionBean();
		getMessages().add(
				new JSFMessageCarrier(msgId, new FacesMessage(
						FacesMessage.SEVERITY_WARN, summary, summary
								.equals(detail) ? "" : detail)));
	}

	public void addErrorMsg(String msgId, String summary, String detail) {
		forceSessionBean();
		getMessages().add(
				new JSFMessageCarrier(msgId, new FacesMessage(
						FacesMessage.SEVERITY_ERROR, summary, summary
								.equals(detail) ? "" : detail)));
	}

	public void addFatalMsg(String msgId, String summary, String detail) {
		forceSessionBean();
		getMessages().add(
				new JSFMessageCarrier(msgId, new FacesMessage(
						FacesMessage.SEVERITY_FATAL, summary, summary
								.equals(detail) ? "" : detail)));
	}

	@SuppressWarnings("unchecked")
	private synchronized List<JSFMessageCarrier> getMessages() {

		List<JSFMessageCarrier> retval = messages;

		if (retval == null) {
			// try to get it from session context
			Map<String, Object> sessionMap = FacesContext.getCurrentInstance()
					.getExternalContext().getSessionMap();

			retval = (List<JSFMessageCarrier>) sessionMap.get(JSF_MSG_PAGEFLOW);

			// if its not there, return an empty list
			if (retval == null) {
				retval = Collections.emptyList();
			} else {
				messages = retval;
			}
		}
		return retval;
	}

	private synchronized void forceSessionBean() {
		if (messages == null) {
			messages = new ArrayList<JSFMessageCarrier>();
			Map<String, Object> sessionMap = FacesContext.getCurrentInstance()
					.getExternalContext().getSessionMap();
			sessionMap.put(JSF_MSG_PAGEFLOW, messages);
		}
	}

	public synchronized void releaseMessages() {
		messages = null;
		Map<String, Object> sessionMap = FacesContext.getCurrentInstance()
				.getExternalContext().getSessionMap();
		sessionMap.remove(JSF_MSG_PAGEFLOW);
	}
}