package gov.va.fnod.util;

import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;

public class JSFUtil {
	
	/**
	 * Use this method when the EL object you are trying to access is a JSF ManagedBean, otherwise, the bean will
	 * not be auto-created for you.  Using the other methods, will only find the bean if it exists, but you don't get
	 * the 'injection' behavior typical to JSF bean expressions.
	 */
	public static <T> Object resolveExpression(String expression, Class<T> classObj) {

        if(expression == null)
        {
            return null;
        }

        javax.faces.context.FacesContext facesCtx = FacesContext.getCurrentInstance();
        Application app = facesCtx.getApplication();

        try 
        {
            T result = (T) app.evaluateExpressionGet(facesCtx, expression, classObj);

            return result;
        } 
        catch (ELException ex) {
        }

        return null;
    }
	
	
	/**
	 * This method allows us to easily resolve an EL expression to an object in Java code.
	 * @param expression
	 * @return
	 */
	public static String resolveStringExpression(String expression) {

        if(expression == null)
        {
            return null;
        }

        javax.faces.context.FacesContext facesCtx = FacesContext.getCurrentInstance();
        Application app = facesCtx.getApplication();

        try 
        {
            ELContext elCtx = facesCtx.getELContext();
            ExpressionFactory ef = app.getExpressionFactory();
            ValueExpression ve = ef.createValueExpression(elCtx, expression, String.class);

            return (String) ve.getValue(elCtx);
        } 
        catch (ELException ex) {
        }

        return expression;
    }
	
}
