package gov.va.fnod.util;

import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;

/**
 * This class is designed to make it easier for appication programmers to add appropriate messages to their
 * responses to be disaplayed to the user.
 *
 * @author jhodge
 */
public class JSFMessageUtil {

    /**
     * Adds a message to the FacesContext Request Object.  These will be displayed on page by use of
     * the &lt;h:messages/&gt; tag, or the Trinidad equivalent.
     *
     * @param msgId The unique id for this message, such as 'LGN-01' for unknown user.
     * @param errorSummary  The short message description, such as 'Login Failed!".
     * @param detailedMessage The detailed message, such as 'The user does not exist in the system.  Please check your credentials and try again.'.
     */
    public static void addError(String msgId, String errorSummary, String detailedMessage) {
        FacesContext.getCurrentInstance().addMessage(msgId,
                                                     new FacesMessage(FacesMessage.SEVERITY_ERROR, 
                                                                      errorSummary, 
                                                                      errorSummary.equals(detailedMessage) ? "" : detailedMessage));
    }

    /**
     * Adds a message to the FacesContext Request Object.  These will be displayed on page by use of
     * the &lt;h:messages/&gt; tag, or the Trinidad equivalent.
     *
     * @param msgId The unique id for this message, such as 'LGN-01' for unknown user.
     * @param infoSummary  The short message description, such as 'Login Failed!".
     * @param detailedMessage The detailed message, such as 'The user does not exist in the system.  Please check your credentials and try again.'.
     */
    public static void addInfo(String msgId, String infoSummary, String detailedMessage) {
        FacesContext.getCurrentInstance().addMessage(msgId,
                                                     new FacesMessage(FacesMessage.SEVERITY_INFO, 
                                                                      infoSummary, 
                                                                      infoSummary.equals(detailedMessage) ? "" : detailedMessage));
    }
    
    /**
     * Adds a message to the FacesContext Request Object.  These will be displayed on page by use of
     * the &lt;h:messages/&gt; tag, or the Trinidad equivalent.
     *
     * @param msgId The unique id for this message, such as 'LGN-01' for unknown user.
     * @param warningSummary  The short message description, such as 'Login Failed!".
     * @param detailedMessage The detailed message, such as 'The user does not exist in the system.  Please check your credentials and try again.'.
     */
    public static void addWarning(String msgId, String warningSummary, String detailedMessage) {
        FacesContext.getCurrentInstance().addMessage(msgId,
                                                     new FacesMessage(FacesMessage.SEVERITY_WARN, 
                                                                      warningSummary, 
                                                                      warningSummary.equals(detailedMessage) ? "" : detailedMessage));
    }
    
    /**
     * Adds a message to the FacesContext Request Object.  These will be displayed on page by use of
     * the &lt;h:messages/&gt; tag, or the Trinidad equivalent.
     *
     * @param msgId The unique id for this message, such as 'DB-01' for unknown user.
     * @param fatalSummary  The short message description, such as 'Database Unavailable!".
     * @param detailedMessage The detailed message, such as 'The application Database is offline or unreachable.'.
     */
    public static void addFatal(String msgId, String fatalSummary, String detailedMessage) {
        FacesContext.getCurrentInstance().addMessage(msgId,
                                                     new FacesMessage(FacesMessage.SEVERITY_FATAL, 
                                                                      fatalSummary, 
                                                                      fatalSummary.equals(detailedMessage) ? "" : detailedMessage));
    }
}
