package gov.va.fnod.session;

import java.text.MessageFormat;
import java.util.Date;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

import org.apache.log4j.Logger;

/**
 * Application Lifecycle Listener implementation class SessionLoggingListener
 *
 */
public class SessionLoggingListener implements HttpSessionListener {

	private static Logger log = Logger.getLogger(SessionLoggingListener.class);
	
    public SessionLoggingListener() {
    	super();
    }

    public void sessionCreated(HttpSessionEvent event) {
    	log.trace(new MessageFormat("Session ID {0} created at {1}").format(new Object[] {event.getSession().getId(), new Date()}));
    }
    
    /**
     * On session destroy, log the ID, time created, minutes since creation, and minutes since accessed.  This should give admins an idea
     * of whether session reclamation and timeout is working.
     */
    public void sessionDestroyed(HttpSessionEvent event) {
    	HttpSession session = event.getSession();
    	long sessionLengthMinutes = (System.currentTimeMillis() - session.getCreationTime()) / 1000 / 60;
    	long sessionIdleTimeMinutes = (System.currentTimeMillis() - session.getLastAccessedTime()) / 1000 / 60;
        log.trace(new MessageFormat("Session ID {0} destroyed at {1}: created {2} minutes ago, accessed {3} minutes ago").format(new Object[] {
        																										session.getId(), 
        																										new Date(),
        																										sessionLengthMinutes,
        																										sessionIdleTimeMinutes
        																										}));
    }
	
}
