package gov.va.fnod.servlet;



import gov.va.fnod.util.FileCacheBean;



import java.io.BufferedInputStream;

import java.io.Closeable;

import java.io.IOException;

import java.io.InputStream;

import java.io.OutputStream;



import javax.servlet.Servlet;

import javax.servlet.ServletException;

import javax.servlet.http.HttpServlet;

import javax.servlet.http.HttpServletRequest;

import javax.servlet.http.HttpServletResponse;



/**

 * Servlet loads the file from a path and streams the file to HttpServletResponse

 */

public class PdfServlet extends HttpServlet implements Servlet {



	private static final int DEFAULT_BUFFER_SIZE = 8192;//8KB

	

	private static final long serialVersionUID = 1L;

	

	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {



		//get the file cache from session

		FileCacheBean filecache =  (FileCacheBean) request.getSession().getAttribute("filecache"); 

		

		// Get file path

		String pdfFileName = request.getPathInfo().substring(1);

		if( pdfFileName == null ) {

			// We don't have a filename

			response.reset();

			response.setContentType("text/html");				

			response.getOutputStream().write("<html><body>Unable to load cached file.</body></html>".getBytes("utf-8"));

			return;

		}



		response.reset();

			

		// Using buffered input stream to ensure mark operations are supported

		BufferedInputStream input = null;

		OutputStream output = null;

			

		try {

			input = new BufferedInputStream(filecache.getInputStream(pdfFileName),DEFAULT_BUFFER_SIZE);			

			output = response.getOutputStream();	

			

			if ( isPdf( input ) ) {

				response.setContentType("application/pdf");

				response.setHeader("Content-disposition", "inline; filename=\"" + pdfFileName + "\"");

				writeOutPdf(input,output);

			} else {

				response.setContentType("text/html");				

				output.write("<html><body>Invalid PDF Encountered.  Please contact an Administrator.</body></html>".getBytes("utf-8"));								

			}

			

		} catch (Exception ex) {

			

			response.reset();

			response.setContentType("text/html");				

			response.getOutputStream().write("<html><body>Unable to load cached file.</body></html>".getBytes("utf-8"));

			

		} finally {

			//close streams

			close(output);

			close(input);

		}			

	}



	/**

	 * Read the first four bytes from the buffer, marking the position so that the

	 * stream can be reset (peeking 4 bytes ahead) allowing for confirmation that

	 * the file is actually a PDF file. 

	 * 

	 * @param input

	 * @return

	 */

	private boolean isPdf(BufferedInputStream input) {

		boolean retval = false;

	

		try {

			try {

				input.mark(4);

				byte[] bytes = new byte[4];

				int bytesRead = input.read(bytes);

				if ( bytesRead == 4 && "%PDF".equals(new String(bytes)) ) {

					retval = true;

				} 	

			} finally {

				input.reset();

			}

		} catch (IOException ex) {

			// at this point we just want to return false.

		}



		return retval;

		

	}

	

	public void writeOutPdf(InputStream input, OutputStream output) throws IOException {

		//write file contents to response

		byte[] buffer = new byte[DEFAULT_BUFFER_SIZE];

		int length;

		while((length = input.read(buffer)) > 0) {

			output.write(buffer, 0, length);

		}

	}

	/**

	 * Close the resources

	 * @param resource

	 */

	private void close(Closeable resource) {

		if(resource != null) {

			try {

				resource.close();

			} catch (IOException e) {

				throw new RuntimeException("Failed to close the resource");

			}

		}		

	}	

}