package gov.va.fnod.soa_web.util;

import static org.junit.Assert.*;
import gov.va.fnod.soa_common.model.fnod.PersonName;

import org.junit.Test;

public class FnodPayloadModelMappingHelperTest {

	@Test
	public void test2ElementPersonNameParsing() {
		// first name - last name
		String name = "David White";
		PersonName pn = FnodPayloadModelMappingHelper.CreatePersonNameFromCaseInsName(name);
		
		assertEquals("Testing 2 element name, first name expected: David; Actual: " +pn.getFirstName(), "David", pn.getFirstName());
		assertEquals("Testing 2 element name, last name expected: White; Actual: " +pn.getLastName(), "White", pn.getLastName());
		
	}
	
	@Test
	public void test3ElementPersonNameParsing() {
		// first midde and last name
		String name = "David A White";
		PersonName pn = FnodPayloadModelMappingHelper.CreatePersonNameFromCaseInsName(name);
		
		assertEquals("Testing 3 element name", "David", pn.getFirstName());
		assertEquals("Testing 3 element name", "White", pn.getLastName());
		assertEquals("Testing 3 element name", "A", pn.getMiddleName());
		
	}
	
	
	@Test
	public void test4ElementPersonNameParsing() {
		// first midde and last name
		String name = "David A R White";
		PersonName pn = FnodPayloadModelMappingHelper.CreatePersonNameFromCaseInsName(name);
		
		assertEquals("Testing 4 element name", "David", pn.getFirstName());
		assertEquals("Testing 4 element name", "White", pn.getLastName());
		assertEquals("Testing 4 element name", "A R", pn.getMiddleName());
		
	}
	
	
	@Test
	public void testComplexLastNameParsing() {
		// first midde and last name
		String name = "Rueben Von Stueben";
		PersonName pn = FnodPayloadModelMappingHelper.CreatePersonNameFromCaseInsName(name);
		
		assertEquals("Testing Complex Last name", "Rueben", pn.getFirstName());
		assertEquals("Testing Complex Last name", "Von Stueben", pn.getLastName());
		
		
	}
	
	@Test
	public void testComplexFirstNameParsing() {
		// first midde and last name
		String name = "Billy Bob Thorton";
		PersonName pn = FnodPayloadModelMappingHelper.CreatePersonNameFromCaseInsName(name);
		
		assertEquals("Testing Complex First name", "Billy Bob", pn.getFirstName());
		assertEquals("Testing Complex First name", "Thorton", pn.getLastName());
		
		
	}
	
	@Test
	public void testComplexLastNameWithMiddleInitialParsing() {
		// first middle and last name
		String name = "Rueben A Von Stueben";
		PersonName pn = FnodPayloadModelMappingHelper.CreatePersonNameFromCaseInsName(name);
		
		assertEquals("Testing Complex Last name w/middle initial", "Rueben", pn.getFirstName());
		assertEquals("Testing Complex Last name w/middle initial", "Von Stueben", pn.getLastName());
		assertEquals("Testing Complex Last name w/middle initial", "A", pn.getMiddleName());
		
		
	}
	
	@Test
	public void testComplexFirstNameWithMiddleInitialParsing() {
		// first middle and last name
		String name = "Billy Bob A Thorton";
		PersonName pn = FnodPayloadModelMappingHelper.CreatePersonNameFromCaseInsName(name);
		
		assertEquals("Testing Complex First name w/middle initial", "Billy Bob", pn.getFirstName());
		assertEquals("Testing Complex First name w/middle initial", "Thorton", pn.getLastName());
		assertEquals("Testing Complex First name w/middle initial", "A", pn.getMiddleName());
		
		
	}
	
	@Test
	public void testComplexLastNameWithMiddleInitialAndSuffixParsing() {
		// first middle and last name
		String name = "Rueben A Von Stueben Sr";
		PersonName pn = FnodPayloadModelMappingHelper.CreatePersonNameFromCaseInsName(name);
		
		assertEquals("Testing Complex Last name w/middle initial", "Rueben", pn.getFirstName());
		assertEquals("Testing Complex Last name w/middle initial", "Von Stueben", pn.getLastName());
		assertEquals("Testing Complex Last name w/middle initial", "A", pn.getMiddleName());
		assertEquals("Testing Complex Last name w/middle initial and suffix", "Sr", pn.getSuffix());
		
	}
	
	@Test
	public void testComplexFirstNameWithMiddleInitialAndSuffixParsing() {
		// first middle and last name
		String name = "Billy Bob A Thorton Jr";
		PersonName pn = FnodPayloadModelMappingHelper.CreatePersonNameFromCaseInsName(name);
		
		assertEquals("Testing Complex First name w/middle initial and suffix", "Billy Bob", pn.getFirstName());
		assertEquals("Testing Complex First name w/middle initial and suffix", "Thorton", pn.getLastName());
		assertEquals("Testing Complex First name w/middle initial and suffix", "A", pn.getMiddleName());
		assertEquals("Testing Complex First name w/middle initial and suffix", "Jr", pn.getSuffix());
		
		
	}
	
	@Test
	public void testComplexInitialFirstNameWithMiddleInitialAndSuffixParsing() {
		// first middle and last name
		String name = "T J Thorton Jr";
		PersonName pn = FnodPayloadModelMappingHelper.CreatePersonNameFromCaseInsName(name);
		
		assertEquals("Testing Complex First name w/middle initial and suffix", "T", pn.getFirstName());
		assertEquals("Testing Complex First name w/middle initial and suffix", "Thorton", pn.getLastName());
		assertEquals("Testing Complex First name w/middle initial and suffix", "J", pn.getMiddleName());
		assertEquals("Testing Complex First name w/middle initial and suffix", "Jr", pn.getSuffix());
		
		
	}
	
	@Test
	public void testReallyReallyComplexName() {
		// first middle and last name
		String name = "Red Baron Manfred T J Von Richthofen Jr";
		PersonName pn = FnodPayloadModelMappingHelper.CreatePersonNameFromCaseInsName(name);
		
		assertEquals("Testing Really Really Complex name and suffix", "Red Baron Manfred", pn.getFirstName());
		assertEquals("Testing Really Really Complex name and suffix", "Von Richthofen", pn.getLastName());
		assertEquals("Testing Really Really Complex name and suffix", "T J", pn.getMiddleName());
		assertEquals("Testing Really Really Complex name and suffix", "Jr", pn.getSuffix());
		
	}
	
	@Test
	public void testParsingSingleWordCityName() {
		// Miami FL
		String name = "Miami FL";
		String ret = FnodPayloadModelMappingHelper.ParseCityNameFromString(name);
		
		assertEquals("Testing Single Word City Name parsing", "Miami", ret);
		
	}
	
	
	@Test
	public void testParsingMultipleWordCityName() {
		// Miami FL
		String name = "Fort Worth TX";
		String ret = FnodPayloadModelMappingHelper.ParseCityNameFromString(name);
		
		assertEquals("Testing Multiple Word City Name parsing", "Fort Worth", ret);
		
	}
	
	@Test
	public void testParsingStateName() {
		// Miami FL
		String name = "Fort Worth TX";
		String ret = FnodPayloadModelMappingHelper.ParseStateNameFromString(name);
		
		assertEquals("Testing State Name parsing", "TX", ret);
		
	}

}
