package gov.va.fnod.soa_web.ws;

import gov.va.fnod.model.fnoddata.CaseType;
import gov.va.fnod.model.fnoddata.RegionalOffice;
import gov.va.fnod.model.fnoddata.SourceSystem;
import gov.va.fnod.service.LookupSession;

public class LookupModelObjectsBean {
	
	private LookupSession lookupSession;
	
	public LookupModelObjectsBean(LookupSession lookupSession) {
		this.lookupSession = lookupSession;
	}
	
	public CaseType getCaseType(String caseTypeCd) {
		return (CaseType) lookupSession.getCaseTypeByCd(caseTypeCd);
	}
	
	public SourceSystem getSourceSystem(String sourceSystemCd) {
		return (SourceSystem) lookupSession.getSourceSystemByCd(sourceSystemCd);
	}
	
	public RegionalOffice getRegionalOfficeByRegionalOfficeNum(Integer regionalOfficeNum) {
		return (RegionalOffice) lookupSession.getRegionalOfficeByRegionalOfficeNum(regionalOfficeNum);
	}

}
