package gov.va.fnod.soa_web.ws;

import gov.va.fnod.model.fnoddata.CaseAddress;
import gov.va.fnod.model.fnoddata.CaseData;
import gov.va.fnod.model.fnoddata.CaseInsurance;
import gov.va.fnod.model.fnoddata.CaseLink;
import gov.va.fnod.model.fnoddata.CaseType;
import gov.va.fnod.model.fnoddata.SourceSystem;
import gov.va.fnod.soa_common.model.fnod.Address;
import gov.va.fnod.soa_common.model.fnod.CaseTypeCd;
import gov.va.fnod.soa_common.model.fnod.Cemetery;
import gov.va.fnod.soa_common.model.fnod.Decedent;
import gov.va.fnod.soa_common.model.fnod.Fnod;
import gov.va.fnod.soa_common.model.fnod.FnodCase;
import gov.va.fnod.soa_common.model.fnod.FnodPayload;
import gov.va.fnod.soa_common.model.fnod.Insurance;
import gov.va.fnod.soa_common.model.fnod.Person;
import gov.va.fnod.soa_common.model.fnod.PersonName;
import gov.va.fnod.soa_common.model.fnod.Veteran;
import gov.va.fnod.soa_web.exception.CustomSOAPFaultException;
import gov.va.fnod.soa_web.util.FnodPayloadModelMappingHelper;
import gov.va.fnod.soa_web.util.WebSrvcConstants;

import java.sql.Timestamp;
import java.util.Date;

import javax.xml.datatype.XMLGregorianCalendar;

public class FnodPayloadModelMapping {
	private final String myClassName = "FnodPayloadModelMapping";
	private CustomSOAPFaultException soapFaultException;
	
	public FnodPayloadModelMapping() {
		
	}
	
	public CaseLink mapFnodToModel(FnodPayload fnodPayload, CaseType caseType, SourceSystem sourceSystem) {
		
		// Create new CaseLink
		CaseLink caseLink = new CaseLink();
		caseLink.setCaseType(caseType);
		caseLink.setSourceSystem(sourceSystem);
		caseLink.setSrcTable("A"); // What is the source table info come from???
		caseLink.setLoadDate(new Timestamp(new Date().getTime()));
		
		FnodCase fnodCase = fnodPayload.getFnodCase();
		String fnodCaseType = fnodCase.getCaseTypeCd().value();
		
		// If FNOD Case Type is Insurance
		if ( CaseTypeCd.INSURANCE_REPORT.value().equals(fnodCaseType) || CaseTypeCd.PRUDENTIAL_INSURANCE.value().equals(fnodCaseType) ) {
			Insurance insurance = fnodCase.getInsurance();
			if (insurance == null) {
				soapFaultException = new CustomSOAPFaultException();
				soapFaultException.createSOAPFaultExceptionClient("Illegal Argument: The Insurance object cannot be null for FNOD insurance cases.");
			}
			CaseInsurance caseInsurance = new CaseInsurance();
			caseInsurance.setCaseLink(caseLink);
			caseInsurance.setEntryDt(convertDateToTimeStamp(fnodCase.getReportedDate()));
			caseInsurance.setVeteranName(insurance.getVeteranName());
			caseInsurance.setNameAddressLine1(insurance.getNameAndAddressLine1());
			caseInsurance.setNameAddressLine2(insurance.getNameAndAddressLine2());
			caseInsurance.setNameAddressLine3(insurance.getNameAndAddressLine3());
			caseInsurance.setNameAddressLine4(insurance.getNameAndAddressLine4());
			caseInsurance.setNameAddressLine5(insurance.getNameAndAddressLine5());
			caseInsurance.setCityAndState(insurance.getCityAndState());
			caseInsurance.setZipOrForeignCode(insurance.getZipOrForeignCode());
			caseInsurance.setVeteranDateOfBirth(insurance.getDateOfBirth());
			caseInsurance.setVeteranDateOfDeath(insurance.getDateOfDeath());
			caseInsurance.setVeteranClaimNumber(insurance.getClaimNumber());
			caseInsurance.setVeteranSocialSecurityNumber(insurance.getSocialSecurityNumber());
			caseInsurance.setVeteranMilitaryServiceNumber(insurance.getServiceNumber());
			caseInsurance.setInsuranceFileNumber(insurance.getInsuranceFileNumber());
			caseInsurance.setSpouseName(insurance.getSpouseName());
			caseInsurance.setSpouseAddressLine1(insurance.getSpouseAddressLine1());
			caseInsurance.setSpouseAddressLine2(insurance.getSpouseAddressLine2());
			caseInsurance.setSpouseAddressLine3(insurance.getSpouseAddressLine3());
			caseInsurance.setSpouseCityAndState(insurance.getSpouseCityAndState());
			caseInsurance.setSpouseZip(insurance.getSpouseZip());
			
			caseLink.setCaseInsurance(caseInsurance);
			
			// case data
			
			CaseData caseData = new CaseData();
			caseData.setCaseLink(caseLink);
			caseData.setEntryDt(convertDateToTimeStamp(fnodCase.getReportedDate()));
			caseData.setSourceUserId(fnodCase.getUserId());
			caseData.setVeteranHomeOfRecordCity(FnodPayloadModelMappingHelper.ParseCityNameFromString(insurance.getCityAndState()));
			caseData.setVeteranHomeOfRecordState(FnodPayloadModelMappingHelper.ParseStateNameFromString(insurance.getCityAndState()));
			
			
			
			// create veteran person
			caseData.setVeteranPerson(FnodPayloadModelMappingHelper.CreateVeteranRecordFromInsuranceRecord(caseInsurance));
			
			// create veteran
			gov.va.fnod.model.fnoddata.Veteran veteranModel = new gov.va.fnod.model.fnoddata.Veteran();
			veteranModel.setMilitaryServiceNum(insurance.getServiceNumber());
			veteranModel.setClaimNum(insurance.getClaimNumber());
			caseData.setVeteran(veteranModel);
			
			// create vet address 
			caseLink.addCaseAddress(FnodPayloadModelMappingHelper.CreateVeteranAddress(insurance, caseData, WebSrvcConstants.ADDR_TYPE_VET));

			// create vet spouse
			caseData.setSpousePerson(FnodPayloadModelMappingHelper.CreateSpouseRecordFromInsuranceRecord(caseInsurance));
			// create vet spouse address 
			caseLink.addCaseAddress(FnodPayloadModelMappingHelper.CreateVeteranAddress(insurance, caseData, WebSrvcConstants.ADDR_TYPE_SPOUSE));

			caseLink.setCaseData(caseData);
		}
		
		// If FNOD Case Type is FNOD or FNOD Spouse
		if (CaseTypeCd.FNOD.value().equals(fnodCaseType) || CaseTypeCd.FNOD_SPOUSE.value().equals(fnodCaseType)) {
			Fnod fnod = fnodCase.getFnod();
			if (fnod == null) {
				soapFaultException = new CustomSOAPFaultException();
				soapFaultException.createSOAPFaultExceptionClient("Illegal Argument: The FNOD object cannot be null for FNOD cases.");
			}
			CaseData caseData = new CaseData();
			caseData.setCaseLink(caseLink);
			caseData.setEntryDt(convertDateToTimeStamp(fnodCase.getReportedDate()));
			caseData.setSourceUserId(fnodCase.getUserId());
			caseData.setVeteranHomeOfRecordCity(fnod.getCityHomeOfRecord());
			caseData.setVeteranHomeOfRecordState(fnod.getStateHomeOfRecored());
			
			// Set Veteran object
			Veteran veteran = fnod.getVeteran();
			if (veteran != null) {
				gov.va.fnod.model.fnoddata.Veteran veteranModel = new gov.va.fnod.model.fnoddata.Veteran();
				veteranModel.setAliasLastName(veteran.getAliasLastName());
				veteranModel.setBranchOfServiceCd(veteran.getBranchOfService());
				veteranModel.setRankCd(veteran.getRank());
				veteranModel.setMilitaryServiceNum(veteran.getServiceNumber());
				veteranModel.setClaimNum(veteran.getClaimNumber());
				veteranModel.setEnteredOnActiveDutyDt(new Date(veteran.getEnteredOnActiveDutyDate().getMillisecond()));
				veteranModel.setReleasedFromActiveDutyDt(new Date(veteran.getReleasedFromActiveDutyDate().getMillisecond()));
				veteranModel.setWarPeriodCd(veteran.getWarPeriod());
				veteranModel.setVeteranId(veteran.getVeteranId());
				caseData.setVeteran(veteranModel);
			}
			
			//Set Veteran Person object
			Person veteranPerson = veteran.getPerson();
			if (veteranPerson != null) {
				gov.va.fnod.model.fnoddata.Person veteranPersonModel = new gov.va.fnod.model.fnoddata.Person();
				veteranPersonModel = new gov.va.fnod.model.fnoddata.Person();
				veteranPersonModel.setSocialSecurityNumber(veteranPerson.getSocialSecurityNumber());
				veteranPersonModel.setDecedentId(veteranPerson.getDecedentId());
				veteranPersonModel.setBirthDt(new Date(veteranPerson.getDateOfBirth().getMillisecond()));
				veteranPersonModel.setDeathDt(new Date(veteranPerson.getDateOfDeath().getMillisecond()));
				veteranPersonModel.setRecordOfIntermentDt(new Date(veteranPerson.getDateOfInterment().getMillisecond()));

				PersonName veteranPersonName = veteranPerson.getName();
				if (veteranPersonName != null) {
					veteranPersonModel.setFirstName(veteranPersonName.getFirstName());
					veteranPersonModel.setLastName(veteranPersonName.getLastName());
					veteranPersonModel.setMiddleName(veteranPersonName.getMiddleName());
					veteranPersonModel.setSuffixName(veteranPersonName.getSuffix());
				}
				caseData.setVeteranPerson(veteranPersonModel);
			}
			
			// Set Veteran Address object
			Address veteranAddress = veteran.getAddress();
			if (veteranAddress != null) {
				CaseAddress veteranCaseAddressModel = new CaseAddress();
				veteranCaseAddressModel.setAddressType(WebSrvcConstants.ADDR_TYPE_VET);
				gov.va.fnod.model.fnoddata.Address veteranAddressModel = new gov.va.fnod.model.fnoddata.Address();
				veteranAddressModel.setLine1(veteranAddress.getLine1());
				veteranAddressModel.setLine2(veteranAddress.getLine2());
				veteranAddressModel.setLine3(veteranAddress.getLine3());
				veteranAddressModel.setLine4(veteranAddress.getLine4());
				veteranAddressModel.setLine5(veteranAddress.getLine5());
				veteranAddressModel.setCity(veteranAddress.getCity());
				veteranAddressModel.setStateProvCd(veteranAddress.getStateOrProvidence());
				veteranAddressModel.setZipCode(veteranAddress.getPostalCode());
				veteranAddressModel.setForeignMailCode(veteranAddress.getForeignMailCode());
				veteranCaseAddressModel.setAddress(veteranAddressModel);
				caseLink.addCaseAddress(veteranCaseAddressModel);
			}
			
			// Set Veteran Cemetery object
			Cemetery cemetery = veteran.getCemetery();
			if (cemetery != null) {
				caseData.setCemeteryName(cemetery.getName());
				caseData.setCemeteryNum(cemetery.getNumber());
				caseData.setCemeteryType(cemetery.getType());
			}
			
			// FNOD is FNOD_SPOUSE
			if (CaseTypeCd.FNOD_SPOUSE.value().equals(fnodCaseType)) {
				Decedent decedent = fnod.getDecedent();
				if (decedent == null) {
					soapFaultException = new CustomSOAPFaultException();
					soapFaultException.createSOAPFaultExceptionClient("Illegal Argument: The Spouse (Decedent) object cannot be null for FNOD Spouse cases.");
				}
				// Set Spouse Person object
				Person decedentPerson = decedent.getPerson();
				if (decedentPerson != null) {
					gov.va.fnod.model.fnoddata.Person spousePersonModel = new gov.va.fnod.model.fnoddata.Person();
					spousePersonModel.setSocialSecurityNumber(decedentPerson.getSocialSecurityNumber());
					spousePersonModel.setDecedentId(decedentPerson.getDecedentId());
					spousePersonModel.setBirthDt(new Date(decedentPerson.getDateOfBirth().getMillisecond()));
					spousePersonModel.setDeathDt(new Date(decedentPerson.getDateOfDeath().getMillisecond()));
					spousePersonModel.setRecordOfIntermentDt(new Date(decedentPerson.getDateOfInterment().getMillisecond()));
					
					PersonName decedentPersonName = decedentPerson.getName();
					if (decedentPersonName != null) {
						spousePersonModel.setFirstName(decedentPersonName.getFirstName());
						spousePersonModel.setLastName(decedentPersonName.getLastName());
						spousePersonModel.setMiddleName(decedentPersonName.getMiddleName());
						spousePersonModel.setSuffixName(decedentPersonName.getSuffix());
					}
					// Set Spouse to Case Data
					caseData.setSpousePerson(spousePersonModel);
				}
				
				
				// Set Spouse Address object
				Address decedentAddress = decedent.getAddress();
				if (decedentAddress != null) {
					CaseAddress spouseCaseAddressModel = new CaseAddress();
					spouseCaseAddressModel.setAddressType(WebSrvcConstants.ADDR_TYPE_SPOUSE);
					gov.va.fnod.model.fnoddata.Address spouseAddressModel = new gov.va.fnod.model.fnoddata.Address();
					spouseAddressModel.setLine1(decedentAddress.getLine1());
					spouseAddressModel.setLine2(decedentAddress.getLine2());
					spouseAddressModel.setLine3(decedentAddress.getLine3());
					spouseAddressModel.setLine4(decedentAddress.getLine4());
					spouseAddressModel.setLine5(decedentAddress.getLine5());
					spouseAddressModel.setCity(decedentAddress.getCity());
					spouseAddressModel.setStateProvCd(decedentAddress.getStateOrProvidence());
					spouseAddressModel.setZipCode(decedentAddress.getPostalCode());
					spouseAddressModel.setForeignMailCode(decedentAddress.getForeignMailCode());
					spouseCaseAddressModel.setAddress(spouseAddressModel);
					caseLink.addCaseAddress(spouseCaseAddressModel);
				}
			}
			// Set Case Data
			caseLink.setCaseData(caseData);
		}
		return caseLink;
	}
	
	private Timestamp convertDateToTimeStamp(XMLGregorianCalendar date) {
		if (date == null) {
			return null; 
		}
		return new Timestamp(date.getMillisecond());
		
	}
	

}
