package gov.va.fnod.soa_web.ws;


import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;

import gov.va.cem.docstorage.service.DocumentStorageSession;
import gov.va.fnod.soa_common.model.flagapp.FlagAppPayload;
import gov.va.fnod.soa_web.exception.CustomSOAPFaultException;

public class FnodDocStorage {
	
	// TODO Cleanup
	//private static final String FLAG_APPLICATION = "FLAG_APPLICATION";
	
	private DocumentStorageSession documentStorageSession;
	private CustomSOAPFaultException soapFaultException;
	
	public FnodDocStorage(DocumentStorageSession documentStorageSession) {
		this.documentStorageSession = documentStorageSession;
	}
	
	public void uploadDocument(FlagAppPayload flagAppPayload) {
		
		// Check if MD5 Checksums match
		String md5Checksum = flagAppPayload.getFlagApp().getMd5Checksum();
		
		byte[] base64encodedDoc = flagAppPayload.getFlagApp().getPdfFile();
		byte[] pdfDocument = Base64.decodeBase64(base64encodedDoc);
		
		String md5 = DigestUtils.md5Hex(pdfDocument);
		if (!md5Checksum.equalsIgnoreCase(md5)){
			soapFaultException = new CustomSOAPFaultException();
			soapFaultException.createSOAPFaultExceptionClient("Bad Request: The MD5 Checksum for the file did not match.");
		}
		
		// Create temporary directory and file and upload to Document Storage.
		String documentName = flagAppPayload.getFlagApp().getFileName();
		File tempDir = new File(System.getProperty("java.io.tmpdir"));
		File tempFile = new File(tempDir, documentName);		

		try{
			OutputStream output = null;
		try {
			output = new BufferedOutputStream(new FileOutputStream(tempFile));
			output.write(pdfDocument);
		}finally{
			output.close();
		}}catch (FileNotFoundException e) {
			soapFaultException = new CustomSOAPFaultException();
			soapFaultException.createSOAPFaultExceptionServer("Internal Server: The file was not found");
		} catch (IOException e) {
			soapFaultException = new CustomSOAPFaultException();
			soapFaultException.createSOAPFaultExceptionServer("Internal Server: A failure occured when creating the FNOD case.");
		}
		
		if(tempFile.exists()){
			String tempDocument = tempFile.getAbsolutePath();
			long docStorageId = documentStorageSession.addDocument(Constants.SYSTEM_NAME, documentName, tempDocument);
			
			// Add docStorageId to FlagApp object, delete temporary file and return FnodPayload.
			System.out.println("New DocStorageId: " + docStorageId);
			flagAppPayload.getFlagApp().setDocStorageId(docStorageId);
			tempFile.delete();
		}
		else{
			soapFaultException = new CustomSOAPFaultException();
			soapFaultException.createSOAPFaultExceptionServer("Internal Server: A serious failure occured when creating the FNOD case.");
			throw new RuntimeException("test setup failure");
		}
	}
}
